/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    Font font;
    Font[] cellFont;
    boolean cached;
    boolean grayed;

    public TableItem(Table table, int n, int n2) {
        this(table, n, n2, true);
    }

    public TableItem(Table table, int n) {
        this(table, n, TableItem.checkNull(table).getItemCount(), true);
    }

    TableItem(Table table, int n, int n2, boolean bl) {
        super(table, n);
        this.parent = table;
        if (bl) {
            table.createItem(this, n2);
        } else {
            this.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
            OS.gtk_tree_model_iter_nth_child(table.modelHandle, this.handle, 0, n2);
        }
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    Color _getBackground() {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 3, nArray, -1);
        if (nArray[0] == 0) {
            return this.parent.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, nArray[0], GdkColor.sizeof);
        OS.gdk_color_free(nArray[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Color _getBackground(int n) {
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this._getBackground();
        }
        int[] nArray = new int[1];
        int n3 = this.parent.columnCount == 0 ? 5 : this.parent.columns[n].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 3, nArray, -1);
        if (nArray[0] == 0) {
            return this._getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, nArray[0], GdkColor.sizeof);
        OS.gdk_color_free(nArray[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    boolean _getChecked() {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 0, nArray, -1);
        return nArray[0] != 0;
    }

    Color _getForeground() {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 2, nArray, -1);
        if (nArray[0] == 0) {
            return this.parent.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, nArray[0], GdkColor.sizeof);
        OS.gdk_color_free(nArray[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Color _getForeground(int n) {
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this._getForeground();
        }
        int[] nArray = new int[1];
        int n3 = this.parent.columnCount == 0 ? 5 : this.parent.columns[n].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 2, nArray, -1);
        if (nArray[0] == 0) {
            return this._getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, nArray[0], GdkColor.sizeof);
        OS.gdk_color_free(nArray[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Image _getImage(int n) {
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return null;
        }
        int[] nArray = new int[1];
        int n3 = this.parent.columnCount == 0 ? 5 : this.parent.columns[n].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 0, nArray, -1);
        if (nArray[0] == 0) {
            return null;
        }
        ImageList imageList = this.parent.imageList;
        int n4 = imageList.indexOf(nArray[0]);
        OS.g_object_unref(nArray[0]);
        if (n4 == -1) {
            return null;
        }
        return imageList.get(n4);
    }

    String _getText(int n) {
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return "";
        }
        int[] nArray = new int[1];
        int n3 = this.parent.columnCount == 0 ? 5 : this.parent.columns[n].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 1, nArray, -1);
        if (nArray[0] == 0) {
            return "";
        }
        int n4 = OS.strlen(nArray[0]);
        byte[] byArray = new byte[n4];
        OS.memmove(byArray, nArray[0], n4);
        OS.g_free(nArray[0]);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        if (this.parent.currentItem == this) {
            return;
        }
        if (this.cached || (this.parent.style & 0x10000000) == 0) {
            int n = OS.gtk_tree_model_get_n_columns(this.parent.modelHandle);
            int n2 = 0;
            while (n2 < n) {
                OS.gtk_list_store_set(this.parent.modelHandle, this.handle, n2, 0, -1);
                ++n2;
            }
            if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2) && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
                this.redraw();
            }
        }
        this.cached = false;
        this.font = null;
        this.cellFont = null;
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground();
    }

    public Rectangle getBounds() {
        int n;
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((n2 = OS.gtk_tree_view_get_column(n = this.parent.handle, 0)) == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = this.parent.getTextRenderer(n2);
        int n4 = this.parent.getPixbufRenderer(n2);
        if (n3 == 0 || n4 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n5 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(n);
        boolean bl = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean bl2 = OS.gtk_tree_view_row_expanded(n, n5);
        OS.gtk_tree_view_column_cell_set_cell_data(n2, this.parent.modelHandle, this.handle, bl, bl2);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(n, n5, n2, gdkRectangle);
        OS.gtk_tree_path_free(n5);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        int n6 = gdkRectangle.x + gdkRectangle.width;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.parent.ignoreSize = true;
        OS.gtk_cell_renderer_get_size(n3, n, null, null, null, nArray2, null);
        this.parent.ignoreSize = false;
        gdkRectangle.width = nArray2[0];
        int[] nArray3 = new int[1];
        if (OS.gtk_tree_view_get_expander_column(n) == n2) {
            OS.gtk_widget_style_get(n, OS.expander_size, nArray3, 0);
            gdkRectangle.x += nArray3[0] + 4;
        }
        OS.gtk_widget_style_get(n, OS.horizontal_separator, nArray3, 0);
        int n7 = nArray3[0];
        gdkRectangle.x += n7;
        if (OS.GTK_VERSION >= OS.VERSION(2, 1, 3)) {
            OS.gtk_tree_view_column_cell_get_position(n2, n3, nArray, null);
            gdkRectangle.x += nArray[0];
        } else {
            if ((this.parent.style & 0x20) != 0) {
                OS.gtk_cell_renderer_get_size(this.parent.checkRenderer, n, null, null, null, nArray2, null);
                gdkRectangle.x += nArray2[0] + n7;
            }
            OS.gtk_cell_renderer_get_size(n4, n, null, null, null, nArray2, null);
            gdkRectangle.x += nArray2[0] + n7;
        }
        if (this.parent.columnCount > 0 && gdkRectangle.x + gdkRectangle.width > n6) {
            gdkRectangle.width = Math.max(0, n6 - gdkRectangle.x);
        }
        int n8 = OS.gtk_tree_view_column_get_visible(n2) ? gdkRectangle.width + 1 : 0;
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, n8, gdkRectangle.height + 1);
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground(n);
    }

    public Rectangle getBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = this.parent.handle;
        int n3 = 0;
        n3 = n >= 0 && n < this.parent.columnCount ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n2, n);
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n4 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(n2);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(n2, n4, n3, gdkRectangle);
        OS.gtk_tree_path_free(n4);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        if (n == 0 && (this.parent.style & 0x20) != 0) {
            int[] nArray;
            if (OS.GTK_VERSION >= OS.VERSION(2, 1, 3)) {
                nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.gtk_tree_view_column_cell_get_position(n3, this.parent.checkRenderer, nArray, nArray2);
                gdkRectangle.x += nArray[0] + nArray2[0];
                gdkRectangle.width -= nArray[0] + nArray2[0];
            } else {
                nArray = new int[1];
                OS.gtk_cell_renderer_get_size(this.parent.checkRenderer, n2, null, null, null, nArray, null);
                int[] nArray3 = new int[1];
                OS.gtk_widget_style_get(n2, OS.horizontal_separator, nArray3, 0);
                gdkRectangle.x += nArray[0] + nArray3[0];
                gdkRectangle.width -= nArray[0] + nArray3[0];
            }
        }
        int n5 = OS.gtk_tree_view_column_get_visible(n3) ? gdkRectangle.width + 1 : 0;
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, n5, gdkRectangle.height + 1);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this._getChecked();
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n] == null) {
            return this.getFont();
        }
        return this.cellFont[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground();
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground(n);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getImage(0);
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getImage(n);
    }

    public Rectangle getImageBounds(int n) {
        int[] nArray;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = this.parent.handle;
        int n3 = 0;
        n3 = n >= 0 && n < this.parent.columnCount ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n2, n);
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n4 = this.parent.getPixbufRenderer(n3);
        if (n4 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        int n5 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(n2);
        OS.gtk_tree_view_get_cell_area(n2, n5, n3, gdkRectangle);
        OS.gtk_tree_path_free(n5);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 1, 3)) {
            nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_tree_view_column_cell_get_position(n3, n4, nArray, nArray2);
            gdkRectangle.x += nArray[0];
            gdkRectangle.width = nArray2[0];
        } else {
            nArray = new int[1];
            OS.gtk_tree_view_column_cell_set_cell_data(n3, this.parent.modelHandle, this.handle, false, false);
            OS.gtk_cell_renderer_get_size(n4, n2, null, null, null, nArray, null);
            gdkRectangle.width = nArray[0];
        }
        int n6 = OS.gtk_tree_view_column_get_visible(n3) ? gdkRectangle.width : 0;
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, n6, gdkRectangle.height + 1);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return 0;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getText(n);
    }

    public Rectangle getTextBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = this.parent.handle;
        int n4 = 0;
        n4 = n >= 0 && n < this.parent.columnCount ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n3, n);
        if (n4 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n5 = this.parent.getTextRenderer(n4);
        int n6 = this.parent.getPixbufRenderer(n4);
        if (n5 == 0 || n6 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n7 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(n3);
        boolean bl = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean bl2 = OS.gtk_tree_view_row_expanded(n3, n7);
        OS.gtk_tree_view_column_cell_set_cell_data(n4, this.parent.modelHandle, this.handle, bl, bl2);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(n3, n7, n4, gdkRectangle);
        OS.gtk_tree_path_free(n7);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        int n8 = gdkRectangle.x + gdkRectangle.width;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.parent.ignoreSize = true;
        OS.gtk_cell_renderer_get_size(n5, n3, null, null, null, nArray2, null);
        this.parent.ignoreSize = false;
        int[] nArray3 = new int[1];
        if (OS.gtk_tree_view_get_expander_column(n3) == n4) {
            OS.gtk_widget_style_get(n3, OS.expander_size, nArray3, 0);
            gdkRectangle.x += nArray3[0] + 4;
        }
        OS.gtk_widget_style_get(n3, OS.horizontal_separator, nArray3, 0);
        int n9 = nArray3[0];
        gdkRectangle.x += n9;
        if (OS.GTK_VERSION >= OS.VERSION(2, 1, 3)) {
            OS.gtk_tree_view_column_cell_get_position(n4, n5, nArray, null);
            gdkRectangle.x += nArray[0];
        } else {
            if ((this.parent.style & 0x20) != 0) {
                OS.gtk_cell_renderer_get_size(this.parent.checkRenderer, n3, null, null, null, nArray2, null);
                gdkRectangle.x += nArray2[0] + n9;
            }
            OS.gtk_cell_renderer_get_size(n6, n3, null, null, null, nArray2, null);
            gdkRectangle.x += nArray2[0] + n9;
        }
        if (this.parent.columnCount > 0 && gdkRectangle.x + gdkRectangle.width > n8) {
            gdkRectangle.width = Math.max(0, n8 - gdkRectangle.x);
        }
        int n10 = OS.gtk_tree_view_column_get_visible(n4) ? gdkRectangle.width + 1 : 0;
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, n10, gdkRectangle.height + 1);
    }

    void redraw() {
        if ((OS.GTK_WIDGET_FLAGS(this.parent.handle) & 0x40) != 0) {
            int n = this.parent.handle;
            int n2 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_tree_view_get_cell_area(n, n2, 0, gdkRectangle);
            OS.gtk_tree_path_free(n2);
            int n3 = OS.gtk_tree_view_get_bin_window(n);
            gdkRectangle.x = 0;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_drawable_get_size(n3, nArray, nArray2);
            gdkRectangle.width = nArray[0];
            OS.gdk_window_invalidate_rect(n3, gdkRectangle, false);
        }
    }

    void releaseHandle() {
        if (this.handle != 0) {
            OS.g_free(this.handle);
        }
        this.handle = 0;
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.font = null;
        this.cellFont = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this._getBackground().equals(color)) {
            return;
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 3, gdkColor, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2) && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
    }

    public void setBackground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this._getBackground(n).equals(color)) {
            return;
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = this.parent.columnCount == 0 ? 5 : this.parent.columns[n].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, n3 + 3, gdkColor, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2) && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
        if (color != null) {
            boolean bl;
            boolean bl2 = bl = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[n].customDraw;
            if (!bl) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int n4 = this.parent.handle;
                    int n5 = 0;
                    n5 = this.parent.columnCount > 0 ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n4, n);
                    if (n5 == 0) {
                        return;
                    }
                    int n6 = this.parent.getTextRenderer(n5);
                    int n7 = this.parent.getPixbufRenderer(n5);
                    OS.gtk_tree_view_column_set_cell_data_func(n5, n6, this.display.cellDataProc, n4, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(n5, n7, this.display.cellDataProc, n4, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[n].customDraw = true;
                }
            }
        }
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this._getChecked() == bl) {
            return;
        }
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 0, bl, -1);
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 1, !bl ? false : this.grayed, -1);
        this.cached = true;
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        int n = font != null ? font.handle : 0;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 4, n, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2) && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
    }

    public void setFont(int n, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[n2];
        }
        if ((font2 = this.cellFont[n]) == font) {
            return;
        }
        this.cellFont[n] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        int n3 = this.parent.columnCount == 0 ? 5 : this.parent.columns[n].modelIndex;
        int n4 = font != null ? font.handle : 0;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, n3 + 4, n4, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2) && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
        if (font != null) {
            boolean bl;
            boolean bl2 = bl = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[n].customDraw;
            if (!bl) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int n5 = this.parent.handle;
                    int n6 = 0;
                    n6 = this.parent.columnCount > 0 ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n5, n);
                    if (n6 == 0) {
                        return;
                    }
                    int n7 = this.parent.getTextRenderer(n6);
                    int n8 = this.parent.getPixbufRenderer(n6);
                    OS.gtk_tree_view_column_set_cell_data_func(n6, n7, this.display.cellDataProc, n5, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(n6, n8, this.display.cellDataProc, n5, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[n].customDraw = true;
                }
            }
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this._getForeground().equals(color)) {
            return;
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 2, gdkColor, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2) && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
    }

    public void setForeground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this._getForeground(n).equals(color)) {
            return;
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = this.parent.columnCount == 0 ? 5 : this.parent.columns[n].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, n3 + 2, gdkColor, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2) && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
        if (color != null) {
            boolean bl;
            boolean bl2 = bl = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[n].customDraw;
            if (!bl) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int n4 = this.parent.handle;
                    int n5 = 0;
                    n5 = this.parent.columnCount > 0 ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n4, n);
                    if (n5 == 0) {
                        return;
                    }
                    int n6 = this.parent.getTextRenderer(n5);
                    int n7 = this.parent.getPixbufRenderer(n5);
                    OS.gtk_tree_view_column_set_cell_data_func(n5, n6, this.display.cellDataProc, n4, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(n5, n7, this.display.cellDataProc, n4, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[n].customDraw = true;
                }
            }
        }
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl) {
            return;
        }
        this.grayed = bl;
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 0, nArray, -1);
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, 1, nArray[0] == 0 ? false : bl, -1);
        this.cached = true;
    }

    public void setImage(int n, Image image) {
        int n2;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image != null && image.type == 1 && image.equals(this._getImage(n))) {
            return;
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n3 - 1) {
            return;
        }
        int n4 = 0;
        if (image != null) {
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n2 = imageList.indexOf(image)) == -1) {
                n2 = imageList.add(image);
            }
            n4 = imageList.getPixbuf(n2);
        }
        int n5 = this.parent.columnCount == 0 ? 5 : this.parent.columns[n].modelIndex;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, n5 + 0, n4, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2) && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == null && OS.GTK_VERSION >= OS.VERSION(2, 3, 2) && image != null) {
            n2 = this.parent.handle;
            int n6 = OS.gtk_tree_view_get_column(n2, n);
            int[] nArray = new int[1];
            int n7 = this.parent.getPixbufRenderer(n6);
            OS.gtk_tree_view_column_cell_get_position(n6, n7, null, nArray);
            if (nArray[0] < image.getBounds().width) {
                int n8 = OS.gtk_widget_get_modifier_style(n2);
                this.parent.modifyStyle(n2, n8);
            }
        }
        this.cached = true;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < imageArray.length) {
            this.setImage(n, imageArray[n]);
            ++n;
        }
    }

    public void setImageIndent(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.cached = true;
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this._getText(n).equals(string)) {
            return;
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n3 = this.parent.columnCount == 0 ? 5 : this.parent.columns[n].modelIndex;
        OS.gtk_list_store_set(this.parent.modelHandle, this.handle, n3 + 1, byArray, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 3, 2) && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                this.setText(n, string);
            }
            ++n;
        }
    }
}

