/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    ExpandItem lastFocus;
    int itemCount;
    int spacing;
    int yCurrentScroll;

    public ExpandBar(Composite composite, int n) {
        super(composite, n);
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(expandListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        int n3 = OS.gtk_container_get_border_width(this.handle);
        point.x += 2 * n3;
        point.y += 2 * n3;
        return point;
    }

    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_vbox_new(false, 0);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x200) != 0) {
            this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, 1);
            OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            OS.gtk_scrolled_window_add_with_viewport(this.scrolledHandle, this.handle);
            int n2 = OS.gtk_bin_get_child(this.scrolledHandle);
            OS.gtk_viewport_set_shadow_type(n2, 0);
        } else {
            OS.gtk_container_add(this.fixedHandle, this.handle);
        }
        OS.gtk_container_set_border_width(this.handle, 0);
    }

    void createItem(ExpandItem expandItem, int n, int n2) {
        if (n2 < 0 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] expandItemArray = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, expandItemArray, 0, this.items.length);
            this.items = expandItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount - n2);
        this.items[n2] = expandItem;
        ++this.itemCount;
        expandItem.width = Math.max(0, this.getClientArea().width - this.spacing * 2);
        this.layoutItems(n2, true);
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.items = new ExpandItem[4];
    }

    void destroyItem(ExpandItem expandItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == expandItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        expandItem.redraw();
        this.layoutItems(n, true);
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    boolean forceFocus(int n) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.itemCount) {
            ExpandItem expandItem = this.items[n2];
            if (expandItem.setFocus()) {
                return true;
            }
            ++n2;
        }
        return super.forceFocus(n);
    }

    boolean hasFocus() {
        int n = 0;
        while (n < this.itemCount) {
            ExpandItem expandItem = this.items[n];
            if (expandItem.hasFocus()) {
                return true;
            }
            ++n;
        }
        return super.hasFocus();
    }

    void hookEvents() {
        super.hookEvents();
        if (this.scrolledHandle != 0) {
            OS.g_signal_connect_closure(this.scrolledHandle, OS.size_allocate, this.display.closures[47], true);
        }
    }

    int getBandHeight() {
        if (this.font == null) {
            return 24;
        }
        GC gC = new GC(this);
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        return Math.max(24, fontMetrics.getHeight());
    }

    public ExpandItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] expandItemArray = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, expandItemArray, 0, this.itemCount);
        return expandItemArray;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    int gtk_key_press_event(int n, int n2) {
        if (!this.hasFocus()) {
            return 0;
        }
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        int n4 = 0;
        while (n4 < this.itemCount) {
            if (this.items[n4].hasFocus()) break;
            ++n4;
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
        boolean bl = false;
        switch (gdkEventKey.keyval) {
            case 65361: 
            case 65362: {
                bl = false;
                break;
            }
            case 65363: 
            case 65364: {
                bl = true;
                break;
            }
            default: {
                return n3;
            }
        }
        int n5 = n4;
        int n6 = bl ? 1 : -1;
        while ((n4 = (n4 + n6 + this.itemCount) % this.itemCount) != n5) {
            ExpandItem expandItem = this.items[n4];
            if (!expandItem.setFocus()) continue;
            return n3;
        }
        return n3;
    }

    public int indexOf(ExpandItem expandItem) {
        this.checkWidget();
        if (expandItem == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == expandItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void layoutItems(int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.itemCount) {
            ExpandItem expandItem = this.items[n2];
            if (expandItem != null) {
                expandItem.resizeControl(this.yCurrentScroll);
            }
            ++n2;
        }
    }

    int gtk_size_allocate(int n, int n2) {
        int n3 = super.gtk_size_allocate(n, n2);
        this.layoutItems(0, false);
        return n3;
    }

    int parentingHandle() {
        return this.fixedHandle;
    }

    void releaseChildren(boolean bl) {
        int n = 0;
        while (n < this.itemCount) {
            ExpandItem expandItem = this.items[n];
            if (expandItem != null && !expandItem.isDisposed()) {
                expandItem.release(false);
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    public void removeExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, expandListener);
        this.eventTable.unhook(18, expandListener);
    }

    void reskinChildren(int n) {
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.items.length) {
                ExpandItem expandItem = this.items[n2];
                if (expandItem != null) {
                    expandItem.reskin(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    void setFontDescription(int n) {
        super.setFontDescription(n);
        int n2 = 0;
        while (n2 < this.itemCount) {
            this.items[n2].setFontDescription(n);
            ++n2;
        }
        this.layoutItems(0, true);
    }

    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        int n = 0;
        while (n < this.itemCount) {
            this.items[n].setForegroundColor(gdkColor);
            ++n;
        }
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                if (this.items[n] != null) {
                    this.items[n].setOrientation(bl);
                }
                ++n;
            }
        }
    }

    void setScrollbar() {
        Object object;
        int n;
        if (this.itemCount == 0) {
            return;
        }
        if ((this.style & 0x200) == 0) {
            return;
        }
        int n2 = this.getClientArea().height;
        ExpandItem expandItem = this.items[this.itemCount - 1];
        int n3 = expandItem.y + this.getBandHeight() + this.spacing;
        if (expandItem.expanded) {
            n3 += expandItem.height;
        }
        int n4 = OS.gtk_scrolled_window_get_vadjustment(this.scrolledHandle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, n4);
        this.yCurrentScroll = (int)gtkAdjustment.value;
        if (this.yCurrentScroll > 0 && n2 > n3) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + n3 - n2);
            this.layoutItems(0, false);
        }
        gtkAdjustment.value = Math.min(this.yCurrentScroll, n3 += this.yCurrentScroll);
        gtkAdjustment.upper = n3;
        gtkAdjustment.page_size = n2;
        OS.memmove(n4, gtkAdjustment);
        OS.gtk_adjustment_changed(n4);
        int n5 = n3 > n2 ? 0 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, n5);
        int n6 = OS.GTK_WIDGET_WIDTH(this.fixedHandle) - this.spacing * 2;
        if (n5 == 0) {
            n = OS.GTK_SCROLLED_WINDOW_VSCROLLBAR(this.scrolledHandle);
            object = new GtkRequisition();
            OS.gtk_widget_size_request(n, (GtkRequisition)object);
            n6 -= ((GtkRequisition)object).width;
        }
        n6 = Math.max(0, n6);
        n = 0;
        while (n < this.itemCount) {
            object = this.items[n];
            ((ExpandItem)object).setBounds(0, 0, n6, ((ExpandItem)object).height, false, true);
            ++n;
        }
    }

    public void setSpacing(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.spacing) {
            return;
        }
        this.spacing = n;
        OS.gtk_box_set_spacing(this.handle, n);
        OS.gtk_container_set_border_width(this.handle, n);
    }

    void showItem(ExpandItem expandItem) {
        Control control = expandItem.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(expandItem.expanded);
        }
        expandItem.redraw();
        int n = this.indexOf(expandItem);
        this.layoutItems(n + 1, true);
    }

    void updateScrollBarValue(ScrollBar scrollBar) {
        this.yCurrentScroll = scrollBar.getSelection();
        this.layoutItems(0, false);
    }
}

