/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkFixed;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    public int embeddedHandle;
    int imHandle;
    int socketHandle;
    Layout layout;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;
    static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod";

    Composite() {
    }

    public Composite(Composite composite, int n) {
        super(composite, Composite.checkStyle(n));
    }

    static int checkStyle(int n) {
        return n &= 0xBFFFFFFF;
    }

    Control[] _getChildren() {
        int n = this.parentingHandle();
        int n2 = OS.gtk_container_get_children(n);
        if (n2 == 0) {
            return new Control[0];
        }
        int n3 = OS.g_list_length(n2);
        Control[] controlArray = new Control[n3];
        int n4 = 0;
        int n5 = n2;
        while (n5 != 0) {
            Widget widget;
            int n6 = OS.g_list_data(n5);
            if (n6 != 0 && (widget = this.display.getWidget(n6)) != null && widget != this && widget instanceof Control) {
                controlArray[n4++] = (Control)widget;
            }
            n5 = OS.g_list_next(n5);
        }
        OS.g_list_free(n2);
        if (n4 == n3) {
            return controlArray;
        }
        Control[] controlArray2 = new Control[n4];
        System.arraycopy(controlArray, 0, controlArray2, 0, n4);
        return controlArray2;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabList.length) {
            if (!this.tabList[n2].isDisposed()) {
                ++n;
            }
            ++n2;
        }
        if (n == this.tabList.length) {
            return this.tabList;
        }
        Control[] controlArray = new Control[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.tabList.length) {
            if (!this.tabList[n4].isDisposed()) {
                controlArray[n3++] = this.tabList[n4];
            }
            ++n4;
        }
        this.tabList = controlArray;
        return this.tabList;
    }

    public void changed(Control[] controlArray) {
        Control control;
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        int n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean bl = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl2 = bl = composite == this;
                if (bl) break;
                composite = composite.parent;
            }
            if (!bl) {
                this.error(32);
            }
            ++n;
        }
        n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            Composite composite = control.parent;
            while (control != this) {
                if (composite.layout == null || !composite.layout.flushCache(control)) {
                    composite.state |= 0x40000;
                }
                control = composite;
                composite = control.parent;
            }
            ++n;
        }
    }

    void checkBuffered() {
        if ((this.style & 0x20000000) == 0 && (this.style & 0x40000) != 0) {
            return;
        }
        super.checkBuffered();
    }

    protected void checkSubclass() {
    }

    int childStyle() {
        if (this.scrolledHandle != 0) {
            return 0;
        }
        return super.childStyle();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point;
        this.checkWidget();
        this.display.runSkin();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if (this.layout != null) {
            if (n == -1 || n2 == -1) {
                point = this.layout.computeSize(this, n, n2, bl |= (this.state & 0x40000) != 0);
                this.state &= 0xFFFBFFFF;
            } else {
                point = new Point(n, n2);
            }
        } else {
            point = this.minimumSize(n, n2, bl);
            if (point.x == 0) {
                point.x = 64;
            }
            if (point.y == 0) {
                point.y = 64;
            }
        }
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    Widget[] computeTabList() {
        Widget[] widgetArray = super.computeTabList();
        if (widgetArray.length == 0) {
            return widgetArray;
        }
        Control[] controlArray = this.tabList != null ? this._getTabList() : this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            Widget[] widgetArray2 = control.computeTabList();
            if (widgetArray2.length != 0) {
                Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
                System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
                System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
                widgetArray = widgetArray3;
            }
            ++n;
        }
        return widgetArray;
    }

    void createHandle(int n) {
        boolean bl;
        this.state |= 0x200000A;
        boolean bl2 = bl = (this.style & 0x300) != 0;
        if (!bl) {
            this.state |= 0x10000;
        }
        this.createHandle(n, true, bl || (this.style & 0x800) != 0);
    }

    void createHandle(int n, boolean bl, boolean bl2) {
        int n2;
        boolean bl3;
        if (bl2) {
            if (bl) {
                this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
                if (this.fixedHandle == 0) {
                    this.error(2);
                }
                OS.gtk_fixed_set_has_window(this.fixedHandle, true);
            }
            if (!(bl3 = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0))) {
                this.error(2);
            }
            if ((n2 = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0)) == 0) {
                this.error(2);
            }
            this.scrolledHandle = OS.gtk_scrolled_window_new(n2, bl3 ? 1 : 0);
            if (this.scrolledHandle == 0) {
                SWT.error(2);
            }
        }
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.gtk_fixed_set_has_window(this.handle, true);
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        if ((this.style & 0x1000000) == 0 && (this.state & 2) != 0 && this.display.getData(NO_INPUT_METHOD) == null) {
            this.imHandle = OS.gtk_im_multicontext_new();
            if (this.imHandle == 0) {
                this.error(2);
            }
        }
        if (bl2) {
            if (bl) {
                OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            }
            bl3 = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.gtk_container_add(this.scrolledHandle, this.handle);
            this.display.setWarnings(bl3);
            n2 = (this.style & 0x100) != 0 ? 0 : 2;
            int n3 = (this.style & 0x200) != 0 ? 0 : 2;
            OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n2, n3);
            if (this.hasBorder()) {
                OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
        }
        if ((this.style & 0x1000000) != 0) {
            this.socketHandle = OS.gtk_socket_new();
            if (this.socketHandle == 0) {
                SWT.error(2);
            }
            OS.gtk_container_add(this.handle, this.socketHandle);
        }
        if ((this.style & 0x100000) != 0 && (this.style & 0x4000000) == 0) {
            OS.gtk_widget_set_redraw_on_allocate(this.handle, false);
        }
        if ((this.style & 0x20000000) == 0 && (this.style & 0x40000) != 0) {
            OS.gtk_widget_set_double_buffered(this.handle, false);
        }
    }

    void deregister() {
        super.deregister();
        if (this.socketHandle != 0) {
            this.display.removeWidget(this.socketHandle);
        }
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4, int n5, int n6) {
        Control control;
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            GCData gCData = gC.getGCData();
            int n7 = gCData.cairo;
            if (n7 != 0) {
                Cairo.cairo_save(n7);
                if (control.backgroundImage != null) {
                    int n8;
                    Point point = this.display.map(this, control, 0, 0);
                    Cairo.cairo_translate(n7, -point.x - n5, -point.y - n6);
                    n += point.x + n5;
                    n2 += point.y + n6;
                    int n9 = control.backgroundImage.surface;
                    if (n9 == 0) {
                        n8 = OS.GDK_DISPLAY();
                        int n10 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
                        int n11 = control.backgroundImage.pixmap;
                        int n12 = OS.GDK_PIXMAP_XID(n11);
                        int[] nArray = new int[1];
                        int[] nArray2 = new int[1];
                        OS.gdk_drawable_get_size(n11, nArray, nArray2);
                        n9 = Cairo.cairo_xlib_surface_create(n8, n12, n10, nArray[0], nArray2[0]);
                        if (n9 == 0) {
                            this.error(2);
                        }
                    } else {
                        Cairo.cairo_surface_reference(n9);
                    }
                    if ((n8 = Cairo.cairo_pattern_create_for_surface(n9)) == 0) {
                        this.error(2);
                    }
                    Cairo.cairo_pattern_set_extend(n8, 1);
                    if ((gCData.style & 0x8000000) != 0) {
                        double[] dArray = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                        Cairo.cairo_pattern_set_matrix(n8, dArray);
                    }
                    Cairo.cairo_set_source(n7, n8);
                    Cairo.cairo_surface_destroy(n9);
                    Cairo.cairo_pattern_destroy(n8);
                } else {
                    GdkColor gdkColor = control.getBackgroundColor();
                    Cairo.cairo_set_source_rgba(n7, (float)(gdkColor.red & 0xFFFF) / 65535.0f, (float)(gdkColor.green & 0xFFFF) / 65535.0f, (float)(gdkColor.blue & 0xFFFF) / 65535.0f, (float)gCData.alpha / 255.0f);
                }
                Cairo.cairo_rectangle(n7, n, n2, n3, n4);
                Cairo.cairo_fill(n7);
                Cairo.cairo_restore(n7);
            } else {
                int n13 = gC.handle;
                GdkGCValues gdkGCValues = new GdkGCValues();
                OS.gdk_gc_get_values(n13, gdkGCValues);
                if (control.backgroundImage != null) {
                    Point point = this.display.map(this, control, 0, 0);
                    OS.gdk_gc_set_fill(n13, 1);
                    OS.gdk_gc_set_ts_origin(n13, -point.x - n5, -point.y - n6);
                    OS.gdk_gc_set_tile(n13, control.backgroundImage.pixmap);
                    OS.gdk_draw_rectangle(gCData.drawable, n13, 1, n, n2, n3, n4);
                    OS.gdk_gc_set_fill(n13, gdkGCValues.fill);
                    OS.gdk_gc_set_ts_origin(n13, gdkGCValues.ts_x_origin, gdkGCValues.ts_y_origin);
                } else {
                    GdkColor gdkColor = control.getBackgroundColor();
                    OS.gdk_gc_set_foreground(n13, gdkColor);
                    OS.gdk_draw_rectangle(gCData.drawable, n13, 1, n, n2, n3, n4);
                    gdkColor.pixel = gdkGCValues.foreground_pixel;
                    OS.gdk_gc_set_foreground(n13, gdkColor);
                }
            }
        } else {
            gC.fillRectangle(n, n2, n3, n4);
        }
    }

    void enableWidget(boolean bl) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.enableWidget(bl);
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] menuArray = super.findMenus(control);
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control2 = controlArray[n];
            Menu[] menuArray2 = control2.findMenus(control);
            if (menuArray2.length != 0) {
                Menu[] menuArray3 = new Menu[menuArray.length + menuArray2.length];
                System.arraycopy(menuArray, 0, menuArray3, 0, menuArray.length);
                System.arraycopy(menuArray2, 0, menuArray3, menuArray.length, menuArray2.length);
                menuArray = menuArray3;
            }
            ++n;
        }
        return menuArray;
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].fixChildren(shell, shell2, decorations, decorations2, menuArray);
            ++n;
        }
    }

    void fixModal(int n, int n2) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        while (n3 < controlArray.length) {
            controlArray[n3].fixModal(n, n2);
            ++n3;
        }
    }

    void fixStyle() {
        super.fixStyle();
        if (this.scrolledHandle == 0) {
            this.fixStyle(this.handle);
        }
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].fixStyle();
            ++n;
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabList.length) {
            if (this.tabList[n2] == control) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        Control[] controlArray = null;
        int n3 = this.tabList.length - n;
        if (n3 != 0) {
            controlArray = new Control[n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.tabList.length) {
                if (this.tabList[n5] != control) {
                    controlArray[n4++] = this.tabList[n5];
                }
                ++n5;
            }
        }
        this.tabList = controlArray;
    }

    void fixZOrder() {
        if ((this.state & 2) != 0) {
            return;
        }
        int n = this.parentingHandle();
        int n2 = OS.GTK_WIDGET_WINDOW(n);
        if (n2 == 0) {
            return;
        }
        int[] nArray = new int[1];
        int n3 = OS.gdk_window_get_children(n2);
        if (n3 != 0) {
            int n4 = n3;
            while (n4 != 0) {
                int n5 = OS.g_list_data(n4);
                if (n5 != this.redrawWindow) {
                    OS.gdk_window_get_user_data(n5, nArray);
                    if (nArray[0] == 0 || OS.G_OBJECT_TYPE(nArray[0]) != this.display.gtk_fixed_get_type()) {
                        OS.gdk_window_lower(n5);
                    }
                }
                n4 = OS.g_list_next(n4);
            }
            OS.g_list_free(n3);
        }
    }

    int focusHandle() {
        if (this.socketHandle != 0) {
            return this.socketHandle;
        }
        return super.focusHandle();
    }

    boolean forceFocus(int n) {
        if (this.socketHandle != 0) {
            OS.GTK_WIDGET_SET_FLAGS(n, 2048);
        }
        boolean bl = super.forceFocus(n);
        if (this.socketHandle != 0) {
            OS.GTK_WIDGET_UNSET_FLAGS(n, 2048);
        }
        return bl;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        int n = OS.gtk_container_get_children(this.handle);
        if (n == 0) {
            return 0;
        }
        int n2 = OS.g_list_length(n);
        OS.g_list_free(n);
        return n2;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if ((this.state & 2) != 0) {
            if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            this.forceResize();
            int n = this.clientHandle();
            int n2 = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n);
            int n3 = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(n);
            return new Rectangle(0, 0, n2, n3);
        }
        return super.getClientArea();
    }

    int getClientWidth() {
        return (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(this.clientHandle());
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] controlArray = this._getTabList();
        if (controlArray == null) {
            int n = 0;
            Control[] controlArray2 = this._getChildren();
            int n2 = 0;
            while (n2 < controlArray2.length) {
                if (controlArray2[n2].isTabGroup()) {
                    ++n;
                }
                ++n2;
            }
            controlArray = new Control[n];
            n2 = 0;
            int n3 = 0;
            while (n3 < controlArray2.length) {
                if (controlArray2[n3].isTabGroup()) {
                    controlArray[n2++] = controlArray2[n3];
                }
                ++n3;
            }
        }
        return controlArray;
    }

    int gtk_button_press_event(int n, int n2) {
        int n3 = super.gtk_button_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        if ((this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.hooksKeys()) {
            GdkEventButton gdkEventButton = new GdkEventButton();
            OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
            if (gdkEventButton.button == 1 && this.getChildrenCount() == 0) {
                this.setFocus();
            }
        }
        return n3;
    }

    int gtk_expose_event(int n, int n2) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        if ((this.state & 2) == 0) {
            return super.gtk_expose_event(n, n2);
        }
        if ((this.style & 0x200000) == 0) {
            return super.gtk_expose_event(n, n2);
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        GdkEventExpose gdkEventExpose = new GdkEventExpose();
        OS.memmove(gdkEventExpose, n2, GdkEventExpose.sizeof);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_region_get_rectangles(gdkEventExpose.region, nArray, nArray2);
        GdkRectangle gdkRectangle = new GdkRectangle();
        int n3 = 0;
        while (n3 < nArray2[0]) {
            Event event = new Event();
            OS.memmove(gdkRectangle, nArray[0] + n3 * GdkRectangle.sizeof, GdkRectangle.sizeof);
            event.x = gdkRectangle.x;
            event.y = gdkRectangle.y;
            event.width = gdkRectangle.width;
            event.height = gdkRectangle.height;
            if ((this.style & 0x8000000) != 0) {
                event.x = this.getClientWidth() - event.width - event.x;
            }
            int n4 = OS.gdk_region_new();
            OS.gdk_region_union_with_rect(n4, gdkRectangle);
            GCData gCData = new GCData();
            gCData.damageRgn = n4;
            GC gC = event.gc = GC.gtk_new(this, gCData);
            this.sendEvent(9, event);
            gC.dispose();
            OS.gdk_region_destroy(n4);
            event.gc = null;
            ++n3;
        }
        OS.g_free(nArray[0]);
        return 0;
    }

    int gtk_key_press_event(int n, int n2) {
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        if ((this.state & 2) != 0 && this.socketHandle == 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
            int n4 = gdkEventKey.keyval;
            switch (n4) {
                case 65293: 
                case 65421: {
                    return 1;
                }
            }
        }
        return n3;
    }

    int gtk_focus(int n, int n2) {
        if (n == this.socketHandle) {
            return 0;
        }
        return super.gtk_focus(n, n2);
    }

    int gtk_focus_in_event(int n, int n2) {
        int n3 = super.gtk_focus_in_event(n, n2);
        return (this.state & 2) != 0 ? 1 : n3;
    }

    int gtk_focus_out_event(int n, int n2) {
        int n3 = super.gtk_focus_out_event(n, n2);
        return (this.state & 2) != 0 ? 1 : n3;
    }

    int gtk_map(int n) {
        this.fixZOrder();
        return 0;
    }

    int gtk_realize(int n) {
        int n2;
        int n3 = super.gtk_realize(n);
        if ((this.style & 0x40000) != 0 && (n2 = OS.GTK_WIDGET_WINDOW(this.paintHandle())) != 0) {
            OS.gdk_window_set_back_pixmap(n2, 0, false);
        }
        if (this.socketHandle != 0) {
            this.embeddedHandle = OS.gtk_socket_get_id(this.socketHandle);
        }
        return n3;
    }

    int gtk_scroll_child(int n, int n2, int n3) {
        OS.g_signal_stop_emission_by_name(n, OS.scroll_child);
        return 1;
    }

    int gtk_style_set(int n, int n2) {
        int n3;
        int n4 = super.gtk_style_set(n, n2);
        if ((this.style & 0x40000) != 0 && (n3 = OS.GTK_WIDGET_WINDOW(this.paintHandle())) != 0) {
            OS.gdk_window_set_back_pixmap(n3, 0, false);
        }
        return n4;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0) {
            OS.gtk_widget_add_events(this.handle, 8);
            if (this.scrolledHandle != 0) {
                OS.g_signal_connect_closure(this.scrolledHandle, OS.scroll_child, this.display.closures[42], false);
            }
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    int imHandle() {
        return this.imHandle;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean bl) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(bl, false);
    }

    public void layout(boolean bl, boolean bl2) {
        this.checkWidget();
        if (this.layout == null && !bl2) {
            return;
        }
        this.markLayout(bl, bl2);
        this.updateLayout(bl2);
    }

    public void layout(Control[] controlArray) {
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        this.layout(controlArray, 0);
    }

    public void layout(Control[] controlArray, int n) {
        this.checkWidget();
        if (controlArray != null) {
            Control control;
            int n2;
            Composite[] compositeArray;
            int n3 = 0;
            while (n3 < controlArray.length) {
                compositeArray = controlArray[n3];
                if (compositeArray == null) {
                    this.error(5);
                }
                if (compositeArray.isDisposed()) {
                    this.error(5);
                }
                n2 = 0;
                control = compositeArray.parent;
                while (control != null) {
                    int n4 = n2 = control == this ? 1 : 0;
                    if (n2 != 0) break;
                    control = control.parent;
                }
                if (n2 == 0) {
                    this.error(32);
                }
                ++n3;
            }
            n3 = 0;
            compositeArray = new Composite[16];
            n2 = 0;
            while (n2 < controlArray.length) {
                control = controlArray[n2];
                Composite composite = control.parent;
                while (control != this) {
                    if (composite.layout != null) {
                        composite.state |= 0x20000;
                        if (!composite.layout.flushCache(control)) {
                            composite.state |= 0x40000;
                        }
                    }
                    if (n3 == compositeArray.length) {
                        Composite[] compositeArray2 = new Composite[compositeArray.length + 16];
                        System.arraycopy(compositeArray, 0, compositeArray2, 0, compositeArray.length);
                        compositeArray = compositeArray2;
                    }
                    int n5 = n3++;
                    Composite composite2 = composite;
                    compositeArray[n5] = composite2;
                    control = composite2;
                    composite = control.parent;
                }
                ++n2;
            }
            if ((n & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            n2 = n3 - 1;
            while (n2 >= 0) {
                compositeArray[n2].updateLayout(false);
                --n2;
            }
        } else {
            if (this.layout == null && (n & 1) == 0) {
                return;
            }
            this.markLayout((n & 2) != 0, (n & 1) != 0);
            if ((n & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((n & 1) != 0);
        }
    }

    void markLayout(boolean bl, boolean bl2) {
        if (this.layout != null) {
            this.state |= 0x20000;
            if (bl) {
                this.state |= 0x40000;
            }
        }
        if (bl2) {
            Control[] controlArray = this._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].markLayout(bl, bl2);
                ++n;
            }
        }
    }

    void moveAbove(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = this.parentingHandle();
        GtkFixed gtkFixed = new GtkFixed();
        OS.memmove(gtkFixed, n3);
        int n4 = gtkFixed.children;
        if (n4 == 0) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n4;
        while (n8 != 0) {
            OS.memmove(nArray, n8, OS.PTR_SIZEOF);
            OS.memmove(nArray2, nArray[0], OS.PTR_SIZEOF);
            if (n == nArray2[0]) {
                n6 = n8;
                n5 = nArray[0];
            } else if (n2 == nArray2[0]) {
                n7 = n8;
            }
            if (n5 != 0 && (n2 == 0 || n7 != 0)) break;
            n8 = OS.g_list_next(n8);
        }
        n4 = OS.g_list_remove_link(n4, n6);
        if (n7 == 0 || OS.g_list_previous(n7) == 0) {
            OS.g_list_free_1(n6);
            n4 = OS.g_list_prepend(n4, n5);
        } else {
            n8 = OS.g_list_previous(n7);
            OS.g_list_set_previous(n6, n8);
            OS.g_list_set_next(n8, n6);
            OS.g_list_set_next(n6, n7);
            OS.g_list_set_previous(n7, n6);
        }
        gtkFixed.children = n4;
        OS.memmove(n3, gtkFixed);
    }

    void moveBelow(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = this.parentingHandle();
        if (n2 == 0 && n3 == this.fixedHandle) {
            this.moveAbove(n, this.scrolledHandle != 0 ? this.scrolledHandle : this.handle);
            return;
        }
        GtkFixed gtkFixed = new GtkFixed();
        OS.memmove(gtkFixed, n3);
        int n4 = gtkFixed.children;
        if (n4 == 0) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n4;
        while (n8 != 0) {
            OS.memmove(nArray, n8, OS.PTR_SIZEOF);
            OS.memmove(nArray2, nArray[0], OS.PTR_SIZEOF);
            if (n == nArray2[0]) {
                n6 = n8;
                n5 = nArray[0];
            } else if (n2 == nArray2[0]) {
                n7 = n8;
            }
            if (n5 != 0 && (n2 == 0 || n7 != 0)) break;
            n8 = OS.g_list_next(n8);
        }
        n4 = OS.g_list_remove_link(n4, n6);
        if (n7 == 0 || OS.g_list_next(n7) == 0) {
            OS.g_list_free_1(n6);
            n4 = OS.g_list_append(n4, n5);
        } else {
            n8 = OS.g_list_next(n7);
            OS.g_list_set_next(n6, n8);
            OS.g_list_set_previous(n8, n6);
            OS.g_list_set_previous(n6, n7);
            OS.g_list_set_next(n7, n6);
        }
        gtkFixed.children = n4;
        OS.memmove(n3, gtkFixed);
    }

    void moveChildren(int n) {
        Control[] controlArray = this._getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            int n3;
            Control control = controlArray[n2];
            int n4 = control.topHandle();
            int n5 = OS.GTK_WIDGET_X(n4);
            int n6 = OS.GTK_WIDGET_Y(n4);
            int n7 = n3 = (control.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n4);
            if (n > 0) {
                n5 = n - n3 - n5;
            }
            int n8 = this.getClientWidth();
            n5 = n8 - n3 - n5;
            if (control.enableWindow != 0) {
                OS.gdk_window_move(control.enableWindow, n5, n6);
            }
            control.moveHandle(n5, n6);
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_size_request(n4, gtkRequisition);
            GtkAllocation gtkAllocation = new GtkAllocation();
            gtkAllocation.x = n5;
            gtkAllocation.y = n6;
            gtkAllocation.width = OS.GTK_WIDGET_WIDTH(n4);
            gtkAllocation.height = OS.GTK_WIDGET_HEIGHT(n4);
            OS.gtk_widget_size_allocate(n4, gtkAllocation);
            Control control2 = control.findBackgroundControl();
            if (control2 != null && control2.backgroundImage != null && control.isVisible()) {
                control.redrawWidget(0, 0, 0, 0, true, true, true);
            }
            ++n2;
        }
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        Rectangle rectangle = this.getClientArea();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < controlArray.length) {
            Rectangle rectangle2 = controlArray[n5].getBounds();
            n3 = Math.max(n3, rectangle2.x - rectangle.x + rectangle2.width);
            n4 = Math.max(n4, rectangle2.y - rectangle.y + rectangle2.height);
            ++n5;
        }
        return new Point(n3, n4);
    }

    int parentingHandle() {
        if ((this.state & 2) != 0) {
            return this.handle;
        }
        return this.fixedHandle != 0 ? this.fixedHandle : this.handle;
    }

    void printWidget(GC gC, int n, int n2, int n3, int n4) {
        Region region = new Region(gC.getDevice());
        Region region2 = new Region(gC.getDevice());
        gC.getClipping(region);
        Rectangle rectangle = this.getBounds();
        region2.add(region);
        region2.intersect(n3, n4, rectangle.width, rectangle.height);
        gC.setClipping(region2);
        super.printWidget(gC, n, n2, n3, n4);
        Rectangle rectangle2 = this.getClientArea();
        Point point = this.display.map(this, this.parent, rectangle2.x, rectangle2.y);
        rectangle2.x = n3 + point.x - rectangle.x;
        rectangle2.y = n4 + point.y - rectangle.y;
        region2.intersect(rectangle2);
        gC.setClipping(region2);
        Control[] controlArray = this._getChildren();
        int n5 = controlArray.length - 1;
        while (n5 >= 0) {
            Control control = controlArray[n5];
            if (control.getVisible()) {
                Point point2 = control.getLocation();
                control.printWidget(gC, n, n2, n3 + point2.x, n4 + point2.y);
            }
            --n5;
        }
        gC.setClipping(region);
        region.dispose();
        region2.dispose();
    }

    void redrawChildren() {
        super.redrawChildren();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if ((control.state & 0x8000) != 0) {
                control.redrawWidget(0, 0, 0, 0, true, false, true);
                control.redrawChildren();
            }
            ++n;
        }
    }

    void register() {
        super.register();
        if (this.socketHandle != 0) {
            this.display.addWidget(this.socketHandle, this);
        }
    }

    void releaseChildren(boolean bl) {
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control != null && !control.isDisposed()) {
                control.release(false);
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.embeddedHandle = 0;
        this.socketHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imHandle != 0) {
            OS.g_object_unref(this.imHandle);
        }
        this.imHandle = 0;
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void reskinChildren(int n) {
        super.reskinChildren(n);
        Control[] controlArray = this._getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            Control control = controlArray[n2];
            if (control != null) {
                control.reskin(n);
            }
            ++n2;
        }
    }

    void resizeHandle(int n, int n2) {
        super.resizeHandle(n, n2);
        if (this.socketHandle != 0) {
            OS.gtk_widget_set_size_request(this.socketHandle, n, n2);
        }
    }

    public void setBackgroundMode(int n) {
        this.checkWidget();
        this.backgroundMode = n;
        Control[] controlArray = this._getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            controlArray[n2].updateBackgroundMode();
            ++n2;
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n5 & 0x100) != 0 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return n5;
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control.getVisible() && control.setFocus()) {
                return true;
            }
            ++n;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean bl) {
        this.checkWidget();
        if (!bl) {
            if (--this.layoutCount == 0 && ((this.state & 0x80000) != 0 || (this.state & 0x20000) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (!bl) {
            int n = 0x6000000;
            int n2 = this.style & n;
            Control[] controlArray = this._getChildren();
            int n3 = 0;
            while (n3 < controlArray.length) {
                controlArray[n3].setOrientation(n2);
                ++n3;
            }
            if ((this.style & 0x4000000) != 0 != ((this.style & 0x8000000) != 0)) {
                this.moveChildren(-1);
            }
        }
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl) {
        boolean bl2 = super.setScrollBarVisible(scrollBar, bl);
        if (bl2 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return bl2;
    }

    boolean setTabGroupFocus(boolean bl) {
        boolean bl2;
        if (this.isTabItem()) {
            return this.setTabItemFocus(bl);
        }
        boolean bl3 = bl2 = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            bl2 = this.hooksKeys();
        }
        if (this.socketHandle != 0) {
            bl2 = true;
        }
        if (bl2 && this.setTabItemFocus(bl)) {
            return true;
        }
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control.isTabItem() && control.setTabItemFocus(bl)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean setTabItemFocus(boolean bl) {
        if (!super.setTabItemFocus(bl)) {
            return false;
        }
        if (this.socketHandle != 0) {
            int n = bl ? 0 : 1;
            OS.GTK_WIDGET_UNSET_FLAGS(this.socketHandle, 4096);
            OS.gtk_widget_child_focus(this.socketHandle, n);
            OS.GTK_WIDGET_SET_FLAGS(this.socketHandle, 4096);
        }
        return true;
    }

    public void setTabList(Control[] controlArray) {
        this.checkWidget();
        if (controlArray != null) {
            int n = 0;
            while (n < controlArray.length) {
                Control control = controlArray[n];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++n;
            }
            Control[] controlArray2 = new Control[controlArray.length];
            System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
            controlArray = controlArray2;
        }
        this.tabList = controlArray;
    }

    void showWidget() {
        super.showWidget();
        if (this.socketHandle != 0) {
            OS.gtk_widget_show(this.socketHandle);
            this.embeddedHandle = OS.gtk_socket_get_id(this.socketHandle);
        }
        if (this.scrolledHandle == 0) {
            this.fixStyle(this.handle);
        }
    }

    boolean checkSubwindow() {
        return (this.state & 0x2000000) != 0;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] controlArray = this._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Control control2 = controlArray[n];
                if (control2.translateMnemonic(event, control)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    int traversalCode(int n, GdkEventKey gdkEventKey) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(n, gdkEventKey);
    }

    boolean translateTraversal(GdkEventKey gdkEventKey) {
        if (this.socketHandle != 0) {
            return false;
        }
        return super.translateTraversal(gdkEventKey);
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] controlArray = this._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].updateBackgroundMode();
            ++n;
        }
    }

    void updateLayout(boolean bl) {
        Composite composite = this.findDeferredControl();
        if (composite != null) {
            composite.state |= 0x80000;
            return;
        }
        if ((this.state & 0x20000) != 0) {
            boolean bl2 = (this.state & 0x40000) != 0;
            this.state &= 0xFFF9FFFF;
            this.display.runSkin();
            this.layout.layout(this, bl2);
        }
        if (bl) {
            this.state &= 0xFFF7FFFF;
            Control[] controlArray = this._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].updateLayout(bl);
                ++n;
            }
        }
    }
}

