/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

public class TreeDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TreeDragSourceEffect(Tree tree) {
        super(tree);
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        int[] nArray;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Tree tree = (Tree)this.control;
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            return null;
        }
        if (OS.USE_CAIRO) {
            return null;
        }
        if (tree.isListening(40) || tree.isListening(42)) {
            return null;
        }
        int n = tree.handle;
        int n2 = OS.gtk_tree_view_get_selection(n);
        int n3 = OS.gtk_tree_selection_get_selected_rows(n2, nArray = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null);
        if (n3 == 0) {
            return null;
        }
        int n4 = Math.min(10, OS.g_list_length(n3));
        Display display = tree.getDisplay();
        if (n4 == 1) {
            int n5 = OS.g_list_nth_data(n3, 0);
            int n6 = OS.gtk_tree_view_create_row_drag_icon(n, n5);
            this.dragSourceImage = Image.gtk_new(display, 1, n6, 0);
            OS.gtk_tree_path_free(n5);
        } else {
            int n7;
            int n8 = 0;
            int n9 = 0;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[n4];
            int[] nArray5 = new int[n4];
            int[] nArray6 = new int[n4];
            GdkRectangle gdkRectangle = new GdkRectangle();
            int n10 = 0;
            while (n10 < n4) {
                n7 = OS.g_list_nth_data(n3, n10);
                OS.gtk_tree_view_get_cell_area(n, n7, 0, gdkRectangle);
                nArray6[n10] = OS.gtk_tree_view_create_row_drag_icon(n, n7);
                OS.gdk_drawable_get_size(nArray6[n10], nArray2, nArray3);
                n8 = Math.max(n8, nArray2[0]);
                n9 = gdkRectangle.y + nArray3[0] - nArray4[0];
                nArray4[n10] = gdkRectangle.y;
                nArray5[n10] = nArray3[0];
                OS.gtk_tree_path_free(n7);
                ++n10;
            }
            n10 = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), n8, n9, -1);
            n7 = OS.gdk_gc_new(n10);
            int n11 = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), n8, n9, 1);
            int n12 = OS.gdk_gc_new(n11);
            GdkColor gdkColor = new GdkColor();
            gdkColor.pixel = 0;
            OS.gdk_gc_set_foreground(n12, gdkColor);
            OS.gdk_draw_rectangle(n11, n12, 1, 0, 0, n8, n9);
            gdkColor.pixel = 1;
            OS.gdk_gc_set_foreground(n12, gdkColor);
            int n13 = 0;
            while (n13 < n4) {
                OS.gdk_draw_drawable(n10, n7, nArray6[n13], 0, 0, 0, nArray4[n13] - nArray4[0], -1, -1);
                OS.gdk_draw_rectangle(n11, n12, 1, 0, nArray4[n13] - nArray4[0], n8, nArray5[n13]);
                OS.g_object_unref(nArray6[n13]);
                ++n13;
            }
            OS.g_object_unref(n7);
            OS.g_object_unref(n12);
            this.dragSourceImage = Image.gtk_new(display, 1, n10, n11);
        }
        OS.g_list_free(n3);
        return this.dragSourceImage;
    }
}

