/*
 * Decompiled with CFR 0.152.
 */
package e3d.wavelet;

import e3d.utils.ProgressListener;
import e3d.utils.TaskUtils;
import e3d.visualization.image.E3DImage;
import e3d.visualization.util.E3DColor;
import e3d.wavelet.DWTAnalyzer;
import e3d.wavelet.DWTBlurSynthesizer;
import e3d.wavelet.DWTFilter;
import e3d.wavelet.DWTNoiseSynthesizer;
import java.io.File;
import java.util.concurrent.CopyOnWriteArrayList;

public class DWTImageSmoother {
    public static final E3DColor.Channel[] CHANNELS_RGBA = new E3DColor.Channel[]{E3DColor.Channel.RED, E3DColor.Channel.GREEN, E3DColor.Channel.BLUE, E3DColor.Channel.ALPHA};
    public static final E3DColor.Channel[] CHANNELS_RGB = new E3DColor.Channel[]{E3DColor.Channel.RED, E3DColor.Channel.GREEN, E3DColor.Channel.BLUE};
    public static final E3DColor.Channel[] CHANNELS_GRAYALPHA = new E3DColor.Channel[]{E3DColor.Channel.GRAY, E3DColor.Channel.ALPHA};
    public static final E3DColor.Channel[] CHANNELS_GRAY = new E3DColor.Channel[]{E3DColor.Channel.GRAY};
    public static final int DEPTH_MAX = 0;
    protected E3DColor.Channel[] channels = CHANNELS_RGB;
    protected int tileSize = 512;
    protected int tileOverlap = 64;
    protected int depth = 0;
    protected int shifts = 3;
    protected int skip = 0;
    protected double level100 = 128.0;
    protected double[] lowPassFilter = DWTFilter.DWT_DEBAUCHY97_LOW;
    protected double[] highPassFilter = DWTFilter.DWT_DEBAUCHY97_HIGH;
    protected int blurRadius = 5;
    protected int blurLevels = 1;
    protected double blurDelta = 64.0;
    protected boolean showAnalyzed = false;
    protected boolean showNoise = false;
    protected boolean showWeights = false;
    protected File showPath = new File("./");
    protected final CopyOnWriteArrayList<ProgressListener> progressListeners = new CopyOnWriteArrayList();

    public E3DColor.Channel[] getChannels() {
        return this.channels;
    }

    public void setChannels(E3DColor.Channel[] channels) {
        this.channels = channels;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getTileOverlap() {
        return this.tileOverlap;
    }

    public void setTileSizeAndOverlap(int tileSize, int tileOverlap) {
        this.tileSize = tileSize;
        this.tileOverlap = tileOverlap;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getShifts() {
        return this.shifts;
    }

    public void setShifts(int shifts) {
        this.shifts = shifts;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public double getLevel100() {
        return this.level100;
    }

    public void setLevel100(double level100) {
        this.level100 = level100;
    }

    public double[] getLowpassFilter() {
        return this.lowPassFilter;
    }

    public double[] getHighpassFilter() {
        return this.lowPassFilter;
    }

    public void setFilter(double[] low, double[] high) {
        this.lowPassFilter = low;
        this.highPassFilter = high;
    }

    public int getBlurRadius() {
        return this.blurRadius;
    }

    public void setBlurRadius(int blurRadius) {
        this.blurRadius = blurRadius;
    }

    public int getBlurLevels() {
        return this.blurLevels;
    }

    public void setBlurLevels(int blurLevels) {
        this.blurLevels = blurLevels;
    }

    public double getBlurDelta() {
        return this.blurDelta;
    }

    public void setBlurDelta(double delta) {
        this.blurDelta = delta;
    }

    public boolean showAnalyzed() {
        return this.showAnalyzed;
    }

    public boolean showNoise() {
        return this.showNoise;
    }

    public boolean isShowWeights() {
        return this.showWeights;
    }

    public File getShowPath() {
        return this.showPath;
    }

    public void setDebugOptions(boolean showAnalyzed, boolean showNoise, boolean showWeights, File showPath) {
        this.showAnalyzed = showAnalyzed;
        this.showNoise = showNoise;
        this.showWeights = showWeights;
        this.showPath = showPath;
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public E3DImage smooth(E3DImage input) throws Exception, InterruptedException {
        if (input == null) {
            return null;
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.init(100, "DWT-SMOOTHING");
        }
        DWTAnalyzer dwtAnalyzer = new DWTAnalyzer(this.lowPassFilter, this.highPassFilter);
        DWTNoiseSynthesizer dwtNoise = new DWTNoiseSynthesizer(this.lowPassFilter, this.highPassFilter, this.level100, this.shifts, this.skip);
        DWTBlurSynthesizer dwtBlur = new DWTBlurSynthesizer(this.lowPassFilter, this.highPassFilter, this.blurDelta, this.blurRadius);
        int maxDepth = dwtNoise.getDepth(this.tileSize, this.depth);
        int imgWidth = input.getWidth();
        int imgHeight = input.getHeight();
        E3DImage output = input.image(imgWidth, imgHeight);
        E3DImage analyzedImg = this.showAnalyzed ? input.image(this.tileSize, this.tileSize) : null;
        E3DImage noiseImg = this.showNoise ? input.image(this.tileSize, this.tileSize) : null;
        E3DImage weightImg = this.showWeights ? input.image(this.tileSize, this.tileSize * 2) : null;
        double[] signal0 = new double[this.tileSize * this.tileSize];
        double[] signal1 = new double[this.tileSize * this.tileSize];
        double[] signal2 = new double[this.tileSize * this.tileSize];
        double[] weights = new double[this.tileSize * this.tileSize * 2];
        int overlap = Math.min(this.tileSize - 1, Math.min(this.tileOverlap, Math.min(imgWidth, imgHeight) - 1));
        int tiles = this.tiles(imgWidth, imgHeight, overlap);
        int steps = this.channels.length;
        int y0 = 0;
        int tile = 0;
        while (y0 < imgHeight - overlap) {
            int x0 = 0;
            while (x0 < imgWidth - overlap) {
                String tileName = "tile: (" + x0 + "," + y0 + ") - (" + (x0 + this.tileSize - 1) + "," + (y0 + this.tileSize - 1) + ")";
                for (ProgressListener listener : this.progressListeners) {
                    listener.done(tile * 100 / tiles, tileName);
                }
                int step = 0;
                E3DColor.Channel[] channelArray = this.channels;
                int n = this.channels.length;
                int n2 = 0;
                while (n2 < n) {
                    E3DColor.Channel channel = channelArray[n2];
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    this.tile2Signal(input, signal0, signal1, this.tileSize, channel, x0, y0);
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    double[][] signals4Analyzer = new double[][]{signal1, signal2};
                    double[] analyzed = dwtAnalyzer.multi(signals4Analyzer, this.tileSize, 2, maxDepth);
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    if (this.showAnalyzed) {
                        this.signal2Image(analyzed, analyzedImg, channel, 128.0, 1);
                    }
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    double[][] signals4Noise = new double[][]{analyzed, signals4Analyzer[1], weights};
                    double[] noise = dwtNoise.multi(signals4Noise, this.tileSize, 2, maxDepth);
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    if (this.showNoise) {
                        this.signal2Image(noise, noiseImg, channel, 128.0, 1);
                    }
                    if (this.showWeights) {
                        this.signal2Image(weights, weightImg, channel, 0.0, 256);
                    }
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    dwtBlur.denoise(signal0, noise, this.tileSize * this.tileSize, 1);
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    double[][] signals4Analyzer2 = new double[][]{signal0, signal1};
                    double[] analyzed2 = dwtAnalyzer.multi(signals4Analyzer2, this.tileSize, 2, this.blurLevels);
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    double[][] signals4Blur = new double[][]{analyzed2, signal2, weights};
                    double[] blurred = dwtBlur.multi(signals4Blur, this.tileSize, 2, this.blurLevels);
                    if (TaskUtils.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    this.signal2Tile(blurred, output, this.tileSize, overlap, channel, x0, y0);
                    for (ProgressListener listener : this.progressListeners) {
                        listener.done(tile * 100 / tiles + (step + 1) * (100 / tiles) / steps, tileName);
                    }
                    ++step;
                    ++n2;
                }
                if (this.showAnalyzed) {
                    analyzedImg.save(new File(this.showPath + File.separator + "filtered_" + x0 + "_" + y0 + ".png"), E3DImage.Format.PNG);
                }
                if (this.showNoise) {
                    analyzedImg.save(new File(this.showPath + File.separator + "noise_" + x0 + "_" + y0 + ".png"), E3DImage.Format.PNG);
                }
                if (this.showWeights) {
                    analyzedImg.save(new File(this.showPath + File.separator + "weights_" + x0 + "_" + y0 + ".png"), E3DImage.Format.PNG);
                }
                x0 += this.tileSize - overlap;
                ++tile;
            }
            y0 += this.tileSize - overlap;
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(listener.steps(), "smoothing completed");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
        return output;
    }

    protected int tiles(int imgWidth, int imgHeight, int overlap) {
        int tiles = 0;
        int y0 = 0;
        while (y0 < imgHeight - overlap) {
            int x0 = 0;
            while (x0 < imgWidth - overlap) {
                ++tiles;
                x0 += this.tileSize - overlap;
            }
            y0 += this.tileSize - overlap;
        }
        return tiles;
    }

    private void tile2Signal(E3DImage input, double[] signal0, double[] signal1, int tileSize, E3DColor.Channel channel, int xOffset, int yOffset) {
        int imgWidth = input.getWidth();
        int imgHeight = input.getHeight();
        int y = 0;
        while (y < Math.min(imgHeight - yOffset, tileSize)) {
            int x = 0;
            while (x < Math.min(imgWidth - xOffset, tileSize)) {
                int color = input.getRGB(x + xOffset, y + yOffset);
                double d = (double)E3DColor.channel(color, channel) - 128.0;
                signal1[x + y * tileSize] = d;
                signal0[x + y * tileSize] = d;
                ++x;
            }
            ++y;
        }
    }

    private void signal2Tile(double[] signal, E3DImage output, int tileSize, int tileOverlap, E3DColor.Channel channel, int xOffset, int yOffset) {
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int dy = yOffset != 0 ? tileOverlap : 0;
        int y = 0;
        while (y < Math.min(imgHeight - yOffset, tileSize)) {
            int dx = xOffset != 0 ? tileOverlap : 0;
            int x = 0;
            while (x < Math.min(imgWidth - xOffset, tileSize)) {
                int color = output.getRGB(x + xOffset, y + yOffset);
                double current = E3DColor.channel(color, channel);
                double weightX = tileOverlap == 0 ? 0.0 : (double)Math.max(dx - x, 0) / (double)tileOverlap;
                double weightY = tileOverlap == 0 ? 0.0 : (double)Math.max(dy - y, 0) / (double)tileOverlap;
                double weight = Math.max(weightX, weightY);
                if (channel == E3DColor.Channel.GRAY) {
                    int grey = (int)((1.0 - weight) * (signal[x + y * tileSize] + 128.0) + weight * current);
                    color = E3DColor.rgb(grey, grey, grey, 255);
                } else {
                    int newValue = (int)((1.0 - weight) * (signal[x + y * tileSize] + 128.0) + weight * current);
                    color = E3DColor.rgb(color, newValue, channel);
                }
                output.setRGB(x + xOffset, y + yOffset, color);
                ++x;
            }
            ++y;
        }
    }

    private void signal2Image(double[] signal, E3DImage image, E3DColor.Channel channel, double colorOffset, int colorFactor) {
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        int y = 0;
        while (y < imgHeight) {
            int x = 0;
            while (x < imgWidth) {
                int color = image.getRGB(x, y);
                int value = (int)(signal[x + y * imgWidth] * (double)colorFactor + colorOffset);
                color = E3DColor.rgb(color, value, channel);
                image.setRGB(x, y, color);
                ++x;
            }
            ++y;
        }
    }
}

