/*
 * Decompiled with CFR 0.152.
 */
package e3d.wavelet;

import e3d.wavelet.DWTSynthesizer;

public class DWTBlurSynthesizer
extends DWTSynthesizer {
    protected double delta;
    protected int radius;

    public DWTBlurSynthesizer() {
    }

    public DWTBlurSynthesizer(DWTBlurSynthesizer dwtFilter) {
        this.set(dwtFilter);
    }

    public DWTBlurSynthesizer(double[] low, double[] high, double maxDelta, int blurRadius) {
        this.set(low, high);
        this.setMaxDelta(maxDelta);
        this.setBlurRadius(blurRadius);
    }

    public void set(DWTBlurSynthesizer dwtFilter) {
        super.set(dwtFilter);
        this.setMaxDelta(dwtFilter.delta);
        this.setBlurRadius(dwtFilter.radius);
    }

    public void setMaxDelta(double maxDelta) {
        this.delta = maxDelta;
    }

    public void setBlurRadius(int blurRadius) {
        this.radius = blurRadius;
    }

    @Override
    public double[] multi(double[][] signals, int diameter, int dimensions, int depth) {
        int maxDepth = this.getDepth(diameter, depth);
        int levels = maxDepth * dimensions;
        double[] input = signals[0];
        int[] lengths = this.lengths(dimensions, diameter >> maxDepth);
        int[] steps = this.steps(dimensions, diameter);
        int[] offsets = new int[signals.length];
        int[] elementCoordinates = new int[dimensions];
        this.toggle(signals, 0, 1);
        int rad = this.radius;
        int level = 0;
        while (level < levels) {
            int dim = dimensions - 1;
            while (dim >= 0) {
                int n = dim;
                lengths[n] = lengths[n] * 2;
                this.tile(signals, signals[1] != input ? 1 : 0, dimensions - 1, dim, offsets, lengths, steps);
                int i = 0;
                while (i < dimensions) {
                    elementCoordinates[i] = 0;
                    ++i;
                }
                boolean signalOffset = false;
                int weightOffset = this.shiftOffset(dim, lengths, steps) + 0;
                this.blur(signals[0], signals[1], signals[2], dimensions, dimensions - 1, 0, weightOffset, elementCoordinates, lengths, steps, rad);
                --dim;
                ++level;
            }
            --maxDepth;
            rad /= 2;
        }
        this.toggle(signals, 0, 1);
        return signals[0];
    }

    public void denoise(double[] signal, double[] noise, int length, int step) {
        int i = 0;
        int k = 0;
        while (i < length) {
            int n = k;
            signal[n] = signal[n] - noise[k];
            ++i;
            k += step;
        }
    }

    public void blur(double[] input, double[] output, double[] weight, int dimensions, int[] lengths, int[] steps) {
        int[] elem = new int[dimensions];
        this.blur(input, output, weight, dimensions, dimensions - 1, 0, 0, elem, lengths, steps, this.radius);
    }

    protected void blur(double[] input, double[] output, double[] weight, int dimensions, int dimension, int signalOffset, int weightOffset, int[] elementCooridinates, int[] lengths, int[] steps, int radius) {
        if (dimension < 0) {
            if (this.delta <= 0.0 || radius <= 0) {
                output[signalOffset] = input[signalOffset];
            } else {
                double[] w = new double[1];
                double[] v = new double[1];
                int[] lenLocal = new int[dimensions];
                int offsetLocal = this.blurArea(dimensions, elementCooridinates, lengths, steps, radius, signalOffset, lenLocal);
                this.sum(input, input[signalOffset], dimensions - 1, offsetLocal, lenLocal, steps, w, v);
                if (w[0] == 0.0) {
                    output[signalOffset] = input[signalOffset];
                } else {
                    double wgt = weight[weightOffset] * weight[weightOffset];
                    output[signalOffset] = wgt * input[signalOffset] + (1.0 - wgt) * v[0] / w[0];
                }
            }
        } else {
            elementCooridinates[dimension] = 0;
            while (elementCooridinates[dimension] < lengths[dimension]) {
                this.blur(input, output, weight, dimensions, dimension - 1, signalOffset, weightOffset, elementCooridinates, lengths, steps, radius);
                signalOffset += steps[dimension];
                int n = dimension;
                elementCooridinates[n] = elementCooridinates[n] + 1;
            }
        }
    }

    protected int blurArea(int dimensions, int[] coordinates, int[] lengths, int[] steps, int radius, int offset, int[] area) {
        int d = 0;
        while (d < dimensions) {
            int start = -Math.min(radius, coordinates[d]);
            offset += start * steps[d];
            area[d] = Math.min(radius, lengths[d] - coordinates[d] - 1) - start;
            ++d;
        }
        return offset;
    }

    protected void sum(double[] signal, double value, int dimension, int offset, int[] lengths, int[] steps, double[] cumulatedWeight, double[] weightedSum) {
        if (dimension < 0) {
            double weight = this.weighted(value - signal[offset]);
            cumulatedWeight[0] = cumulatedWeight[0] + weight;
            weightedSum[0] = weightedSum[0] + signal[offset] * weight;
        } else {
            int i = 0;
            while (i < lengths[dimension]) {
                this.sum(signal, value, dimension - 1, offset, lengths, steps, cumulatedWeight, weightedSum);
                offset += steps[dimension];
                ++i;
            }
        }
    }

    protected double weighted(double value) {
        double weighted = 1.0 - Math.min(Math.max(Math.abs(value) / this.delta, 0.0), 1.0);
        return weighted;
    }
}

