/*
 * Decompiled with CFR 0.152.
 */
package e3d.wavelet;

import e3d.wavelet.DWTFilter;

public class DWTAnalyzer
extends DWTFilter {
    public static final int MODE_DONT_COPY_INPUT_TO_OUTPUT = 0;
    public static final int MODE_COPY_INPUT_TO_OUTPUT = 1;

    public DWTAnalyzer() {
    }

    public DWTAnalyzer(DWTAnalyzer flt) {
        this.set(flt);
    }

    public DWTAnalyzer(double[] low, double[] high) {
        this.set(low, high);
    }

    @Override
    public double[] apply(double[][] signals, int length, int step, int filter, int[] offsets) {
        int filterOffset = this.filterOffset();
        int outputOffset = this.signalOffset(length, filter) * step + offsets[1];
        this.analyze(signals[0], signals[1], length, step, filter, offsets[0], outputOffset, filterOffset);
        return signals[1];
    }

    protected void analyze(double[] input, double[] output, int inputLength, int step, int filter, int inputOffset, int outputOffset, int filterOffset) {
        int yi = 0;
        int i = outputOffset;
        while (yi < inputLength / 2) {
            int ci = 0;
            while (ci < this.coefficients[filter].length) {
                int j = this.index(2 * yi + ci - filterOffset, inputLength) * step + inputOffset;
                int n = i;
                output[n] = output[n] + input[j] * this.coefficients[filter][ci];
                ++ci;
            }
            ++yi;
            i += step;
        }
    }

    @Override
    public double[] single(double[][] signals, int length, int step, int[] offsets, int mode) {
        int highOffset = this.signalOffset(length, 1) * step;
        this.init(signals[1], 0.0, offsets[1], length, step);
        this.apply(signals, length, step, 0, offsets);
        this.apply(signals, length, step, 1, offsets);
        if ((mode & 1) != 0) {
            this.copy(signals[1], signals[0], offsets[1] + highOffset, offsets[0] + highOffset, length / 2, step);
        }
        return signals[1];
    }

    @Override
    public double[] multi(double[][] signals, int diameter, int dimensions, int depth) {
        int maxDepth = this.getDepth(diameter, depth);
        int levels = maxDepth * dimensions;
        double[] result = signals[this.odd(levels) ? 1 : 0];
        int[] lengths = this.lengths(dimensions, diameter);
        int[] steps = this.steps(dimensions, diameter);
        int[] offsets = new int[signals.length];
        int level = 0;
        while (level < levels) {
            int dimension = 0;
            while (dimension < dimensions) {
                this.tile(signals, signals[0] == result ? 1 : 0, dimensions - 1, dimension, offsets, lengths, steps);
                this.toggle(signals, 0, 1);
                int n = dimension++;
                lengths[n] = lengths[n] / 2;
                ++level;
            }
            --maxDepth;
        }
        return result;
    }
}

