/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.util;

import e3d.utils.ArrayFactory;
import e3d.utils.ObjectFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Matrix2D<V> {
    protected V[] values;
    protected int width;
    protected int height;
    protected double left;
    protected double top;
    protected double right;
    protected double bottom;
    protected final ArrayFactory<V> arrayFactory;
    protected final ObjectFactory<V> valueFactory;

    public Matrix2D(ArrayFactory<V> arrayFactory, ObjectFactory<V> valueFactory) {
        this.arrayFactory = arrayFactory;
        this.valueFactory = valueFactory;
        this.values = null;
        this.width = 0;
        this.height = 0;
        this.left = 0.0;
        this.right = 0.0;
        this.top = 0.0;
        this.bottom = 0.0;
    }

    public Matrix2D(Matrix2D<V> matrix) {
        this.arrayFactory = matrix.arrayFactory;
        this.valueFactory = matrix.valueFactory;
        this.values = null;
        this.width = 0;
        this.height = 0;
        this.set(matrix);
    }

    public Matrix2D(int width, int height, ArrayFactory<V> arrayFactory, ObjectFactory<V> valueFactory) {
        this.arrayFactory = arrayFactory;
        this.valueFactory = valueFactory;
        this.left = 0.0;
        this.top = 0.0;
        this.right = width;
        this.bottom = height;
        this.width = width;
        this.height = height;
        this.createValues();
    }

    public Matrix2D<V> clone() {
        return new Matrix2D<V>(this);
    }

    public void clear() {
        this.values = null;
        this.width = 0;
        this.height = 0;
    }

    public void setSize(int width, int height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.createValues();
        }
    }

    public void set(Matrix2D<V> matrix) {
        this.left = matrix.left;
        this.right = matrix.right;
        this.top = matrix.top;
        this.bottom = matrix.bottom;
        this.setSize(matrix.width, matrix.height);
        int i = 0;
        int s = matrix.width * matrix.height;
        while (i < s) {
            if (matrix.values[i] != null) {
                this.values[i] = this.arrayFactory.copy(matrix.values[i]);
            }
            ++i;
        }
    }

    public void reshape(int width, int height, V[] values) {
        if (values == null && width * height != this.width * this.height || values != null && width * height != values.length) {
            throw new RuntimeException("Number of elements (" + (values == null ? this.values.length : values.length) + ") does not match theoretical value (" + width + " x " + height + ")");
        }
        this.width = width;
        this.height = height;
        if (values != null) {
            if (values.length != this.values.length) {
                this.values = this.arrayFactory.create(values.length);
            }
            int i = 0;
            while (i < values.length) {
                this.values[i] = values[i];
                ++i;
            }
        }
    }

    public void setBounds(double left, double top, double right, double bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    public double left() {
        return this.left;
    }

    public double right() {
        return this.right;
    }

    public double top() {
        return this.top;
    }

    public double bottom() {
        return this.bottom;
    }

    public double xZoom() {
        return (double)this.width / (this.right - this.left);
    }

    public double yZoom() {
        return (double)this.height / (this.bottom - this.top);
    }

    public double xZoom(double x) {
        return x / this.xZoom() + this.left();
    }

    public double yZoom(double y) {
        return y / this.yZoom() + this.top();
    }

    public boolean isIn(long x, long y) {
        return x >= 0L && x < (long)this.width && y >= 0L && y < (long)this.height;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void set(int x, int y, V val) {
        if (this.isIn(x, y)) {
            this.values[x + y * this.width] = val;
        }
    }

    public void set(double x, double y, V val) {
        this.set(this.x(x), this.y(y), val);
    }

    public V get(int x, int y) {
        if (this.isIn(x, y)) {
            return this.values[x + y * this.width];
        }
        return null;
    }

    public V get(double x, double y) {
        return this.get(this.x(x), this.y(y));
    }

    public void exchange(int x1, int y1, int x2, int y2) {
        V v1 = this.get(x1, y1);
        V v2 = this.get(x2, y2);
        this.set(x1, y1, v2);
        this.set(x2, y2, v1);
    }

    public void exchange(double x1, double y1, double x2, double y2) {
        this.exchange(this.x(x1), this.y(y1), this.x(x2), this.y(y2));
    }

    public void mirrorHorizontal() {
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width / 2) {
                this.exchange(x, y, this.width - 1 - x, y);
                ++x;
            }
            ++y;
        }
    }

    public void mirrorVertical() {
        int y = 0;
        while (y < this.height / 2) {
            int x = 0;
            while (x < this.width) {
                this.exchange(x, y, x, this.height - 1 - y);
                ++x;
            }
            ++y;
        }
    }

    public void rotateLeft() {
        int w = this.width;
        int h = this.height;
        V[] values = this.arrayFactory.create(w * h);
        int x = 0;
        int i = 0;
        while (x < w) {
            int y = h - 1;
            while (y >= 0) {
                values[i] = this.get(x, y);
                --y;
                ++i;
            }
            ++x;
        }
        this.width = h;
        this.height = w;
        this.values = values;
    }

    public void rotateRight() {
        int w = this.width;
        int h = this.height;
        V[] values = this.arrayFactory.create(w * h);
        int x = w - 1;
        int i = 0;
        while (x >= 0) {
            int y = 0;
            while (y < h) {
                values[i] = this.get(x, y);
                ++y;
                ++i;
            }
            --x;
        }
        this.width = h;
        this.height = w;
        this.values = values;
    }

    public void insertRow(int row, V[] rowValues) {
        int h = this.height + 1;
        V[] v = this.arrayFactory.create(this.width * h);
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                v[x + (y >= row ? y + 1 : y) * this.width] = this.values[x + y * this.width];
                ++x;
            }
            ++y;
        }
        if (rowValues != null) {
            int x = 0;
            while (x < this.width) {
                v[x + row * this.width] = rowValues[x];
                ++x;
            }
        }
        this.values = v;
        this.height = h;
    }

    public void insertCol(int col, V[] colValues) {
        int w = this.width + 1;
        V[] v = this.arrayFactory.create(w * this.height);
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                v[(x >= col ? x + 1 : x) + y * w] = this.values[x + y * this.width];
                ++x;
            }
            ++y;
        }
        if (colValues != null) {
            y = 0;
            while (y < this.height) {
                v[col + y * w] = colValues[y];
                ++y;
            }
        }
        this.values = v;
        this.width = w;
    }

    public void removeRow(int row) {
        int h = this.height - 1;
        V[] v = this.arrayFactory.create(this.width * h);
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < this.width) {
                v[x + y * this.width] = this.values[x + (y >= row ? y + 1 : y) * this.width];
                ++x;
            }
            ++y;
        }
        this.values = v;
        this.height = h;
    }

    public void removeCol(int col) {
        int w = this.width - 1;
        V[] v = this.arrayFactory.create(w * this.height);
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < w) {
                v[x + y * w] = this.values[(x >= col ? x + 1 : x) + y * this.width];
                ++x;
            }
            ++y;
        }
        this.values = v;
        this.width = w;
    }

    public int x(double x) {
        return (int)((x - this.left) / (this.right - this.left) * (double)this.width);
    }

    public int y(double y) {
        return (int)((y - this.top) / (this.bottom - this.top) * (double)this.height);
    }

    public V[] toArray() {
        return this.values;
    }

    public Map<V, List<Coordinates>> getElement2Coordinates() {
        HashMap<V, Vector<Coordinates>> element2coordinates = new HashMap<V, Vector<Coordinates>>(this.width * this.height);
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                V element = this.get(x, y);
                if (element != null) {
                    Vector<Coordinates> coords = (Vector<Coordinates>)element2coordinates.get(element);
                    if (coords == null) {
                        coords = new Vector<Coordinates>();
                        element2coordinates.put(element, coords);
                    }
                    coords.add(new Coordinates(x, y));
                }
                ++x;
            }
            ++y;
        }
        return element2coordinates;
    }

    protected void createValues() {
        this.values = this.arrayFactory.create(this.width * this.height);
        if (this.valueFactory != null) {
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    this.set(x, y, this.valueFactory.create());
                    ++x;
                }
                ++y;
            }
        }
    }

    public static class Coordinates {
        public final int x;
        public final int y;

        public Coordinates(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Coordinates)) {
                return false;
            }
            return this.x == ((Coordinates)object).x && this.y == ((Coordinates)object).y;
        }

        public int hashCode() {
            return this.x * 13541 + this.y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }
}

