/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.util;

public class E3DMaterial
implements Cloneable {
    protected double glow = 0.0;
    protected Integer glowColor = null;
    protected double glossiness = 2.0;
    protected double reflectivity = 0.0;
    protected double transparency = 0.0;
    protected double refractivity = 0.0;

    public E3DMaterial() {
    }

    public E3DMaterial(double gloss, double mirror, double glow, Integer glowColor, double refractivity) {
        this.glow = glow;
        this.glowColor = glowColor;
        this.glossiness = gloss;
        this.reflectivity = mirror;
        this.refractivity = refractivity;
    }

    public E3DMaterial(E3DMaterial material) {
        this.glossiness = material.glossiness;
        this.reflectivity = material.reflectivity;
        this.refractivity = material.refractivity;
    }

    public E3DMaterial clone() {
        return new E3DMaterial(this);
    }

    public double getGlossiness() {
        return this.glossiness;
    }

    public void setGlossiness(double glossiness) {
        this.glossiness = glossiness;
    }

    public double getGlow() {
        return this.glow;
    }

    public void setGlow(double glow) {
        this.glow = glow;
    }

    public Integer getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(Integer glowColor) {
        this.glowColor = glowColor;
    }

    public double getReflectivity() {
        return this.reflectivity;
    }

    public void setReflectivity(double reflectivity) {
        this.reflectivity = reflectivity;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void getTransparency(double transparency) {
        this.transparency = transparency;
    }

    public double getRefractivity() {
        return this.refractivity;
    }

    public void setRefractivity(double refractivity) {
        this.refractivity = refractivity;
    }

    public boolean equals(Object object) {
        if (!(object instanceof E3DMaterial)) {
            return false;
        }
        E3DMaterial material = (E3DMaterial)object;
        return this.glossiness == material.glossiness && this.reflectivity == material.reflectivity && this.refractivity == material.refractivity;
    }

    public int hashCode() {
        return Double.valueOf(this.glossiness).hashCode() + Double.valueOf(this.reflectivity).hashCode();
    }
}

