/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.util;

import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DVector;

public abstract class E3DLight {
    final int color;
    final double luminocity;
    final double distance;
    final E3DVector position;

    public E3DLight(int color, double luminocity, double distance, E3DVector position) {
        this.color = color;
        this.luminocity = luminocity;
        this.distance = distance;
        this.position = position;
    }

    public int getColor() {
        return this.color;
    }

    public double getDistance() {
        return this.distance;
    }

    public E3DVector getPosition() {
        return this.position;
    }

    public double getLuminocity() {
        return this.luminocity;
    }

    public abstract double getLuminocity(E3DVector var1);

    public static abstract class E3DDirectedLight
    extends E3DLight {
        final E3DVector direction;
        final double angle;

        public E3DDirectedLight(int color, double luminocity, double distance, E3DVector position, E3DVector direction, double angle) {
            super(color, luminocity, distance, position);
            this.direction = direction;
            this.angle = angle;
        }

        public E3DVector getDirection() {
            return this.direction;
        }

        public double getAngle() {
            return this.angle;
        }
    }

    public static class E3DSpotLight
    extends E3DDirectedLight {
        public E3DSpotLight(int color, double luminocity, double distance, E3DVector position, E3DVector direction, double angle) {
            super(color, luminocity, distance, position, direction, angle);
        }

        @Override
        public double getLuminocity(E3DVector point) {
            E3DLine ray = new E3DLine(point, point.diff(this.position));
            double relDist = this.distance / ray.b.length();
            double emissionAngle = ray.b.angle(this.direction);
            double emission = emissionAngle <= this.angle ? this.luminocity * relDist * relDist : 0.0;
            return emission;
        }
    }

    public static class E3DUndirectedLight
    extends E3DLight {
        public E3DUndirectedLight(int color, double luminocity, double distance, E3DVector position) {
            super(color, luminocity, distance, position);
        }

        @Override
        public double getLuminocity(E3DVector point) {
            E3DLine ray = new E3DLine(point, point.diff(this.position));
            double relDist = this.distance / ray.b.length();
            double emission = this.luminocity * relDist * relDist;
            return emission;
        }
    }
}

