/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.util;

import e3d.utils.MathUtils;
import java.awt.Color;
import org.eclipse.swt.graphics.RGB;

public class E3DColor
extends Color {
    private static final long serialVersionUID = 1L;

    public static int rgb(int red, int green, int blue, int alpha) {
        return ((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF) + ((alpha & 0xFF) << 24);
    }

    public static int rgb(int rgb, int alpha) {
        return (rgb & 0xFFFFFF) + ((alpha & 0xFF) << 24);
    }

    public static int rgb(RGB rgb, int alpha) {
        return E3DColor.rgb(rgb.red, rgb.green, rgb.blue, alpha);
    }

    public static int rgb(int rgb, int value, Channel channel) {
        return E3DColor.rgb(channel == Channel.RED || channel == Channel.GRAY ? Math.max(0, Math.min(255, value)) : E3DColor.red(rgb), channel == Channel.GREEN || channel == Channel.GRAY ? Math.max(0, Math.min(255, value)) : E3DColor.green(rgb), channel == Channel.BLUE || channel == Channel.GRAY ? Math.max(0, Math.min(255, value)) : E3DColor.blue(rgb), channel == Channel.ALPHA ? Math.max(0, Math.min(255, value)) : E3DColor.alpha(rgb));
    }

    public static int red(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int green(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int blue(int rgb) {
        return rgb & 0xFF;
    }

    public static int alpha(int rgb) {
        return rgb >> 24 & 0xFF;
    }

    public static int gray(int rgb) {
        return (E3DColor.red(rgb) + E3DColor.green(rgb) + E3DColor.blue(rgb)) / 3;
    }

    public static int channel(int rgb, Channel channel) {
        switch (channel) {
            case RED: {
                return E3DColor.red(rgb);
            }
            case GREEN: {
                return E3DColor.green(rgb);
            }
            case BLUE: {
                return E3DColor.blue(rgb);
            }
            case ALPHA: {
                return E3DColor.alpha(rgb);
            }
        }
        return E3DColor.gray(rgb);
    }

    public static double similarity(int rgb1, int rgb2) {
        int r1 = E3DColor.red(rgb1);
        int g1 = E3DColor.green(rgb1);
        int b1 = E3DColor.blue(rgb1);
        int r2 = E3DColor.red(rgb2);
        int g2 = E3DColor.green(rgb2);
        int b2 = E3DColor.blue(rgb2);
        double f1 = 255.0 / MathUtils.max(r1, g1, b1);
        double f2 = 255.0 / MathUtils.max(r2, g2, b2);
        return 1.0 - (Math.pow((double)r1 * f1 - (double)r2 * f2, 2.0) + Math.pow((double)g1 * f1 - (double)g2 * f2, 2.0) + Math.pow((double)b1 * f1 - (double)b2 * f2, 2.0)) / 195075.0;
    }

    public static int illuminate(int rgb, double factor) {
        return E3DColor.rgb((int)Math.min(255.0, Math.max(0.0, (double)E3DColor.red(rgb) * factor)), (int)Math.min(255.0, Math.max(0.0, (double)E3DColor.green(rgb) * factor)), (int)Math.min(255.0, Math.max(0.0, (double)E3DColor.blue(rgb) * factor)), E3DColor.alpha(rgb));
    }

    public static int illuminate(int rgb, double r, double g, double b) {
        return E3DColor.rgb((int)Math.min(255.0, Math.max(0.0, (double)E3DColor.red(rgb) * r)), (int)Math.min(255.0, Math.max(0.0, (double)E3DColor.green(rgb) * g)), (int)Math.min(255.0, Math.max(0.0, (double)E3DColor.blue(rgb) * b)), E3DColor.alpha(rgb));
    }

    public static int mirror(int rgb, int mirrored, double reflection) {
        return E3DColor.illuminate(rgb, (double)E3DColor.red(mirrored) / 255.0 * reflection + (1.0 - reflection), (double)E3DColor.green(mirrored) / 255.0 * reflection + (1.0 - reflection), (double)E3DColor.blue(mirrored) / 255.0 * reflection + (1.0 - reflection));
    }

    public static int overlay(int fg, int bg) {
        double f = (double)E3DColor.alpha(fg) / 255.0;
        double b = 1.0 - f;
        return E3DColor.rgb((int)((double)E3DColor.red(bg) * b + (double)E3DColor.red(fg) * f), (int)((double)E3DColor.green(bg) * b + (double)E3DColor.green(fg) * f), (int)((double)E3DColor.blue(bg) * b + (double)E3DColor.blue(fg) * f), Math.max(E3DColor.alpha(fg), E3DColor.alpha(bg)));
    }

    public static int overlay(int fg, double opacity, int bg) {
        double b = 1.0 - opacity;
        return E3DColor.rgb((int)((double)E3DColor.red(bg) * b + (double)E3DColor.red(fg) * opacity), (int)((double)E3DColor.green(bg) * b + (double)E3DColor.green(fg) * opacity), (int)((double)E3DColor.blue(bg) * b + (double)E3DColor.blue(fg) * opacity), (int)((double)E3DColor.alpha(bg) * b + (double)E3DColor.alpha(fg) * opacity));
    }

    public static int changeHSB(int rgb, double hueOffset, double saturationFactor, double brightnessFactor) {
        float[] hsb = E3DColor.RGBtoHSB(E3DColor.red(rgb), E3DColor.green(rgb), E3DColor.blue(rgb), null);
        return E3DColor.rgb(E3DColor.HSBtoRGB(hsb[0] + (float)hueOffset, Math.max(0.0f, Math.min(1.0f, hsb[1] * (float)saturationFactor)), Math.max(0.0f, Math.min(1.0f, hsb[2] * (float)brightnessFactor))), E3DColor.alpha(rgb));
    }

    public static int hsb(float hue, float saturation, float brightness, int alpha) {
        return E3DColor.rgb(E3DColor.HSBtoRGB(hue, saturation, brightness), alpha);
    }

    public E3DColor(int rgb) {
        super(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, rgb >> 24 & 0xFF);
    }

    public E3DColor(int red, int green, int blue) {
        super(Math.max(0, Math.min(255, red)), Math.max(0, Math.min(255, green)), Math.max(0, Math.min(255, blue)));
    }

    public E3DColor(int red, int green, int blue, int alpha) {
        super(Math.max(0, Math.min(255, red)), Math.max(0, Math.min(255, green)), Math.max(0, Math.min(255, blue)), Math.max(0, Math.min(255, alpha)));
    }

    public E3DColor(Color color, int value, Channel channel) {
        super(channel == Channel.RED || channel == Channel.GRAY ? Math.max(0, Math.min(255, value)) : color.getRed(), channel == Channel.GREEN || channel == Channel.GRAY ? Math.max(0, Math.min(255, value)) : color.getGreen(), channel == Channel.BLUE || channel == Channel.GRAY ? Math.max(0, Math.min(255, value)) : color.getBlue(), channel == Channel.ALPHA ? Math.max(0, Math.min(255, value)) : color.getAlpha());
    }

    public E3DColor(RGB rgb, int alpha) {
        super(rgb.red, rgb.green, rgb.blue, alpha);
    }

    public int getGray() {
        return (this.getRed() + this.getGreen() + this.getBlue()) / 3;
    }

    public int getChannel(Channel channel) {
        switch (channel) {
            case RED: {
                return this.getRed();
            }
            case GREEN: {
                return this.getGreen();
            }
            case BLUE: {
                return this.getBlue();
            }
            case ALPHA: {
                return this.getAlpha();
            }
        }
        return this.getGray();
    }

    public double similarity(Color color) {
        return E3DColor.similarity(this.getRGB(), color.getRGB());
    }

    public E3DColor illuminate(double factor) {
        return new E3DColor(E3DColor.illuminate(this.getRGB(), factor));
    }

    public E3DColor mirror(Color mirrored, double reflection) {
        return new E3DColor(E3DColor.mirror(this.getRGB(), mirrored.getRGB(), reflection));
    }

    public E3DColor overlay(Color bg) {
        return new E3DColor(E3DColor.overlay(this.getRGB(), bg.getRGB()));
    }

    public E3DColor overlay(double opacity, Color bg) {
        return new E3DColor(E3DColor.overlay(this.getRGB(), opacity, bg.getRGB()));
    }

    public E3DColor changeHSB(double hueOffset, double saturationFactor, double brightnessFactor) {
        return new E3DColor(E3DColor.changeHSB(this.getRGB(), hueOffset, saturationFactor, brightnessFactor));
    }

    @Override
    public String toString() {
        return "E3EColor[r=" + this.getRed() + ", " + "g=" + this.getGreen() + ", " + "b=" + this.getBlue() + ", " + "a=" + this.getAlpha() + "]";
    }

    public static enum Channel {
        RED,
        GREEN,
        BLUE,
        ALPHA,
        GRAY;

    }
}

