/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.util;

import e3d.euclidean.E3DVector;

public class E3DBoundingBox {
    public double x0;
    public double x1;
    public double y0;
    public double y1;
    public double z0;
    public double z1;

    public E3DBoundingBox() {
    }

    public E3DBoundingBox(double left, double top, double front, double right, double bottom, double back) {
        this.x0 = left;
        this.x1 = right;
        this.y0 = top;
        this.y1 = bottom;
        this.z0 = front;
        this.z1 = back;
    }

    public double width() {
        return this.x1 - this.x0;
    }

    public double height() {
        return this.y1 - this.y0;
    }

    public double depth() {
        return this.z1 - this.z0;
    }

    public E3DVector center() {
        return new E3DVector((this.x0 + this.x1) / 2.0, (this.y0 + this.y1) / 2.0, (this.z0 + this.z1) / 2.0);
    }

    public double radius() {
        double w = this.x1 - this.x0;
        double h = this.y1 - this.y0;
        double d = this.z1 - this.z0;
        return Math.sqrt(w * w + h * h + d * d) / 2.0;
    }

    public String toString() {
        return "BOUNDS: (" + this.x0 + ", " + this.y0 + ", " + this.z0 + ") - (" + this.x1 + ", " + this.y1 + ", " + this.z1 + ")";
    }
}

