/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.space;

import e3d.euclidean.E3DVector;
import e3d.utils.MathUtils;
import e3d.visualization.space.AtomicSubSpace;
import e3d.visualization.space.Coords;
import e3d.visualization.space.Point;
import e3d.visualization.space.Scan;
import e3d.visualization.space.Voxel;
import e3d.visualization.util.E3DBoundingBox;

public abstract class Space<Atom extends AtomicSubSpace<Atom>>
implements Scan<Atom> {
    protected final Coords coords;
    protected final int levels;
    protected final int size;
    protected final int width;
    protected final int height;
    protected final int depth;

    public Space(E3DBoundingBox bounds, int levels) {
        this.levels = Math.max(0, levels);
        this.width = this.size = 1 << this.levels;
        this.height = this.size;
        this.depth = this.size;
        this.coords = new Coords(bounds, this.size);
    }

    public Space(E3DBoundingBox bounds, int width, int height, int depth) {
        int size = MathUtils.maxInt(width, height, depth);
        int levels = 0;
        int s = size;
        while (s > 1) {
            ++levels;
            s >>= 1;
        }
        if (1 << levels < size) {
            ++levels;
        }
        this.levels = Math.max(0, levels);
        this.size = 1 << this.levels;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.coords = new Coords(bounds.x0, bounds.y0, bounds.z0, bounds.x0 + bounds.width() / (double)width * (double)this.size, bounds.y0 + bounds.height() / (double)height * (double)this.size, bounds.z0 + bounds.depth() / (double)depth * (double)this.size, this.size);
    }

    public Space(Space<?> space) {
        this.levels = space.levels;
        this.size = space.size;
        this.width = space.width;
        this.height = space.height;
        this.depth = space.depth;
        this.coords = space.coords;
    }

    public Coords getCoords() {
        return this.coords;
    }

    @Override
    public E3DBoundingBox getBounds() {
        return new E3DBoundingBox(this.coords.x1(), this.coords.y1(), this.coords.z1(), this.coords.x2(), this.coords.y2(), this.coords.z2());
    }

    @Override
    public E3DBoundingBox getTightBounds() {
        return new E3DBoundingBox(this.coords.x1(), this.coords.y1(), this.coords.z1(), this.coords.x2(this.width - 1), this.coords.y2(this.height - 1), this.coords.z2(this.depth - 1));
    }

    public E3DVector xyz(Voxel<Atom> voxel) {
        return new E3DVector(this.coords.x(voxel.i()), this.coords.y(voxel.j()), this.coords.z(voxel.k()));
    }

    @Override
    public E3DVector getCenter() {
        return new E3DVector((this.coords.x(0) + this.coords.x(this.width - 1)) / 2.0, (this.coords.y(0) + this.coords.y(this.height - 1)) / 2.0, (this.coords.z(0) + this.coords.z(this.depth - 1)) / 2.0);
    }

    public int getLevels() {
        return this.levels;
    }

    @Override
    public E3DVector getElementSize() {
        double n = this.size;
        return new E3DVector((this.coords.x2() - this.coords.x1()) / n, (this.coords.y2() - this.coords.y1()) / n, (this.coords.z2() - this.coords.z1()) / n);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public int getSize() {
        return this.size;
    }

    public abstract boolean isEmpty(int var1, int var2, int var3);

    public abstract boolean isEmpty(double var1, double var3, double var5);

    public abstract Voxel<Atom> getVoxel(double var1, double var3, double var5);

    public abstract Voxel<Atom> getVoxel(int var1, int var2, int var3);

    public abstract Atom getAtom(double var1, double var3, double var5);

    public abstract Atom getAtom(int var1, int var2, int var3);

    @Override
    public abstract Voxel<Atom> getNextVoxelInRay(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    @Override
    public abstract Point<Atom> getNextPointInRay(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    @Override
    public abstract Atom getNextAtomInRay(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public boolean isOutOfBounds(double x, double y, double z) {
        return x < this.coords.x1() || x > this.coords.x2() || y < this.coords.y1() || y > this.coords.y2() || z < this.coords.z1() || z > this.coords.z2();
    }

    public boolean isOutOfBounds(double x, double y, double z, double dx, double dy, double dz) {
        return x + dx < this.coords.x1() || x - dx > this.coords.x2() || y + dy < this.coords.y1() || y - dy > this.coords.y2() || z + dz < this.coords.z1() || z - dz > this.coords.z2();
    }

    public boolean isOutOfBounds(int i, int j, int k) {
        return i < 0 || i >= this.size || j < 0 || j >= this.size || k < 0 || k >= this.size;
    }

    public boolean isOutOfBounds(int i1, int j1, int k1, int i2, int j2, int k2) {
        return i2 < 0 || i1 >= this.size || j2 < 0 || j1 >= this.size || k2 < 0 || k1 >= this.size;
    }
}

