/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.space;

import e3d.utils.MathUtils;
import e3d.visualization.space.AtomicSubSpace;
import e3d.visualization.space.BinarySpaceTasks;
import e3d.visualization.space.Coords;
import e3d.visualization.space.SubSpace;

final class ComplexSubSpace<Atom extends AtomicSubSpace<Atom>>
extends SubSpace<Atom> {
    protected final SubSpace<Atom>[][][] sub = new SubSpace[2][2][2];

    protected ComplexSubSpace() {
    }

    @Override
    protected void clear() {
        int a = 0;
        while (a < 2) {
            int b = 0;
            while (b < 2) {
                int c = 0;
                while (c < 2) {
                    this.sub[a][b][c] = null;
                    ++c;
                }
                ++b;
            }
            ++a;
        }
    }

    @Override
    protected boolean isEmpty() {
        return this.sub[0][0][0] == null && this.sub[0][0][1] == null && this.sub[0][1][0] == null && this.sub[0][1][1] == null && this.sub[1][0][0] == null && this.sub[1][0][1] == null && this.sub[1][1][0] == null && this.sub[1][1][1] == null;
    }

    @Override
    protected void perform(int i, int j, int k, int i0, int j0, int k0, int n, BinarySpaceTasks.IJKTask<Atom> task) {
        int m = n >> 1;
        if (i < m) {
            if (j < m) {
                if (k < m) {
                    task.on(this, i, j, k, i0, j0, k0, m, 0, 0, 0);
                } else {
                    task.on(this, i, j, k - m, i0, j0, k0 + m, m, 0, 0, 1);
                }
            } else if (k < m) {
                task.on(this, i, j - m, k, i0, j0 + m, k0, m, 0, 1, 0);
            } else {
                task.on(this, i, j - m, k - m, i0, j0 + m, k0 + m, m, 0, 1, 1);
            }
        } else if (j < m) {
            if (k < m) {
                task.on(this, i - m, j, k, i0 + m, j0, k0, m, 1, 0, 0);
            } else {
                task.on(this, i - m, j, k - m, i0 + m, j0, k0 + m, m, 1, 0, 1);
            }
        } else if (k < m) {
            task.on(this, i - m, j - m, k, i0 + m, j0 + m, k0, m, 1, 1, 0);
        } else {
            task.on(this, i - m, j - m, k - m, i0 + m, j0 + m, k0 + m, m, 1, 1, 1);
        }
    }

    @Override
    protected void perform(double x, double y, double z, int i0, int j0, int k0, int n, Coords coords, BinarySpaceTasks.XYZTask<Atom> task) {
        int m = n >> 1;
        double xm = coords.x1(i0 + m);
        double ym = coords.y1(j0 + m);
        double zm = coords.z1(k0 + m);
        if (x < xm) {
            if (y < ym) {
                if (z < zm) {
                    task.on(this, x, y, z, i0, j0, k0, m, coords, 0, 0, 0);
                } else {
                    task.on(this, x, y, z, i0, j0, k0 + m, m, coords, 0, 0, 1);
                }
            } else if (z < zm) {
                task.on(this, x, y, z, i0, j0 + m, k0, m, coords, 0, 1, 0);
            } else {
                task.on(this, x, y, z, i0, j0 + m, k0 + m, m, coords, 0, 1, 1);
            }
        } else if (y < ym) {
            if (z < zm) {
                task.on(this, x, y, z, i0 + m, j0, k0, m, coords, 1, 0, 0);
            } else {
                task.on(this, x, y, z, i0 + m, j0, k0 + m, m, coords, 1, 0, 1);
            }
        } else if (z < zm) {
            task.on(this, x, y, z, i0 + m, j0 + m, k0, m, coords, 1, 1, 0);
        } else {
            task.on(this, x, y, z, i0 + m, j0 + m, k0 + m, m, coords, 1, 1, 1);
        }
    }

    @Override
    protected void perform(int i0, int j0, int k0, int n, BinarySpaceTasks.AllTask<Atom> task) {
        int m = n >> 1;
        task.on(this, i0, j0, k0, m, 0, 0, 0);
        task.on(this, i0, j0, k0 + m, m, 0, 0, 1);
        task.on(this, i0, j0 + m, k0, m, 0, 1, 0);
        task.on(this, i0, j0 + m, k0 + m, m, 0, 1, 1);
        task.on(this, i0 + m, j0, k0, m, 1, 0, 0);
        task.on(this, i0 + m, j0, k0 + m, m, 1, 0, 1);
        task.on(this, i0 + m, j0 + m, k0, m, 1, 1, 0);
        task.on(this, i0 + m, j0 + m, k0 + m, m, 1, 1, 1);
    }

    @Override
    protected void perform(int i1, int j1, int k1, int i2, int j2, int k2, int i0, int j0, int k0, int n, BinarySpaceTasks.IJKAreaTask<Atom> task) {
        int m = n >> 1;
        if (i1 <= 0 && i2 >= n - 1 && j1 <= 0 && j2 >= n - 1 && k1 <= 0 && k2 >= n - 1) {
            task.on(this, i0, j0, k0, n);
        } else {
            if (i1 < m) {
                if (j1 < m) {
                    if (k1 < m) {
                        task.on(this, i1, j1, k1, i2, j2, k2, i0, j0, k0, m, 0, 0, 0);
                    }
                    if (k2 >= m) {
                        task.on(this, i1, j1, k1 - m, i2, j2, k2 - m, i0, j0, k0 + m, m, 0, 0, 1);
                    }
                }
                if (j2 >= m) {
                    if (k1 < m) {
                        task.on(this, i1, j1 - m, k1, i2, j2 - m, k2, i0, j0 + m, k0, m, 0, 1, 0);
                    }
                    if (k2 >= m) {
                        task.on(this, i1, j1 - m, k1 - m, i2, j2 - m, k2 - m, i0, j0 + m, k0 + m, m, 0, 1, 1);
                    }
                }
            }
            if (i2 >= m) {
                if (j1 < m) {
                    if (k1 < m) {
                        task.on(this, i1 - m, j1, k1, i2 - m, j2, k2, i0 + m, j0, k0, m, 1, 0, 0);
                    }
                    if (k2 >= m) {
                        task.on(this, i1 - m, j1, k1 - m, i2 - m, j2, k2 - m, i0 + m, j0, k0 + m, m, 1, 0, 1);
                    }
                }
                if (j2 >= m) {
                    if (k1 < m) {
                        task.on(this, i1 - m, j1 - m, k1, i2 - m, j2 - m, k2, i0 + m, j0 + m, k0, m, 1, 1, 0);
                    }
                    if (k2 >= m) {
                        task.on(this, i1 - m, j1 - m, k1 - m, i2 - m, j2 - m, k2 - m, i0 + m, j0 + m, k0 + m, m, 1, 1, 1);
                    }
                }
            }
        }
    }

    @Override
    protected void perform(double x, double y, double z, double dx, double dy, double dz, int i0, int j0, int k0, int n, Coords coords, BinarySpaceTasks.XYZAreaTask<Atom> task) {
        int m = n >> 1;
        if (x - dx <= coords.x1(i0) && x + dx >= coords.x1(i0 + n) && y - dy <= coords.y1(j0) && y + dy >= coords.y1(j0 + n) && z - dz <= coords.z1(k0) && z + dz >= coords.z1(k0 + n)) {
            task.on(this, i0, j0, k0, n);
        } else {
            double xm = coords.x1(i0 + m);
            double ym = coords.y1(j0 + m);
            double zm = coords.z1(k0 + m);
            if (x - dx < xm) {
                if (y - dy < ym) {
                    if (z - dz < zm) {
                        task.on(this, x, y, z, dx, dy, dz, i0, j0, k0, m, coords, 0, 0, 0);
                    }
                    if (z + dz > zm) {
                        task.on(this, x, y, z, dx, dy, dz, i0, j0, k0 + m, m, coords, 0, 0, 1);
                    }
                }
                if (y + dy >= ym) {
                    if (z - dz < zm) {
                        task.on(this, x, y, z, dx, dy, dz, i0, j0 + m, k0, m, coords, 0, 1, 0);
                    }
                    if (z + dz >= zm) {
                        task.on(this, x, y, z, dx, dy, dz, i0, j0 + m, k0 + m, m, coords, 0, 1, 1);
                    }
                }
            }
            if (x + dx >= xm) {
                if (y - dy < ym) {
                    if (z - dz < zm) {
                        task.on(this, x, y, z, dx, dy, dz, i0 + m, j0, k0, m, coords, 1, 0, 0);
                    }
                    if (z + dz >= zm) {
                        task.on(this, x, y, z, dx, dy, dz, i0 + m, j0, k0 + m, m, coords, 1, 0, 1);
                    }
                }
                if (y + dy >= ym) {
                    if (z - dz < zm) {
                        task.on(this, x, y, z, dx, dy, dz, i0 + m, j0 + m, k0, m, coords, 1, 1, 0);
                    }
                    if (z + dz >= zm) {
                        task.on(this, x, y, z, dx, dy, dz, i0 + m, j0 + m, k0 + m, m, coords, 1, 1, 1);
                    }
                }
            }
        }
    }

    @Override
    protected void perform(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax, double t, int i0, int j0, int k0, int n, Coords coords, BinarySpaceTasks.XYZRayTask<Atom> task) {
        int m = n >> 1;
        double xm = coords.x1(i0 + m);
        double ym = coords.y1(j0 + m);
        double zm = coords.z1(k0 + m);
        if (x < xm) {
            if (y < ym) {
                if (z < zm) {
                    this.perform(x, y, z, dx, dy, dz, tmin, tmax, t, i0, j0, k0, i0 + m, j0 + m, k0 + m, m, coords, task, 0, 0, 0);
                } else {
                    this.perform(x, y, z, dx, dy, dz, tmin, tmax, t, i0, j0, k0 + m, i0 + m, j0 + m, k0, m, coords, task, 0, 0, 1);
                }
            } else if (z < zm) {
                this.perform(x, y, z, dx, dy, dz, tmin, tmax, t, i0, j0 + m, k0, i0 + m, j0, k0 + m, m, coords, task, 0, 1, 0);
            } else {
                this.perform(x, y, z, dx, dy, dz, tmin, tmax, t, i0, j0 + m, k0 + m, i0 + m, j0, k0, m, coords, task, 0, 1, 1);
            }
        } else if (y < ym) {
            if (z < zm) {
                this.perform(x, y, z, dx, dy, dz, tmin, tmax, t, i0 + m, j0, k0, i0, j0 + m, k0 + m, m, coords, task, 1, 0, 0);
            } else {
                this.perform(x, y, z, dx, dy, dz, tmin, tmax, t, i0 + m, j0, k0 + m, i0, j0 + m, k0, m, coords, task, 1, 0, 1);
            }
        } else if (z < zm) {
            this.perform(x, y, z, dx, dy, dz, tmin, tmax, t, i0 + m, j0 + m, k0, i0, j0, k0 + m, m, coords, task, 1, 1, 0);
        } else {
            this.perform(x, y, z, dx, dy, dz, tmin, tmax, t, i0 + m, j0 + m, k0 + m, i0, j0, k0, m, coords, task, 1, 1, 1);
        }
    }

    private void perform(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax, double t, int i0, int j0, int k0, int i1, int j1, int k1, int n, Coords coords, BinarySpaceTasks.XYZRayTask<Atom> task, int a, int b, int c) {
        if (t > tmax) {
            return;
        }
        if (this.sub[a][b][c] != null) {
            this.sub[a][b][c].perform(x, y, z, dx, dy, dz, tmin, tmax, t, i0, j0, k0, n, coords, task);
        }
        if (!task.isDone()) {
            int cn;
            double fy;
            double fx;
            double x1 = coords.x1(i0);
            double y1 = coords.y1(j0);
            double z1 = coords.z1(k0);
            double x2 = coords.x1(i0 + n);
            double y2 = coords.y1(j0 + n);
            double z2 = coords.z1(k0 + n);
            double d = dx < 0.0 ? (x1 - x) / dx : (fx = dx > 0.0 ? (x2 - x) / dx : Double.POSITIVE_INFINITY);
            double d2 = dy < 0.0 ? (y1 - y) / dy : (fy = dy > 0.0 ? (y2 - y) / dy : Double.POSITIVE_INFINITY);
            double fz = dz < 0.0 ? (z1 - z) / dz : (dz > 0.0 ? (z2 - z) / dz : Double.POSITIVE_INFINITY);
            double fmin = MathUtils.min(fx, fy, fz);
            double xn = x + dx * fmin;
            double yn = y + dy * fmin;
            double zn = z + dz * fmin;
            int an = fx == fmin ? a + MathUtils.signum(dx) : a;
            int bn = fy == fmin ? b + MathUtils.signum(dy) : b;
            int n2 = cn = fz == fmin ? c + MathUtils.signum(dz) : c;
            if (!(an != 0 && an != 1 || bn != 0 && bn != 1 || cn != 0 && cn != 1)) {
                if (fx == fmin) {
                    i0 = i1;
                    i1 = -1;
                }
                if (fy == fmin) {
                    j0 = j1;
                    j1 = -1;
                }
                if (fz == fmin) {
                    k0 = k1;
                    k1 = -1;
                }
                if (i0 >= 0 && j0 >= 0 && k0 >= 0) {
                    this.perform(xn, yn, zn, dx, dy, dz, tmin, tmax, t + fmin, i0, j0, k0, i1, j1, k1, n, coords, task, an, bn, cn);
                }
            }
        }
    }
}

