/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.space;

import e3d.utils.MathUtils;
import e3d.visualization.space.AtomicSubSpace;
import e3d.visualization.space.BinarySpaceTasks;
import e3d.visualization.space.ComplexSubSpace;
import e3d.visualization.space.Point;
import e3d.visualization.space.Space;
import e3d.visualization.space.SubSpace;
import e3d.visualization.space.Voxel;
import e3d.visualization.util.E3DBoundingBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BinarySpace<Atom extends AtomicSubSpace<Atom>>
extends Space<Atom> {
    private final SubSpace<Atom> sub;
    private BinarySpaceTasks.IJKEmptyChecker<Atom> ijkEmptyChecker = new BinarySpaceTasks.IJKEmptyChecker();
    private BinarySpaceTasks.IJKRemover<Atom> ijkRemover = new BinarySpaceTasks.IJKRemover();
    private BinarySpaceTasks.IJKAtomGetter<Atom> ijkAtomGetter = new BinarySpaceTasks.IJKAtomGetter();
    private BinarySpaceTasks.IJKVoxelGetter<Atom> ijkVoxelGetter = new BinarySpaceTasks.IJKVoxelGetter();
    private BinarySpaceTasks.IJKAtomSetter<Atom> ijkAtomSetter = new BinarySpaceTasks.IJKAtomSetter<Object>(null);
    private BinarySpaceTasks.IJKVoxelSetter<Atom> ijkVoxelSetter = new BinarySpaceTasks.IJKVoxelSetter<Object>(null);
    private BinarySpaceTasks.IJKAreaEmptyChecker<Atom> ijkAreaEmptyChecker = new BinarySpaceTasks.IJKAreaEmptyChecker();
    private BinarySpaceTasks.IJKAreaRemover<Atom> ijkAreaRemover = new BinarySpaceTasks.IJKAreaRemover();
    private BinarySpaceTasks.IJKArea1stAtomGetter<Atom> ijkArea1stAtomGetter = new BinarySpaceTasks.IJKArea1stAtomGetter(false);
    private BinarySpaceTasks.IJKArea1stVoxelGetter<Atom> ijkArea1stVoxelGetter = new BinarySpaceTasks.IJKArea1stVoxelGetter(false);
    private BinarySpaceTasks.IJKAreaVoxelGetter<Atom> ijkAreaVoxelGetter = new BinarySpaceTasks.IJKAreaVoxelGetter(null);
    private BinarySpaceTasks.XYZEmptyChecker<Atom> xyzEmptyChecker = new BinarySpaceTasks.XYZEmptyChecker();
    private BinarySpaceTasks.XYZRemover<Atom> xyzRemover = new BinarySpaceTasks.XYZRemover();
    private BinarySpaceTasks.XYZAtomGetter<Atom> xyzAtomGetter = new BinarySpaceTasks.XYZAtomGetter();
    private BinarySpaceTasks.XYZVoxelGetter<Atom> xyzVoxelGetter = new BinarySpaceTasks.XYZVoxelGetter();
    private BinarySpaceTasks.XYZAtomSetter<Atom> xyzAtomSetter = new BinarySpaceTasks.XYZAtomSetter<Object>(null);
    private BinarySpaceTasks.XYZVoxelSetter<Atom> xyzVoxelSetter = new BinarySpaceTasks.XYZVoxelSetter<Object>(null);
    private BinarySpaceTasks.XYZAreaEmptyChecker<Atom> xyzAreaEmptyChecker = new BinarySpaceTasks.XYZAreaEmptyChecker();
    private BinarySpaceTasks.XYZAreaRemover<Atom> xyzAreaRemover = new BinarySpaceTasks.XYZAreaRemover();
    private BinarySpaceTasks.XYZArea1stAtomGetter<Atom> xyzArea1stAtomGetter = new BinarySpaceTasks.XYZArea1stAtomGetter(false);
    private BinarySpaceTasks.XYZArea1stVoxelGetter<Atom> xyzArea1stVoxelGetter = new BinarySpaceTasks.XYZArea1stVoxelGetter(false);
    private BinarySpaceTasks.XYZAreaVoxelGetter<Atom> xyzAreaVoxelGetter = new BinarySpaceTasks.XYZAreaVoxelGetter(null);
    private BinarySpaceTasks.XYZRayNextAtomGetter<Atom> xyzRayNextAtomGetter = new BinarySpaceTasks.XYZRayNextAtomGetter();
    private BinarySpaceTasks.XYZRayNextVoxelGetter<Atom> xyzRayNextVoxelGetter = new BinarySpaceTasks.XYZRayNextVoxelGetter();
    private BinarySpaceTasks.XYZRayNextPointGetter<Atom> xyzRayNextPointGetter = new BinarySpaceTasks.XYZRayNextPointGetter();

    public BinarySpace(E3DBoundingBox bounds, int levels) {
        super(bounds, levels);
        this.sub = new ComplexSubSpace();
    }

    public BinarySpace(E3DBoundingBox bounds, int width, int height, int depth) {
        super(bounds, width, height, depth);
        this.sub = new ComplexSubSpace();
    }

    public BinarySpace(Space<?> space) {
        super(space);
        this.sub = new ComplexSubSpace();
    }

    protected BinarySpace(SubSpace<Atom> sub, E3DBoundingBox bounds, int levels) {
        super(bounds, levels);
        this.sub = sub;
    }

    public void clear() {
        this.sub.clear();
    }

    @Override
    public final boolean isEmpty(int i, int j, int k) {
        this.ijkEmptyChecker.reinit();
        this.perform(i, j, k, this.ijkEmptyChecker);
        return this.ijkEmptyChecker.isEmpty();
    }

    @Override
    public final boolean isEmpty(double x, double y, double z) {
        this.xyzEmptyChecker.reinit();
        this.perform(x, y, z, this.xyzEmptyChecker);
        return this.xyzEmptyChecker.isEmpty();
    }

    public final boolean isEmpty(int i1, int j1, int k1, int i2, int j2, int k2) {
        this.ijkAreaEmptyChecker.reinit();
        this.perform(i1, j1, k1, i2, j2, k2, this.ijkAreaEmptyChecker);
        return this.ijkAreaEmptyChecker.isEmpty();
    }

    public final boolean isEmpty(double x, double y, double z, double dx, double dy, double dz) {
        this.xyzAreaEmptyChecker.reinit();
        this.perform(x, y, z, dx, dy, dz, this.xyzAreaEmptyChecker);
        return this.xyzAreaEmptyChecker.isEmpty();
    }

    public final Voxel<Atom> setVoxel(Atom atom, double x, double y, double z) {
        this.xyzVoxelSetter.reinit(atom);
        this.perform(x, y, z, this.xyzVoxelSetter);
        return this.xyzVoxelSetter.getVoxel();
    }

    public final Voxel<Atom> setVoxel(Atom atom, int i, int j, int k) {
        this.ijkVoxelSetter.reinit(atom);
        this.perform(i, j, k, this.ijkVoxelSetter);
        return this.ijkVoxelSetter.getVoxel();
    }

    public final void setAtom(Atom atom, double x, double y, double z) {
        this.xyzAtomSetter.reinit(atom);
        this.perform(x, y, z, this.xyzAtomSetter);
    }

    public final void setAtom(Atom atom, int i, int j, int k) {
        this.ijkAtomSetter.reinit(atom);
        this.perform(i, j, k, this.ijkAtomSetter);
    }

    public final void remove(double x, double y, double z) {
        this.perform(x, y, z, this.xyzRemover);
    }

    public final void remove(int i, int j, int k) {
        this.perform(i, j, k, this.ijkRemover);
    }

    public final void remove(double x, double y, double z, double dx, double dy, double dz) {
        this.perform(x, y, z, dx, dy, dz, this.xyzAreaRemover);
    }

    public final void remove(int i1, int j1, int k1, int i2, int j2, int k2) {
        this.perform(i1, j1, k1, i2, j2, k2, this.ijkAreaRemover);
    }

    @Override
    public final Voxel<Atom> getVoxel(double x, double y, double z) {
        this.xyzVoxelGetter.reinit();
        this.perform(x, y, z, this.xyzVoxelGetter);
        return this.xyzVoxelGetter.getVoxel();
    }

    @Override
    public final Voxel<Atom> getVoxel(int i, int j, int k) {
        this.ijkVoxelGetter.reinit();
        this.perform(i, j, k, this.ijkVoxelGetter);
        return this.ijkVoxelGetter.getVoxel();
    }

    @Override
    public final Atom getAtom(double x, double y, double z) {
        this.xyzAtomGetter.reinit();
        this.perform(x, y, z, this.xyzAtomGetter);
        return this.xyzAtomGetter.getAtom();
    }

    @Override
    public final Atom getAtom(int i, int j, int k) {
        this.ijkAtomGetter.reinit();
        this.perform(i, j, k, this.ijkAtomGetter);
        return this.ijkAtomGetter.getAtom();
    }

    @Override
    public final Voxel<Atom> getNextVoxelInRay(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax) {
        this.xyzRayNextVoxelGetter.reinit();
        this.perform(x, y, z, dx, dy, dz, tmin, tmax, this.xyzRayNextVoxelGetter);
        return this.xyzRayNextVoxelGetter.getVoxel();
    }

    @Override
    public final Point<Atom> getNextPointInRay(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax) {
        this.xyzRayNextPointGetter.reinit();
        this.perform(x, y, z, dx, dy, dz, tmin, tmax, this.xyzRayNextPointGetter);
        return this.xyzRayNextPointGetter.getVoxel();
    }

    @Override
    public final Atom getNextAtomInRay(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax) {
        this.xyzRayNextAtomGetter.reinit();
        this.perform(x, y, z, dx, dy, dz, tmin, tmax, this.xyzRayNextAtomGetter);
        return this.xyzRayNextAtomGetter.getAtom();
    }

    public final List<Voxel<Atom>> getAllVoxelsInArea(double x, double y, double z, double dx, double dy, double dz) {
        ArrayList<Voxel<Atom>> voxels = new ArrayList<Voxel<Atom>>();
        this.getAllVoxelsInArea(x, y, z, dx, dy, dz, voxels);
        return voxels;
    }

    public final void getAllVoxelsInArea(double x, double y, double z, double dx, double dy, double dz, List<Voxel<Atom>> voxels) {
        this.xyzAreaVoxelGetter.reinit(voxels);
        this.perform(x, y, z, dx, dy, dz, this.xyzAreaVoxelGetter);
    }

    public final List<Voxel<Atom>> getAllVoxelsInArea(int i1, int j1, int k1, int i2, int j2, int k2) {
        ArrayList<Voxel<Atom>> voxels = new ArrayList<Voxel<Atom>>();
        this.getAllVoxelsInArea(i1, j1, k1, i2, j2, k2, (List<Voxel<Atom>>)voxels);
        return voxels;
    }

    public final void getAllVoxelsInArea(int i1, int j1, int k1, int i2, int j2, int k2, List<Voxel<Atom>> voxels) {
        this.ijkAreaVoxelGetter.reinit(voxels);
        this.perform(i1, j1, k1, i2, j2, k2, this.ijkAreaVoxelGetter);
    }

    public final List<Voxel<Atom>> getAllVoxels() {
        ArrayList<Voxel<Atom>> voxels = new ArrayList<Voxel<Atom>>();
        this.getAllVoxels(voxels);
        return voxels;
    }

    public final void getAllVoxels(Collection<Voxel<Atom>> voxels) {
        this.ijkAreaVoxelGetter.reinit(voxels);
        this.perform(0, 0, 0, this.size - 1, this.size - 1, this.size - 1, this.ijkAreaVoxelGetter);
    }

    public final Voxel<Atom> getFirstVoxel(boolean remove) {
        this.ijkArea1stVoxelGetter.reinit(remove);
        this.perform(0, 0, 0, this.size - 1, this.size - 1, this.size - 1, this.ijkArea1stVoxelGetter);
        return this.ijkArea1stVoxelGetter.get1stVoxel();
    }

    public final Atom getFirstAtom(boolean remove) {
        this.ijkArea1stAtomGetter.reinit(remove);
        this.perform(0, 0, 0, this.size - 1, this.size - 1, this.size - 1, this.ijkArea1stAtomGetter);
        return this.ijkArea1stAtomGetter.get1stAtom();
    }

    public final Voxel<Atom> getFirstVoxel(double x, double y, double z, double dx, double dy, double dz, boolean remove) {
        this.xyzArea1stVoxelGetter.reinit(remove);
        this.perform(x, y, z, dx, dy, dz, this.xyzArea1stVoxelGetter);
        return this.xyzArea1stVoxelGetter.get1stVoxel();
    }

    public final Voxel<Atom> getFirstVoxel(int i1, int j1, int k1, int i2, int j2, int k2, boolean remove) {
        this.ijkArea1stVoxelGetter.reinit(remove);
        this.perform(i1, j1, k1, i2, j2, k2, this.ijkArea1stVoxelGetter);
        return this.ijkArea1stVoxelGetter.get1stVoxel();
    }

    public final Atom getFirstAtom(double x, double y, double z, double dx, double dy, double dz, boolean remove) {
        this.xyzArea1stAtomGetter.reinit(remove);
        this.perform(x, y, z, dx, dy, dz, this.xyzArea1stAtomGetter);
        return this.xyzArea1stAtomGetter.get1stAtom();
    }

    public final Atom getFirstAtom(int i1, int j1, int k1, int i2, int j2, int k2, boolean remove) {
        this.ijkArea1stAtomGetter.reinit(remove);
        this.perform(i1, j1, k1, i2, j2, k2, this.ijkArea1stAtomGetter);
        return this.ijkArea1stAtomGetter.get1stAtom();
    }

    public final void perform(double x, double y, double z, BinarySpaceTasks.XYZTask<Atom> task) {
        if (!this.isOutOfBounds(x, y, z)) {
            this.sub.perform(x, y, z, 0, 0, 0, this.size, this.coords, task);
        }
    }

    public final void perform(int i, int j, int k, BinarySpaceTasks.IJKTask<Atom> task) {
        if (!this.isOutOfBounds(i, j, k)) {
            this.sub.perform(i, j, k, 0, 0, 0, this.size, task);
        }
    }

    public final void perform(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax, BinarySpaceTasks.XYZRayTask<Atom> task) {
        double t;
        if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
            return;
        }
        if (this.isOutOfBounds(x, y, z)) {
            double fy;
            double fx;
            double d = dx < 0.0 && x >= this.coords.x2() ? (this.coords.x2() - x) / dx : (fx = dx > 0.0 && x <= this.coords.x1() ? (this.coords.x1() - x) / dx : Double.NEGATIVE_INFINITY);
            double d2 = dy < 0.0 && y >= this.coords.y2() ? (this.coords.y2() - y) / dy : (fy = dy > 0.0 && y <= this.coords.y1() ? (this.coords.y1() - y) / dy : Double.NEGATIVE_INFINITY);
            double fz = dz < 0.0 && z >= this.coords.z2() ? (this.coords.z2() - z) / dz : (dz > 0.0 && z <= this.coords.z1() ? (this.coords.z1() - z) / dz : Double.NEGATIVE_INFINITY);
            double fmin = MathUtils.max(fx, fy, fz);
            if (fmin == Double.NEGATIVE_INFINITY) {
                return;
            }
            x += dx * fmin;
            y += dy * fmin;
            z += dz * fmin;
            t = fmin;
        } else {
            t = 0.0;
        }
        this.sub.perform(x, y, z, dx, dy, dz, tmin, tmax, t, 0, 0, 0, this.size, this.coords, task);
    }

    public final void perform(double x, double y, double z, double dx, double dy, double dz, BinarySpaceTasks.XYZAreaTask<Atom> task) {
        if (!this.isOutOfBounds(x, y, z, dx, dy, dz)) {
            this.sub.perform(x, y, z, dx, dy, dz, 0, 0, 0, this.size, this.coords, task);
        }
    }

    public final void perform(int i1, int j1, int k1, int i2, int j2, int k2, BinarySpaceTasks.IJKAreaTask<Atom> task) {
        if (!this.isOutOfBounds(i1, j1, k1, i2, k2, j2)) {
            this.sub.perform(i1, j1, k1, i2, j2, k2, 0, 0, 0, this.size, task);
        }
    }

    public final void perform(BinarySpaceTasks.AllTask<Atom> task) {
        this.sub.perform(0, 0, 0, this.size, task);
    }

    public String toString() {
        StringBuffer string = new StringBuffer("SPACE:\n");
        int n = this.getSize();
        List<Voxel<Atom>> voxels = this.getAllVoxels();
        string.append("  " + this.getBounds() + "\n");
        string.append("  LEVELS: " + this.levels + " (" + n + "x" + n + "x" + n + ")\n");
        string.append("  ELEMENT-SIZE: " + this.getElementSize() + "\n");
        string.append("  " + voxels.size() + " VOXELS:\n");
        for (Voxel<Atom> voxel : voxels) {
            string.append("    " + voxel + "\n");
        }
        return string.toString();
    }
}

