/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.space;

import e3d.visualization.space.BinarySpaceTasks;
import e3d.visualization.space.Coords;
import e3d.visualization.space.SubSpace;

public abstract class AtomicSubSpace<Atom extends AtomicSubSpace<Atom>>
extends SubSpace<Atom> {
    protected abstract Atom getThis();

    @Override
    protected void clear() {
        throw new UnsupportedOperationException("Could not clear an AtomicSpace!");
    }

    @Override
    protected boolean isEmpty() {
        return false;
    }

    @Override
    protected void perform(int i, int j, int k, int i0, int j0, int k0, int n, BinarySpaceTasks.IJKTask<Atom> task) {
        task.on(this.getThis(), i0, j0, k0, n);
    }

    @Override
    protected void perform(double x, double y, double z, int i0, int j0, int k0, int n, Coords coords, BinarySpaceTasks.XYZTask<Atom> task) {
        task.on(this.getThis(), i0, j0, k0, n);
    }

    @Override
    protected void perform(int i0, int j0, int k0, int n, BinarySpaceTasks.AllTask<Atom> task) {
        task.on(this.getThis(), i0, j0, k0, n);
    }

    @Override
    protected void perform(int i1, int j1, int k1, int i2, int j2, int k2, int i0, int j0, int k0, int n, BinarySpaceTasks.IJKAreaTask<Atom> task) {
        if (i1 <= 0 && i2 >= n - 1 && j1 <= 0 && j2 >= n - 1 && k1 <= 0 && k2 >= n - 1) {
            task.on(this.getThis(), i0, j0, k0, n);
        }
    }

    @Override
    protected void perform(double x, double y, double z, double dx, double dy, double dz, int i0, int j0, int k0, int n, Coords coords, BinarySpaceTasks.XYZAreaTask<Atom> task) {
        if (x - dx <= coords.x1(i0) && x + dx >= coords.x2(i0) && y - dy <= coords.y1(j0) && y + dy >= coords.y2(j0) && z - dz <= coords.z1(k0) && z + dz >= coords.z2(k0)) {
            task.on(this.getThis(), i0, j0, k0, n);
        }
    }

    @Override
    protected void perform(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax, double t, int i0, int j0, int k0, int n, Coords coords, BinarySpaceTasks.XYZRayTask<Atom> task) {
        if (t >= tmin) {
            task.on(this.getThis(), t, x, y, z, i0, j0, k0, n);
        }
    }
}

