/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.scanner;

import e3d.euclidean.E3DVector;
import e3d.utils.MathUtils;
import e3d.utils.ProgressListener;
import e3d.utils.SingularValueDecomposition;
import e3d.utils.TaskUtils;
import e3d.visualization.object.E3DObject;
import e3d.visualization.scanner.E3DObjectScan;
import e3d.visualization.scanner.Statistics;
import e3d.visualization.space.BinarySpace;
import e3d.visualization.space.BinarySpaceTasks;
import e3d.visualization.space.Coords;
import e3d.visualization.util.E3DAtom;
import e3d.visualization.util.E3DBoundingBox;
import java.util.concurrent.CopyOnWriteArrayList;

public class E3DPhysicalObjectScan
extends BinarySpace<E3DAtom>
implements E3DObjectScan {
    private static final int SCAN_TILE_SIZE = 512;
    private E3DObject object;
    private int slices;
    private int subDivisions;
    private Statistics statistics = new Statistics();
    protected final CopyOnWriteArrayList<ProgressListener> progressListeners = new CopyOnWriteArrayList();

    public E3DPhysicalObjectScan(E3DBoundingBox bounds, int width, int height, int depth, int slices, int subDivisions) {
        super(bounds, width, height, depth);
        this.slices = slices;
        this.subDivisions = subDivisions;
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public int getSlices() {
        return this.slices;
    }

    public void setSlices(int slices) {
        this.slices = slices;
    }

    public int getSubDivisions() {
        return this.subDivisions;
    }

    public void setSubDivisions(int subDivisions) {
        this.subDivisions = subDivisions;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public E3DObject getObject() {
        return this.object;
    }

    @Override
    public void setObject(E3DObject object) throws InterruptedException {
        int d;
        View view;
        int w;
        this.clear();
        this.object = object;
        this.statistics.scanningClock.start();
        int size = MathUtils.maxInt(this.width, this.height, this.depth);
        int delta = Math.max(4, 1 << (int)(Math.log((double)size / 20.0) / Math.log(2.0)));
        int[][][] k1 = new int[2][512][512];
        int[][][] k2 = new int[2][512][512];
        long done = 0L;
        long steps1 = (long)this.width * (long)this.height * (long)this.slices;
        long steps2 = (long)this.depth * (long)this.height * (long)this.slices;
        long steps3 = (long)this.width * (long)this.depth * (long)this.slices;
        long steps4 = (long)this.width * (long)this.height * (long)this.slices * 5L * (long)this.subDivisions / 4L;
        for (ProgressListener listener : this.progressListeners) {
            listener.init((int)((steps1 + steps2 + steps3 + steps4) / 100000L), "SCANNING OBJECT");
        }
        int i0 = 0;
        while (i0 < this.width) {
            int j0 = 0;
            while (j0 < this.height) {
                w = Math.min(i0 + 512, this.width) - i0;
                int h = Math.min(j0 + 512, this.height) - j0;
                view = new ZView(i0, j0, w, h, this.depth, k1, k2);
                this.scanTile(view, delta, this.slices, done);
                done += (long)w * (long)h * (long)this.slices;
                j0 += 512;
            }
            i0 += 512;
        }
        int j0 = 0;
        while (j0 < this.height) {
            int k0 = 0;
            while (k0 < this.depth) {
                int h = Math.min(j0 + 512, this.height) - j0;
                d = Math.min(k0 + 512, this.depth) - k0;
                view = new XView(j0, k0, this.width, h, d, k1, k2);
                this.scanTile(view, delta, this.slices, done);
                done += (long)h * (long)d * (long)this.slices;
                k0 += 512;
            }
            j0 += 512;
        }
        i0 = 0;
        while (i0 < this.width) {
            int k0 = 0;
            while (k0 < this.depth) {
                w = Math.min(i0 + 512, this.width) - i0;
                d = Math.min(k0 + 512, this.depth) - k0;
                view = new YView(i0, k0, w, this.height, d, k1, k2);
                this.scanTile(view, delta, this.slices, done);
                done += (long)w * (long)d * (long)this.slices;
                k0 += 512;
            }
            i0 += 512;
        }
        if (this.subDivisions > 0) {
            this.setNormals(this.width, this.height, this.depth, this.subDivisions, steps4, done);
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
        this.statistics.scanningClock.stop();
    }

    private void done(String task, long done) {
        for (ProgressListener listener : this.progressListeners) {
            listener.done((int)(done / 100000L), String.format("%s (time: %s / %5.1f million points)", task, this.statistics.getScanningTime(), (double)this.statistics.calculatedPoints / 1000000.0));
        }
    }

    private void scanTile(View view, int delta, int slices, long done) throws InterruptedException {
        int level = 0;
        int points = 1;
        while (level < slices && points > 0) {
            int p = level % 2 == 0 ? 0 : 1;
            int q = level % 2 == 0 ? 1 : 0;
            points = level == 0 ? this.scanInitial(view, p, q, 0, 0, delta, delta) : this.scanNext(view, p, q, 0, 0, delta, delta);
            int d = delta;
            while (d > 1) {
                if (TaskUtils.isInterrupted()) {
                    throw new InterruptedException();
                }
                this.done("SCANNING " + view.getDirection(), done + (long)(view.width / d * (view.height / d)));
                points += this.scanDiagonal(view, p, q, d / 2, d / 2, d, d, d, d / 2, d / 2);
                points += this.scanStraight(view, p, q, 0, d / 2, d, d, d, d / 2, d / 2);
                points += this.scanStraight(view, p, q, d / 2, 0, d, d, d, d / 2, d / 2);
                d /= 2;
            }
            this.done("SCANNING " + view.getDirection(), done += (long)view.width * (long)view.height);
            ++level;
        }
    }

    private int scanInitial(View tile, int p, int q, int i0, int j0, int di, int dj) {
        int points = 0;
        int i = i0;
        while (i < tile.width) {
            int j = j0;
            while (j < tile.height) {
                points += this.narrow(tile, p, q, i, j, 0, tile.depth - 1);
                j += dj;
            }
            i += di;
        }
        return points;
    }

    private int scanNext(View tile, int p, int q, int i0, int j0, int di, int dj) {
        int points = 0;
        int i = i0;
        while (i < tile.width) {
            int j = j0;
            while (j < tile.height) {
                points += this.narrow(tile, p, q, i, j, tile.k1[q][i][j] + 1, tile.k2[q][i][j] - 1);
                j += dj;
            }
            i += di;
        }
        return points;
    }

    private int scanDiagonal(View tile, int p, int q, int i0, int j0, int di, int dj, int dk, int gi, int gj) {
        int points = 0;
        int[] k12 = new int[2];
        int i = i0;
        while (i < tile.width) {
            int j = j0;
            while (j < tile.height) {
                this.getIntervalDiagonal(tile, p, q, i, j, gi, gj, k12);
                points += this.narrow(tile, p, q, i, j, Math.max(tile.k1[q][i][j] + 1, k12[0] - dk), Math.min(tile.k2[q][i][j] - 1, k12[1] + dk));
                j += dj;
            }
            i += di;
        }
        return points;
    }

    private int scanStraight(View tile, int p, int q, int i0, int j0, int di, int dj, int dk, int gi, int gj) {
        int points = 0;
        int[] k12 = new int[2];
        int i = i0;
        while (i < tile.width) {
            int j = j0;
            while (j < tile.height) {
                this.getIntervalStraight(tile, p, q, i, j, gi, gj, k12);
                points += this.narrow(tile, p, q, i, j, Math.max(tile.k1[q][i][j] + 1, k12[0] - dk), Math.min(tile.k2[q][i][j] - 1, k12[1] + dk));
                j += dj;
            }
            i += di;
        }
        return points;
    }

    private void getIntervalDiagonal(View tile, int p, int q, int i, int j, int gi, int gj, int[] k12) {
        int i1 = Math.max(i, gi);
        int i2 = Math.min(i, tile.width - gi - 1);
        int j1 = Math.max(j, gj);
        int j2 = Math.min(j, tile.height - gj - 1);
        k12[0] = MathUtils.minInt(tile.k1[p][i1 - gi][j1 - gj], tile.k1[p][i1 - gi][j2 + gj], tile.k1[p][i2 + gi][j1 - gj], tile.k1[p][i2 + gi][j2 + gj]);
        k12[1] = MathUtils.maxInt(tile.k2[p][i1 - gi][j1 - gj], tile.k2[p][i1 - gi][j2 + gj], tile.k2[p][i2 + gi][j1 - gj], tile.k2[p][i2 + gi][j2 + gj]);
        k12[0] = Math.max(k12[0], tile.k1[q][i][j] + 1);
        k12[1] = Math.min(k12[1], tile.k2[q][i][j] - 1);
    }

    private void getIntervalStraight(View tile, int p, int q, int i, int j, int gi, int gj, int[] k12) {
        int i1 = Math.max(i, gi);
        int i2 = Math.min(i, tile.width - gi - 1);
        int j1 = Math.max(j, gj);
        int j2 = Math.min(j, tile.height - gj - 1);
        k12[0] = MathUtils.minInt(tile.k1[p][i1 - gi][j], tile.k1[p][i2 + gi][j], tile.k1[p][i][j1 - gj], tile.k1[p][i][j2 + gj]);
        k12[1] = MathUtils.maxInt(tile.k2[p][i1 - gi][j], tile.k2[p][i2 + gi][j], tile.k2[p][i][j1 - gj], tile.k2[p][i][j2 + gj]);
        k12[0] = Math.max(k12[0], tile.k1[q][i][j] + 1);
        k12[1] = Math.min(k12[1], tile.k2[q][i][j] - 1);
    }

    private int narrow(View view, int p, int q, int i, int j, int k1, int k2) {
        if (view.k1[q][i][j] >= view.k2[q][i][j]) {
            return 0;
        }
        Integer color1 = null;
        E3DAtom atom1 = null;
        int k = k1;
        while (k <= k2) {
            E3DAtom atom = view.getElement(i, j, k);
            Integer color = view.getColor(i, j, k, atom);
            if (color != null) {
                atom1 = atom;
                color1 = color;
                k1 = k;
            }
            if (color1 != null && color == null == (p == 1)) break;
            ++k;
        }
        Integer color2 = null;
        E3DAtom atom2 = null;
        int k3 = k2;
        while (k3 >= k1) {
            E3DAtom atom = view.getElement(i, j, k3);
            Integer color = view.getColor(i, j, k3, atom);
            if (color != null) {
                atom2 = atom;
                color2 = color;
                k2 = k3;
            }
            if (color2 != null && color == null == (p == 1)) break;
            --k3;
        }
        if (color1 != null && color2 != null && k1 < k2) {
            if (atom1 != null) {
                view.addNormal(atom1, 0.0, 0.0, p == 0 ? -1 : 1);
            } else {
                view.setElement(i, j, k1, color1, 0.0, 0.0, p == 0 ? -1 : 1);
            }
            if (atom2 != null) {
                view.addNormal(atom2, 0.0, 0.0, p == 0 ? 1 : -1);
            } else {
                view.setElement(i, j, k2, color2, 0.0, 0.0, p == 0 ? 1 : -1);
            }
            view.k1[p][i][j] = k1;
            view.k2[p][i][j] = k2;
            return 2;
        }
        view.k1[p][i][j] = view.depth;
        view.k2[p][i][j] = -1;
        return 0;
    }

    private void setNormals(int width, int height, int depth, int subDivisions, long size, long done) throws InterruptedException {
        NormalSetter normalSetter = new NormalSetter(size, done);
        E3DVector voxelSize = this.getElementSize();
        normalSetter.latOffset = voxelSize.min() * 0.25;
        normalSetter.outOffset = voxelSize.max() * Math.sqrt(3.0) + normalSetter.latOffset;
        normalSetter.inOffset = normalSetter.latOffset;
        try {
            this.perform(normalSetter);
        }
        catch (MyInterruptedException exception) {
            throw new InterruptedException();
        }
    }

    private void getNormal(int subDivisions, SingularValueDecomposition svd, double latOffset, double outOffset, double inOffset, double x, double y, double z, E3DVector n, E3DVector r, E3DVector o1, E3DVector o2, double[][] xyz) {
        o1.orthogonalXY(n);
        o2.cross(n, o1);
        o1.norm(latOffset);
        o2.norm(latOffset);
        n.norm(outOffset);
        r.set(n, inOffset);
        this.subDivide(x + o1.x - r.x, y + o1.y - r.y, z + o1.z - r.z, x + o1.x + n.x, y + o1.y + n.y, z + o1.z + n.z, this.object, subDivisions, xyz[0]);
        this.subDivide(x - o1.x - r.x, y - o1.y - r.y, z - o1.z - r.z, x - o1.x + n.x, y - o1.y + n.y, z - o1.z + n.z, this.object, subDivisions, xyz[1]);
        this.subDivide(x + o2.x - r.x, y + o2.y - r.y, z + o2.z - r.z, x + o2.x + n.x, y + o2.y + n.y, z + o2.z + n.z, this.object, subDivisions, xyz[2]);
        this.subDivide(x - o2.x - r.x, y - o2.y - r.y, z - o2.z - r.z, x - o2.x + n.x, y - o2.y + n.y, z - o2.z + n.z, this.object, subDivisions, xyz[3]);
        this.getNormal(svd, xyz, n);
    }

    private void subDivide(double xS, double yS, double zS, double xE, double yE, double zE, E3DObject object, int subDiv, double[] xyz) {
        double xM = (xS + xE) / 2.0;
        double yM = (yS + yE) / 2.0;
        double zM = (zS + zE) / 2.0;
        if (subDiv <= 0) {
            xyz[0] = xM;
            xyz[1] = yM;
            xyz[2] = zM;
        } else {
            object.setPoint(xM, yM, zM);
            if (object.getColor() == null) {
                this.subDivide(xS, yS, zS, xM, yM, zM, object, subDiv - 1, xyz);
            } else {
                this.subDivide(xM, yM, zM, xE, yE, zE, object, subDiv - 1, xyz);
            }
        }
    }

    private void getNormal(SingularValueDecomposition svd, double[][] points, E3DVector normal) {
        double xm = 0.0;
        double ym = 0.0;
        double zm = 0.0;
        double[][] dArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            double[] xyz = dArray[n2];
            xm += xyz[0];
            ym += xyz[1];
            zm += xyz[2];
            ++n2;
        }
        double n3 = points.length;
        xm /= n3;
        ym /= n3;
        zm /= n3;
        double[][] dArray2 = points;
        int n4 = points.length;
        int n5 = 0;
        while (n5 < n4) {
            double[] xyz = dArray2[n5];
            xyz[0] = xyz[0] - xm;
            xyz[1] = xyz[1] - ym;
            xyz[2] = xyz[2] - zm;
            ++n5;
        }
        svd.decompose(points, false, true);
        double[][] v = svd.getV();
        normal.set(v[0][2], v[1][2], v[2][2]);
    }

    private static class MyInterruptedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private MyInterruptedException() {
        }
    }

    private class NormalSetter
    extends BinarySpaceTasks.AllTask<E3DAtom> {
        private double latOffset;
        private double outOffset;
        private double inOffset;
        private final long size;
        private final long done;
        private long count = 0L;
        private final SingularValueDecomposition svd = new SingularValueDecomposition(4, 3);
        private final double[][] xyz = new double[4][3];
        private final E3DVector reversed = new E3DVector();
        private final E3DVector ortho1 = new E3DVector();
        private final E3DVector ortho2 = new E3DVector();

        private NormalSetter(long size, long done) {
            this.size = size;
            this.done = done;
        }

        @Override
        public void on(E3DAtom atom, int i, int j, int k, int n) throws MyInterruptedException {
            double x = E3DPhysicalObjectScan.this.coords.x(i);
            double y = E3DPhysicalObjectScan.this.coords.y(j);
            double z = E3DPhysicalObjectScan.this.coords.z(k);
            E3DVector normal = atom.getNormal();
            E3DPhysicalObjectScan.this.getNormal(E3DPhysicalObjectScan.this.subDivisions, this.svd, this.latOffset, this.outOffset, this.inOffset, x, y, z, normal, this.reversed, this.ortho1, this.ortho2, this.xyz);
            ((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.calculatedPoints += (long)(5 * E3DPhysicalObjectScan.this.subDivisions);
            if (TaskUtils.isInterrupted()) {
                throw new MyInterruptedException();
            }
            E3DPhysicalObjectScan.this.done("SET NORMALS", this.done + this.size * ++this.count / ((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.surfacePoints);
        }
    }

    private abstract class View {
        protected int width;
        protected int height;
        protected int depth;
        protected final int[][][] k1;
        protected final int[][][] k2;

        public View(int width, int height, int depth, int[][][] k1, int[][][] k2) {
            this.width = width;
            this.height = height;
            this.depth = depth;
            this.k1 = k1;
            this.k2 = k2;
            this.init();
        }

        private void init() {
            int i = 0;
            while (i < this.width) {
                int j = 0;
                while (j < this.height) {
                    this.k1[1][i][j] = -1;
                    this.k2[1][i][j] = this.depth;
                    ++j;
                }
                ++i;
            }
        }

        protected abstract E3DAtom getElement(int var1, int var2, int var3);

        protected abstract void addNormal(E3DAtom var1, double var2, double var4, double var6);

        protected abstract void setElement(int var1, int var2, int var3, Integer var4, double var5, double var7, double var9);

        protected abstract Integer getColor(int var1, int var2, int var3, E3DAtom var4);

        protected abstract String getDirection();
    }

    private final class XView
    extends View {
        private final int j0;
        private final int k0;

        public XView(int j0, int k0, int width, int height, int depth, int[][][] k1, int[][][] k2) {
            super(depth, height, width, k1, k2);
            this.j0 = j0;
            this.k0 = k0;
        }

        @Override
        protected E3DAtom getElement(int i, int j, int k) {
            return (E3DAtom)E3DPhysicalObjectScan.this.getAtom(k, this.j0 + j, this.k0 + i);
        }

        @Override
        protected void addNormal(E3DAtom atom, double nx, double ny, double nz) {
            atom.getNormal().add(nz, ny, nx);
        }

        @Override
        protected void setElement(int i, int j, int k, Integer color, double nx, double ny, double nz) {
            E3DVector normal = new E3DVector(nz, ny, nx);
            E3DAtom data = new E3DAtom(color, normal);
            E3DPhysicalObjectScan.this.setAtom(data, k, this.j0 + j, this.k0 + i);
            ++((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.surfacePoints;
        }

        @Override
        protected Integer getColor(int i, int j, int k, E3DAtom atom) {
            if (atom != null) {
                return atom.getColor();
            }
            Coords coords = E3DPhysicalObjectScan.this.getCoords();
            E3DPhysicalObjectScan.this.object.setPoint(coords.x(k), coords.y(this.j0 + j), coords.z(this.k0 + i));
            Integer color = E3DPhysicalObjectScan.this.object.getColor();
            if (color != null) {
                ++((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.solidPoints;
            }
            ++((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.calculatedPoints;
            return color;
        }

        @Override
        protected String getDirection() {
            return "X";
        }
    }

    private final class YView
    extends View {
        private final int i0;
        private final int k0;

        public YView(int i0, int k0, int width, int height, int depth, int[][][] k1, int[][][] k2) {
            super(width, depth, height, k1, k2);
            this.i0 = i0;
            this.k0 = k0;
        }

        @Override
        protected E3DAtom getElement(int i, int j, int k) {
            return (E3DAtom)E3DPhysicalObjectScan.this.getAtom(this.i0 + i, k, this.k0 + j);
        }

        @Override
        protected void addNormal(E3DAtom atom, double nx, double ny, double nz) {
            atom.getNormal().add(nx, nz, ny);
        }

        @Override
        protected void setElement(int i, int j, int k, Integer color, double nx, double ny, double nz) {
            E3DVector normal = new E3DVector(nx, nz, ny);
            E3DAtom data = new E3DAtom(color, normal);
            E3DPhysicalObjectScan.this.setAtom(data, this.i0 + i, k, this.k0 + j);
            ++((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.surfacePoints;
        }

        @Override
        protected Integer getColor(int i, int j, int k, E3DAtom atom) {
            if (atom != null) {
                return atom.getColor();
            }
            Coords coords = E3DPhysicalObjectScan.this.getCoords();
            E3DPhysicalObjectScan.this.object.setPoint(coords.x(this.i0 + i), coords.y(k), coords.z(this.k0 + j));
            Integer color = E3DPhysicalObjectScan.this.object.getColor();
            if (color != null) {
                ++((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.solidPoints;
            }
            ++((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.calculatedPoints;
            return color;
        }

        @Override
        protected String getDirection() {
            return "Y";
        }
    }

    private final class ZView
    extends View {
        private final int i0;
        private final int j0;

        public ZView(int i0, int j0, int width, int height, int depth, int[][][] k1, int[][][] k2) {
            super(width, height, depth, k1, k2);
            this.i0 = i0;
            this.j0 = j0;
        }

        @Override
        protected E3DAtom getElement(int i, int j, int k) {
            return null;
        }

        @Override
        protected void addNormal(E3DAtom atom, double nx, double ny, double nz) {
        }

        @Override
        protected void setElement(int i, int j, int k, Integer color, double nx, double ny, double nz) {
            E3DVector normal = new E3DVector(nx, ny, nz);
            E3DAtom data = new E3DAtom(color, normal);
            E3DPhysicalObjectScan.this.setAtom(data, this.i0 + i, this.j0 + j, k);
            ++((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.surfacePoints;
        }

        @Override
        protected Integer getColor(int i, int j, int k, E3DAtom atom) {
            if (atom != null) {
                return atom.getColor();
            }
            Coords coords = E3DPhysicalObjectScan.this.getCoords();
            E3DPhysicalObjectScan.this.object.setPoint(coords.x(this.i0 + i), coords.y(this.j0 + j), coords.z(k));
            Integer color = E3DPhysicalObjectScan.this.object.getColor();
            if (color != null) {
                ++((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.solidPoints;
            }
            ++((E3DPhysicalObjectScan)E3DPhysicalObjectScan.this).statistics.calculatedPoints;
            return color;
        }

        @Override
        protected String getDirection() {
            return "Z";
        }
    }
}

