/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.renderer;

import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DVector;
import e3d.visualization.image.E3DImage;
import e3d.visualization.renderer.E3DRayTracer;
import e3d.visualization.space.Point;
import e3d.visualization.space.Scan;
import e3d.visualization.util.E3DAtom;
import e3d.visualization.util.E3DLight;
import e3d.visualization.util.E3DMaterial;
import e3d.visualization.util.E3DScene;
import java.util.List;

public class E3DJustShadowingRayTracer
extends E3DRayTracer {
    public E3DJustShadowingRayTracer() {
    }

    public E3DJustShadowingRayTracer(double offsetFactor, E3DMaterial defaultMaterial, E3DImage.Type imageType) {
        super(0, offsetFactor, defaultMaterial, imageType);
    }

    public E3DRayTracer.RayColor trace(E3DLine ray, Point<E3DAtom> hit, E3DScene scene, double offset) {
        return this.trace(ray, hit, scene.getScan(), scene.getEnvironment(), scene.getLights(), offset, this.maxDepth);
    }

    @Override
    protected E3DRayTracer.RayColor traceLights(Point<E3DAtom> point, E3DVector normal, double offset, E3DLine reflected, E3DMaterial material, List<E3DLight> lights, Scan<E3DAtom> scan) {
        int color = point.getAtom().getColor();
        E3DRayTracer.RayColor voxelColor = new E3DRayTracer.RayColor(color);
        E3DRayTracer.RayColor cumulatedColor = new E3DRayTracer.RayColor(0.0, 0.0, 0.0, voxelColor.alpha);
        for (E3DLight light : lights) {
            E3DVector lightPos = light.getPosition();
            E3DVector lightDir = point.diff(lightPos);
            E3DLine lightRay = new E3DLine(lightPos, lightDir);
            E3DAtom shadower = scan.getNextAtomInRay(lightRay.a.x, lightRay.a.y, lightRay.a.z, lightRay.b.x, lightRay.b.y, lightRay.b.z, 0.0, 1.0 - offset / lightRay.b.length());
            E3DRayTracer.RayColor lightColor = new E3DRayTracer.RayColor(light.getColor());
            double factor = shadower == null ? light.getLuminocity(point) : 0.0;
            cumulatedColor.red += voxelColor.red * lightColor.red * factor;
            cumulatedColor.green += voxelColor.green * lightColor.green * factor;
            cumulatedColor.blue += voxelColor.blue * lightColor.blue * factor;
        }
        double n = lights.size();
        cumulatedColor.red /= n;
        cumulatedColor.green /= n;
        cumulatedColor.blue /= n;
        return cumulatedColor;
    }
}

