/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.object;

import e3d.euclidean.E3DVector;
import e3d.utils.MathUtils;
import e3d.visualization.object.E3DSubject;
import e3d.visualization.util.E3DBoundingBox;

public class E3DCubicSubject
implements E3DSubject {
    private final int color;
    private final E3DVector normal = new E3DVector();
    private final E3DVector leftUpperFront = new E3DVector();
    private final E3DVector rightLowerBack = new E3DVector();
    private final E3DVector point = new E3DVector();
    private double dx1;
    private double dx2;
    private double dy1;
    private double dy2;
    private double dz1;
    private double dz2;

    public E3DCubicSubject(double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        this.leftUpperFront.set(x1, y1, z1);
        this.rightLowerBack.set(x2, y2, z2);
        this.color = color;
    }

    public E3DCubicSubject(E3DBoundingBox bounds, int color) {
        this.leftUpperFront.set(bounds.x0, bounds.y0, bounds.z0);
        this.rightLowerBack.set(bounds.x1, bounds.y1, bounds.z1);
        this.color = color;
    }

    @Override
    public void setPoint(double x, double y, double z) {
        this.point.set(x, y, z);
    }

    @Override
    public Integer getColor() {
        this.dx1 = this.point.x - this.leftUpperFront.x;
        this.dx2 = this.point.x - this.rightLowerBack.x;
        this.dy1 = this.point.y - this.leftUpperFront.y;
        this.dy2 = this.point.y - this.rightLowerBack.y;
        this.dz1 = this.point.z - this.leftUpperFront.z;
        this.dz2 = this.point.z - this.rightLowerBack.z;
        if (this.dx1 >= 0.0 && this.dy1 >= 0.0 && this.dz1 >= 0.0 && this.dx2 <= 0.0 && this.dy2 <= 0.0 && this.dz2 <= 0.0) {
            return this.color;
        }
        return null;
    }

    @Override
    public double getDistance() {
        if (this.dx1 < 0.0) {
            if (this.dy1 < 0.0) {
                if (this.dz1 < 0.0) {
                    return Math.sqrt(this.dx1 * this.dx1 + this.dy1 * this.dy1 + this.dz1 * this.dz1);
                }
                if (this.dz2 > 0.0) {
                    return Math.sqrt(this.dx1 * this.dx1 + this.dy1 * this.dy1 + this.dz2 * this.dz2);
                }
                return Math.sqrt(this.dx1 * this.dx1 + this.dy1 * this.dy1);
            }
            if (this.dz2 > 0.0) {
                if (this.dz1 < 0.0) {
                    return Math.sqrt(this.dx1 * this.dx1 + this.dy2 * this.dy2 + this.dz1 * this.dz1);
                }
                if (this.dz2 > 0.0) {
                    return Math.sqrt(this.dx1 * this.dx1 + this.dy2 * this.dy2 + this.dz2 * this.dz2);
                }
                return Math.sqrt(this.dx1 * this.dx1 + this.dy2 * this.dy2);
            }
            if (this.dz1 < 0.0) {
                return Math.sqrt(this.dx1 * this.dx1 + this.dz1 * this.dz1);
            }
            if (this.dz2 > 0.0) {
                return Math.sqrt(this.dx1 * this.dx1 + this.dz2 * this.dz2);
            }
            return Math.abs(this.dx1);
        }
        if (this.dx2 > 0.0) {
            if (this.dy1 < 0.0) {
                if (this.dz1 < 0.0) {
                    return Math.sqrt(this.dx2 * this.dx2 + this.dy1 * this.dy1 + this.dz1 * this.dz1);
                }
                if (this.dz2 > 0.0) {
                    return Math.sqrt(this.dx2 * this.dx2 + this.dy1 * this.dy1 + this.dz2 * this.dz2);
                }
                return Math.sqrt(this.dx2 * this.dx2 + this.dy1 * this.dy1);
            }
            if (this.dz2 > 0.0) {
                if (this.dz1 < 0.0) {
                    return Math.sqrt(this.dx2 * this.dx2 + this.dy2 * this.dy2 + this.dz1 * this.dz1);
                }
                if (this.dz2 > 0.0) {
                    return Math.sqrt(this.dx2 * this.dx2 + this.dy2 * this.dy2 + this.dz2 * this.dz2);
                }
                return Math.sqrt(this.dx2 * this.dx2 + this.dy2 * this.dy2);
            }
            if (this.dz1 < 0.0) {
                return Math.sqrt(this.dx2 * this.dx2 + this.dz1 * this.dz1);
            }
            if (this.dz2 > 0.0) {
                return Math.sqrt(this.dx2 * this.dx2 + this.dz2 * this.dz2);
            }
            return Math.abs(this.dx2);
        }
        if (this.dy1 < 0.0) {
            if (this.dz1 < 0.0) {
                return Math.sqrt(this.dy1 * this.dy1 + this.dz1 * this.dz1);
            }
            if (this.dz2 > 0.0) {
                return Math.sqrt(this.dy1 * this.dy1 + this.dz2 * this.dz2);
            }
            return Math.abs(this.dy1);
        }
        if (this.dz2 > 0.0) {
            if (this.dz1 < 0.0) {
                return Math.sqrt(this.dy2 * this.dy2 + this.dz1 * this.dz1);
            }
            if (this.dz2 > 0.0) {
                return Math.sqrt(this.dy2 * this.dy2 + this.dz2 * this.dz2);
            }
            return Math.abs(this.dy2);
        }
        if (this.dz1 < 0.0) {
            return Math.abs(this.dz1);
        }
        if (this.dz2 > 0.0) {
            return Math.abs(this.dz2);
        }
        return -Math.min(Math.min(this.dx1, -this.dx2), Math.min(Math.min(this.dy1, -this.dy2), Math.min(this.dz1, -this.dz2)));
    }

    @Override
    public E3DVector getNormal() {
        double[] vals = new double[]{this.dx1, this.dx2, this.dy1, this.dy2, this.dz1, this.dz2};
        double min = vals[MathUtils.minAbsIndex(vals)];
        this.normal.set(this.dx1 == min ? -1 : (this.dx2 == min ? 1 : 0), this.dy1 == min ? -1 : (this.dy2 == min ? 1 : 0), this.dz1 == min ? -1 : (this.dz2 == min ? 1 : 0));
        return this.normal;
    }
}

