/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.mesh;

import e3d.euclidean.E3DVector;
import e3d.utils.ArrayFactory;
import e3d.utils.ObjectFactory;
import e3d.visualization.image.E3DImage;
import e3d.visualization.mesh.E3DMeshPoint;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DMaterial;
import e3d.visualization.util.Matrix2D;
import java.awt.Color;

public class E3DMesh
extends Matrix2D<E3DMeshPoint>
implements Cloneable {
    public static final E3DColor DEFAULT_COLOR = new E3DColor(255, 255, 255, 255);

    public E3DMesh() {
        super(ArrayFactory.MESHPOINT, null);
    }

    public E3DMesh(int width, int height) {
        super(width, height, ArrayFactory.MESHPOINT, ObjectFactory.MESHPOINT);
    }

    public E3DMesh(E3DMesh mesh) {
        super(mesh);
    }

    @Override
    public E3DMesh clone() {
        return new E3DMesh(this);
    }

    public void scale(double factor) {
        int i = 0;
        while (i < this.width * this.height) {
            ((E3DMeshPoint[])this.values)[i].multiplicate(factor);
            ++i;
        }
    }

    public void warp(E3DVector vector) {
        int i = 0;
        while (i < this.width * this.height) {
            ((E3DMeshPoint[])this.values)[i].multiplicate(vector);
            ++i;
        }
    }

    public E3DBoundingBox enclose() {
        if (this.width * this.height > 0) {
            E3DBoundingBox box = new E3DBoundingBox();
            box.x0 = box.x1 = ((E3DMeshPoint[])this.values)[0].x;
            box.y0 = box.y1 = ((E3DMeshPoint[])this.values)[0].y;
            box.z0 = box.z1 = ((E3DMeshPoint[])this.values)[0].z;
            int i = 1;
            while (i < this.width * this.height) {
                box.x0 = Math.min(box.x0, ((E3DMeshPoint[])this.values)[i].x);
                box.x1 = Math.max(box.x1, ((E3DMeshPoint[])this.values)[i].x);
                box.y0 = Math.min(box.y0, ((E3DMeshPoint[])this.values)[i].y);
                box.y1 = Math.max(box.y1, ((E3DMeshPoint[])this.values)[i].y);
                box.z0 = Math.min(box.z0, ((E3DMeshPoint[])this.values)[i].z);
                box.z1 = Math.max(box.z1, ((E3DMeshPoint[])this.values)[i].z);
                ++i;
            }
            return box;
        }
        return null;
    }

    public void setAll(Color color) {
        int rgb = color.getRGB();
        int y = 0;
        while (y < this.height()) {
            int x = 0;
            while (x < this.width()) {
                E3DMeshPoint point = (E3DMeshPoint)this.get(x, y);
                if (point != null) {
                    point.setColor(rgb);
                }
                ++x;
            }
            ++y;
        }
    }

    public void setAll(E3DMaterial material) {
        int y = 0;
        while (y < this.height()) {
            int x = 0;
            while (x < this.width()) {
                E3DMeshPoint point = (E3DMeshPoint)this.get(x, y);
                if (point != null) {
                    point.setMaterial(material);
                }
                ++x;
            }
            ++y;
        }
    }

    public void colorize(E3DImage texture) {
        this.colorize(texture, 0.0, 0.0, 1.0, 1.0);
    }

    public void colorize(E3DImage texture, double x0, double y0, double w, double h) {
        if (texture == null) {
            this.setAll(DEFAULT_COLOR);
        } else {
            int c = 0;
            while (c < this.width) {
                int r = 0;
                while (r < this.height) {
                    int x = (int)((x0 + (double)c / (double)this.width * w) * (double)texture.getWidth());
                    int y = (int)((y0 + (double)r / (double)this.height * h) * (double)texture.getHeight());
                    if (x >= 0 && x < texture.getWidth() && y >= 0 && y < texture.getHeight()) {
                        ((E3DMeshPoint)this.get(c, r)).setColor(texture.getRGB(x, y));
                    }
                    ++r;
                }
                ++c;
            }
        }
    }

    public void createNormals() {
        int x;
        int y = 1;
        while (y < this.height - 1) {
            x = 1;
            while (x < this.width - 1) {
                E3DVector a = (E3DVector)this.get(x - 1, y - 1);
                E3DVector b = (E3DVector)this.get(x + 1, y - 1);
                E3DVector c = (E3DVector)this.get(x + 1, y + 1);
                E3DMeshPoint p = (E3DMeshPoint)this.get(x, y);
                p.setNormal(a.diff(b).crossProduct(a.diff(c)));
                ++x;
            }
            ++y;
        }
        if (this.height <= 2) {
            y = 0;
            x = 1;
            while (x < this.width - 1) {
                ((E3DMeshPoint)this.get(x, y)).setNormal(new E3DVector());
                ++x;
            }
            y = this.height - 1;
            x = 1;
            while (x < this.width - 1) {
                ((E3DMeshPoint)this.get(x, y)).setNormal(new E3DVector());
                ++x;
            }
        } else {
            y = 0;
            x = 1;
            while (x < this.width - 1) {
                ((E3DMeshPoint)this.get(x, y)).setNormal(((E3DMeshPoint)this.get(x, y + 1)).normal());
                ++x;
            }
            y = this.height - 1;
            x = 1;
            while (x < this.width - 1) {
                ((E3DMeshPoint)this.get(x, y)).setNormal(((E3DMeshPoint)this.get(x, y - 1)).normal());
                ++x;
            }
        }
        if (this.width <= 2) {
            y = 0;
            x = 0;
            while (y < this.height) {
                ((E3DMeshPoint)this.get(x, y)).setNormal(new E3DVector());
                ++y;
            }
            y = 0;
            x = this.width - 1;
            while (y < this.height) {
                ((E3DMeshPoint)this.get(x, y)).setNormal(new E3DVector());
                ++y;
            }
        } else {
            y = 0;
            x = 0;
            while (y < this.height) {
                ((E3DMeshPoint)this.get(x, y)).setNormal(((E3DMeshPoint)this.get(x + 1, y)).normal());
                ++y;
            }
            y = 0;
            x = this.width - 1;
            while (y < this.height) {
                ((E3DMeshPoint)this.get(x, y)).setNormal(((E3DMeshPoint)this.get(x - 1, y)).normal());
                ++y;
            }
        }
    }
}

