/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.image.filter;

import e3d.visualization.image.filter.E3DImageFilter;
import e3d.visualization.util.E3DColor;

public class HSBFilter
extends E3DImageFilter {
    final double hueOffset;
    final double saturationFactor;
    final double brightnessFactor;

    public HSBFilter(double hueOffset, double saturationFactor, double brightnessFactor) {
        this.hueOffset = hueOffset;
        this.saturationFactor = saturationFactor;
        this.brightnessFactor = brightnessFactor;
    }

    @Override
    public int filter(int color) {
        return E3DColor.changeHSB(color, this.hueOffset, this.saturationFactor, this.brightnessFactor);
    }

    @Override
    public boolean isChanging() {
        return this.hueOffset != 0.0 || this.saturationFactor != 1.0 || this.brightnessFactor != 1.0;
    }

    @Override
    public String name() {
        return "CHANGING HUE, SATURATION & BRIGHTNESS";
    }
}

