/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.image.filter;

import e3d.euclidean.E3DVector;
import e3d.utils.ProgressListener;
import e3d.utils.TaskUtils;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.filter.E3DImageFilter;
import e3d.visualization.util.E3DColor;

public class FocusDepthFilter
extends E3DImageFilter {
    private static final double ATANMAX = 4.0;
    private static final double ATANX = Math.atan(4.0);
    private static final int MAX_BLUR_RADIUS = 50;
    private static final double[][] WEIGHTS = new double[51][];
    private final double maxBlurRadius;
    private final double focalDistance;
    private final E3DVector viewPos;
    private final float[][][] xyzBuffer;
    private final double dMin;
    private final double dMax;

    static {
        int radius = 0;
        while (radius <= 50) {
            double var = Math.pow((double)radius / 3.0, 2.0);
            int maxSquareDist = 2 * (radius * radius);
            FocusDepthFilter.WEIGHTS[radius] = new double[maxSquareDist + 1];
            double factor = Math.sqrt(1.0 / (Math.PI * 2 * var));
            int squareDist = 0;
            while (squareDist <= maxSquareDist) {
                double gauss = 1.0 / (Math.PI * 2 * var) * Math.exp(-((double)squareDist / (2.0 * var)));
                FocusDepthFilter.WEIGHTS[radius][squareDist] = gauss * factor;
                ++squareDist;
            }
            ++radius;
        }
    }

    public FocusDepthFilter(double focalDistance, double maxBlurRadius, E3DVector viewPos, float[][][] xyzBuffer, double dMin, double dMax) {
        this.focalDistance = focalDistance;
        this.maxBlurRadius = maxBlurRadius;
        this.viewPos = viewPos;
        this.xyzBuffer = xyzBuffer;
        this.dMin = dMin;
        this.dMax = dMax;
    }

    public double getMaxBlurRadius() {
        return this.maxBlurRadius;
    }

    public double getFocalDistance() {
        return this.focalDistance;
    }

    @Override
    public void filter(E3DImage source, E3DImage target) throws InterruptedException {
        if (TaskUtils.isInterrupted()) {
            throw new InterruptedException();
        }
        if (source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight()) {
            throw new RuntimeException("Source and target image must have the same size!");
        }
        if (this.xyzBuffer == null || source.getWidth() != this.xyzBuffer.length || source.getHeight() != this.xyzBuffer[0].length) {
            throw new RuntimeException("A xyz-buffer of the same size as the given image has to be set");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.init(source.getHeight(), this.name());
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(0, "Start filtering");
        }
        double[][] reds = new double[source.getHeight()][source.getWidth()];
        double[][] greens = new double[source.getHeight()][source.getWidth()];
        double[][] blues = new double[source.getHeight()][source.getWidth()];
        double[][] alphas = new double[source.getHeight()][source.getWidth()];
        double[][] weights = new double[source.getHeight()][source.getWidth()];
        int y = 0;
        while (y < source.getHeight()) {
            int x = 0;
            while (x < source.getWidth()) {
                int color = source.getRGB(x, y);
                double alpha = E3DColor.alpha(color);
                double red = E3DColor.red(color);
                double green = E3DColor.green(color);
                double blue = E3DColor.blue(color);
                this.blur(red, green, blue, alpha, x, y, reds, greens, blues, alphas, weights);
                ++x;
            }
            if (TaskUtils.isInterrupted()) {
                throw new InterruptedException();
            }
            for (ProgressListener listener : this.progressListeners) {
                listener.done(y, "filtering");
            }
            ++y;
        }
        y = 0;
        while (y < target.getHeight()) {
            int x = 0;
            while (x < target.getWidth()) {
                int color = E3DColor.rgb((int)(reds[y][x] / weights[y][x]), (int)(greens[y][x] / weights[y][x]), (int)(blues[y][x] / weights[y][x]), (int)(alphas[y][x] / weights[y][x]));
                target.setRGB(x, y, color);
                ++x;
            }
            ++y;
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(listener.steps(), "Filtering complete");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
    }

    @Override
    public int filter(int color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isChanging() {
        return this.maxBlurRadius > 0.0;
    }

    private void blur(double red, double green, double blue, double alpha, int x, int y, double[][] reds, double[][] greens, double[][] blues, double[][] alphas, double[][] weights) {
        double radius = this.radius(x, y);
        int range = (int)radius;
        int dy = -range;
        while (dy <= range) {
            if (y + dy >= 0 && y + dy < reds.length) {
                int dx = -range;
                while (dx <= range) {
                    if (x + dx >= 0 && x + dx < reds[y + dy].length) {
                        double weight = WEIGHTS[range][dx * dx + dy * dy];
                        double[] dArray = reds[y + dy];
                        int n = x + dx;
                        dArray[n] = dArray[n] + red * weight;
                        double[] dArray2 = greens[y + dy];
                        int n2 = x + dx;
                        dArray2[n2] = dArray2[n2] + green * weight;
                        double[] dArray3 = blues[y + dy];
                        int n3 = x + dx;
                        dArray3[n3] = dArray3[n3] + blue * weight;
                        double[] dArray4 = alphas[y + dy];
                        int n4 = x + dx;
                        dArray4[n4] = dArray4[n4] + alpha * weight;
                        double[] dArray5 = weights[y + dy];
                        int n5 = x + dx;
                        dArray5[n5] = dArray5[n5] + weight;
                    }
                    ++dx;
                }
            }
            ++dy;
        }
    }

    private double radius(int x, int y) {
        if (Float.isInfinite(this.xyzBuffer[x][y][2])) {
            return Math.min(50.0, this.maxBlurRadius + 1.0);
        }
        double z = (this.viewPos.dist(this.xyzBuffer[x][y][0], this.xyzBuffer[x][y][1], this.xyzBuffer[x][y][2]) - this.dMin) / (this.dMax - this.dMin);
        double dist = Math.abs(z - this.focalDistance);
        return Math.min(50.0, Math.atan(dist * 4.0) / ATANX * this.maxBlurRadius + 1.0);
    }

    @Override
    public String name() {
        return "INTRODUCING DEPTH OF FOCUS";
    }
}

