/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.image.filter;

import e3d.euclidean.E3DVector;
import e3d.utils.ProgressListener;
import e3d.utils.TaskUtils;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.filter.E3DImageFilter;
import e3d.visualization.util.E3DColor;

public class ColorShiftFilter
extends E3DImageFilter {
    private final int blueShiftColor;
    private final double blueShift;
    private final double whiteShift;
    private final E3DVector viewPos;
    private final float[][][] xyzBuffer;
    private final double dMin;
    private final double dMax;

    public ColorShiftFilter(int blueShiftColor, double blueShift, double whiteShift, E3DVector viewPos, float[][][] xyzBuffer, double dMin, double dMax) {
        this.blueShiftColor = blueShiftColor;
        this.blueShift = blueShift;
        this.whiteShift = whiteShift;
        this.viewPos = viewPos;
        this.xyzBuffer = xyzBuffer;
        this.dMin = dMin;
        this.dMax = dMax;
    }

    @Override
    public void filter(E3DImage source, E3DImage target) throws InterruptedException {
        if (TaskUtils.isInterrupted()) {
            throw new InterruptedException();
        }
        if (source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight()) {
            throw new RuntimeException("Source and target image must have the same size!");
        }
        if (this.xyzBuffer == null || source.getWidth() != this.xyzBuffer.length || source.getHeight() != this.xyzBuffer[0].length) {
            throw new RuntimeException("A xyz-buffer of the same size as the given image has to be set");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.init(source.getHeight(), this.name());
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(0, "Start filtering");
        }
        int y = 0;
        while (y < source.getHeight()) {
            int x = 0;
            while (x < source.getWidth()) {
                double z = (this.viewPos.dist(this.xyzBuffer[x][y][0], this.xyzBuffer[x][y][1], this.xyzBuffer[x][y][2]) - this.dMin) / (this.dMax - this.dMin);
                int color = source.getRGB(x, y);
                double d = Math.max(0.0, Math.min(1.0, z));
                double w = this.whiteShift * d;
                double r = this.blueShift * d * (double)E3DColor.red(this.blueShiftColor) / 255.0;
                double g = this.blueShift * d * (double)E3DColor.green(this.blueShiftColor) / 255.0;
                double b = this.blueShift * d * (double)E3DColor.blue(this.blueShiftColor) / 255.0;
                int offset = (int)(w * 255.0);
                int shifted = E3DColor.rgb(Math.min(255, (int)((double)(E3DColor.red(color) + offset) * (1.0 + r))), Math.min(255, (int)((double)(E3DColor.green(color) + offset) * (1.0 + g))), Math.min(255, (int)((double)(E3DColor.blue(color) + offset) * (1.0 + b))), E3DColor.alpha(color));
                target.setRGB(x, y, shifted);
                ++x;
            }
            if (TaskUtils.isInterrupted()) {
                throw new InterruptedException();
            }
            for (ProgressListener listener : this.progressListeners) {
                listener.done(y, "filtering");
            }
            ++y;
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(listener.steps(), "Filtering complete");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
    }

    @Override
    public int filter(int color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isChanging() {
        return this.blueShift != 0.0 || this.whiteShift != 0.0;
    }

    @Override
    public String name() {
        return "BLUE-SHIFT AND FOG";
    }
}

