/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.image;

import e3d.visualization.image.E3DImage;
import e3d.visualization.util.E3DColor;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class E3DImageSWT
extends E3DImage {
    protected ImageData image = null;
    protected ImageLoader loader = new ImageLoader();

    public E3DImageSWT(int width, int height) {
        this.image = new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                this.image.setAlpha(x, y, 255);
                ++x;
            }
            ++y;
        }
    }

    public E3DImageSWT(int width, int height, Color color) {
        this.image = new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
        int alpha = color.getAlpha();
        int rgb = this.image.palette.getPixel(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                this.image.setAlpha(x, y, alpha);
                this.image.setPixel(x, y, rgb);
                ++x;
            }
            ++y;
        }
    }

    public E3DImageSWT(File file) throws Exception {
        this.image = this.loader.load(file.getAbsolutePath())[0];
    }

    public E3DImageSWT(InputStream stream) throws Exception {
        this.image = this.loader.load(stream)[0];
    }

    public E3DImageSWT(ImageData imageData) {
        this.image = imageData;
    }

    public E3DImageSWT(Image image) {
        this.image = image.getImageData();
    }

    public E3DImageSWT(E3DImage image) {
        this(image.getWidth(), image.getHeight());
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                this.set(x, y, image.get(x, y));
                ++x;
            }
            ++y;
        }
    }

    @Override
    public E3DImageSWT image(int width, int height) {
        return new E3DImageSWT(width, height);
    }

    @Override
    public E3DImageSWT image(int width, int height, Color color) {
        return new E3DImageSWT(width, height, color);
    }

    @Override
    public E3DImageSWT crop(int x0, int y0, int width, int height) {
        return (E3DImageSWT)super.crop(x0, y0, width, height);
    }

    @Override
    public E3DImageSWT scale(int width, int height) {
        return new E3DImageSWT(this.image.scaledTo(width, height));
    }

    @Override
    public E3DImageSWT clone() {
        return this.crop(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void save(File file) throws IOException {
        this.save(file, E3DImageSWT.getFormat(file));
    }

    @Override
    public void save(File file, E3DImage.Format format) throws IOException {
        this.loader.data = new ImageData[]{this.image};
        switch (format) {
            case PNG: {
                this.loader.save(file.getAbsolutePath(), 5);
                break;
            }
            case JPG: {
                this.loader.save(file.getAbsolutePath(), 4);
                break;
            }
            case GIF: {
                this.loader.save(file.getAbsolutePath(), 2);
                break;
            }
            case TIF: {
                this.loader.save(file.getAbsolutePath(), 6);
                break;
            }
            case BMP: {
                this.loader.save(file.getAbsolutePath(), 0);
                break;
            }
            default: {
                throw new IOException("Format not supported");
            }
        }
    }

    @Override
    public void load(File file) throws IOException {
        this.image = this.loader.load(file.getAbsolutePath())[0];
    }

    @Override
    public void set(int x, int y, Color color) {
        this.image.setAlpha(x, y, color.getAlpha());
        this.image.setPixel(x, y, this.image.palette.getPixel(new RGB(color.getRed(), color.getGreen(), color.getBlue())));
    }

    @Override
    public E3DColor get(int x, int y) {
        return new E3DColor(this.image.palette.getRGB(this.image.getPixel(x, y)), this.image.getAlpha(x, y));
    }

    @Override
    public void setRGB(int x, int y, int rgb) {
        this.image.setAlpha(x, y, E3DColor.alpha(rgb));
        this.image.setPixel(x, y, this.image.palette.getPixel(new RGB(E3DColor.red(rgb), E3DColor.green(rgb), E3DColor.blue(rgb))));
    }

    @Override
    public int getRGB(int x, int y) {
        return E3DColor.rgb(this.image.palette.getRGB(this.image.getPixel(x, y)), this.image.getAlpha(x, y));
    }

    @Override
    public int getWidth() {
        return this.image.width;
    }

    @Override
    public int getHeight() {
        return this.image.height;
    }

    @Override
    public ImageData getImageData() {
        return this.image;
    }

    @Override
    public BufferedImage getBufferedImage() {
        throw new UnsupportedOperationException("Conversion to an BufferedImage is not yet supported!");
    }
}

