/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.image;

import e3d.visualization.image.E3DImage;
import e3d.visualization.util.E3DColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class E3DImageAWT
extends E3DImage {
    protected BufferedImage image = null;

    public E3DImageAWT(int width, int height) {
        this.image = new BufferedImage(width, height, 2);
    }

    public E3DImageAWT(int width, int height, Color color) {
        this.image = new BufferedImage(width, height, 2);
        int argb = color.getRGB();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                this.image.setRGB(x, y, argb);
                ++x;
            }
            ++y;
        }
    }

    public E3DImageAWT(File file) throws IOException {
        this.image = ImageIO.read(file);
    }

    public E3DImageAWT(InputStream stream) throws IOException {
        this.image = ImageIO.read(stream);
    }

    public E3DImageAWT(BufferedImage image) {
        this.image = image;
    }

    public E3DImageAWT(E3DImage image) {
        this(image, 2);
    }

    public E3DImageAWT(E3DImage image, int type) {
        int w = image.getWidth();
        int h = image.getHeight();
        this.image = new BufferedImage(w, h, type);
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                this.set(x, y, image.get(x, y));
                ++x;
            }
            ++y;
        }
    }

    @Override
    public E3DImageAWT image(int width, int height) {
        return new E3DImageAWT(width, height);
    }

    @Override
    public E3DImageAWT image(int width, int height, Color color) {
        return new E3DImageAWT(width, height, color);
    }

    @Override
    public E3DImageAWT crop(int x0, int y0, int width, int height) {
        return (E3DImageAWT)super.crop(x0, y0, width, height);
    }

    @Override
    public E3DImageAWT scale(int width, int height) {
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = scaledImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(this.image, 0, 0, width, height, null);
        graphics2D.dispose();
        return new E3DImageAWT(scaledImage);
    }

    @Override
    public E3DImageAWT clone() {
        return this.crop(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void save(File file) throws IOException {
        this.save(file, E3DImageAWT.getFormat(file));
    }

    @Override
    public void save(File file, E3DImage.Format format) throws IOException {
        switch (format) {
            case PNG: {
                ImageIO.write((RenderedImage)this.image, "png", file);
                break;
            }
            case JPG: {
                BufferedImage rgbImg;
                if (this.image.getType() != 1) {
                    rgbImg = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                    Graphics2D graphics2D = rgbImg.createGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    graphics2D.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
                    graphics2D.dispose();
                } else {
                    rgbImg = this.image;
                }
                FileImageOutputStream output = new FileImageOutputStream(file);
                try {
                    ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
                    ImageWriteParam param = writer.getDefaultWriteParam();
                    param.setCompressionMode(2);
                    param.setCompressionQuality(this.getJPGQuality());
                    writer.setOutput(output);
                    writer.write(null, new IIOImage(rgbImg, null, null), param);
                    break;
                }
                finally {
                    output.close();
                }
            }
            case GIF: {
                ImageIO.write((RenderedImage)this.image, "gif", file);
                break;
            }
            case TIF: {
                ImageIO.write((RenderedImage)this.image, "tiff", file);
                break;
            }
            case BMP: {
                ImageIO.write((RenderedImage)this.image, "bmp", file);
                break;
            }
            default: {
                throw new IOException("Format not supported");
            }
        }
    }

    @Override
    public void load(File file) throws IOException {
        this.image = ImageIO.read(file);
    }

    @Override
    public void set(int x, int y, Color color) {
        this.image.setRGB(x, y, color.getRGB());
    }

    @Override
    public E3DColor get(int x, int y) {
        return new E3DColor(this.image.getRGB(x, y));
    }

    @Override
    public void setRGB(int x, int y, int rgb) {
        this.image.setRGB(x, y, rgb);
    }

    @Override
    public int getRGB(int x, int y) {
        return this.image.getRGB(x, y);
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public ImageData getImageData() {
        ImageData imageData = new ImageData(this.image.getWidth(), this.image.getHeight(), 24, new PaletteData(0xFF0000, 65280, 255));
        int scansize = (this.image.getWidth() * 3 + 3) * 4 / 4;
        WritableRaster alphaRaster = this.image.getAlphaRaster();
        byte[] alphaBytes = new byte[this.image.getWidth()];
        int y = 0;
        while (y < this.image.getHeight()) {
            int[] buff = this.image.getRGB(0, y, this.image.getWidth(), 1, null, 0, scansize);
            imageData.setPixels(0, y, this.image.getWidth(), buff, 0);
            if (alphaRaster != null) {
                int[] alpha = alphaRaster.getPixels(0, y, this.image.getWidth(), 1, (int[])null);
                int i = 0;
                while (i < this.image.getWidth()) {
                    alphaBytes[i] = (byte)alpha[i];
                    ++i;
                }
                imageData.setAlphas(0, y, this.image.getWidth(), alphaBytes, 0);
            }
            ++y;
        }
        return imageData;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.image;
    }
}

