/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.image;

import e3d.visualization.image.E3DImageAWT;
import e3d.visualization.image.E3DImageSWT;
import e3d.visualization.util.E3DColor;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.graphics.ImageData;

public abstract class E3DImage {
    protected float quality = 0.9f;

    public static Format getFormat(File file) throws IOException {
        String name = file.getName().toUpperCase();
        if (name.endsWith(".PNG")) {
            return Format.PNG;
        }
        if (name.endsWith(".JPG")) {
            return Format.JPG;
        }
        if (name.endsWith(".JPEG")) {
            return Format.JPG;
        }
        if (name.endsWith(".GIF")) {
            return Format.GIF;
        }
        if (name.endsWith(".TIF")) {
            return Format.TIF;
        }
        if (name.endsWith(".TIFF")) {
            return Format.TIF;
        }
        if (name.endsWith(".BMP")) {
            return Format.BMP;
        }
        throw new IOException("Unkown image format of file \"" + file.getName() + "\".");
    }

    public abstract E3DImage image(int var1, int var2);

    public abstract E3DImage image(int var1, int var2, Color var3);

    public static E3DImage image(int width, int height, Type imageType) {
        switch (imageType) {
            case AWT: {
                return new E3DImageAWT(width, height);
            }
            case SWT: {
                return new E3DImageSWT(width, height);
            }
        }
        return null;
    }

    public static E3DImage image(int width, int height, Color color, Type imageType) {
        switch (imageType) {
            case AWT: {
                return new E3DImageAWT(width, height, color);
            }
            case SWT: {
                return new E3DImageSWT(width, height, color);
            }
        }
        return null;
    }

    public E3DImage crop(int x0, int y0, int width, int height) {
        E3DImage img = this.image(width, height);
        int y1 = 0;
        int y2 = y0;
        while (y1 < height) {
            int x1 = 0;
            int x2 = x0;
            while (x1 < width) {
                if (x2 >= 0 && x2 < this.getWidth() && y2 >= 0 && y2 < this.getHeight()) {
                    img.setRGB(x1, y1, this.getRGB(x2, y2));
                }
                ++x1;
                ++x2;
            }
            ++y1;
            ++y2;
        }
        return img;
    }

    public abstract E3DImage scale(int var1, int var2);

    public E3DImage clone() {
        return this.crop(0, 0, this.getWidth(), this.getHeight());
    }

    public abstract void save(File var1) throws IOException;

    public abstract void save(File var1, Format var2) throws IOException;

    public abstract void load(File var1) throws IOException;

    public abstract void set(int var1, int var2, Color var3);

    public abstract E3DColor get(int var1, int var2);

    public abstract void setRGB(int var1, int var2, int var3);

    public abstract int getRGB(int var1, int var2);

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract ImageData getImageData();

    public abstract BufferedImage getBufferedImage();

    public void setJPGQuality(float quality) {
        this.quality = quality;
    }

    public float getJPGQuality() {
        return this.quality;
    }

    public void mirrorHorizontal() {
        int h = this.getHeight();
        int w = this.getWidth();
        int y = 0;
        while (y < h) {
            int x1 = 0;
            while (x1 < w / 2) {
                int x2 = w - x1 - 1;
                int rgb = this.getRGB(x1, y);
                this.setRGB(x1, y, this.getRGB(x2, y));
                this.setRGB(x2, y, rgb);
                ++x1;
            }
            ++y;
        }
    }

    public void mirrorVertical() {
        int h = this.getHeight();
        int w = this.getWidth();
        int y1 = 0;
        while (y1 < h / 2) {
            int x = 0;
            while (x < w) {
                int y2 = h - y1 - 1;
                int rgb = this.getRGB(x, y1);
                this.setRGB(x, y1, this.getRGB(x, y2));
                this.setRGB(x, y2, rgb);
                ++x;
            }
            ++y1;
        }
    }

    public static enum Format {
        PNG,
        JPG,
        GIF,
        TIF,
        BMP;

    }

    public static enum Type {
        AWT,
        SWT;

    }
}

