/*
 * Decompiled with CFR 0.152.
 */
package e3d.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Tagger<O> {
    protected final Map<O, Set<String>> object2tags = new HashMap<O, Set<String>>();
    protected final Map<String, Set<O>> tag2objects = new HashMap<String, Set<O>>();

    public void clear() {
        this.object2tags.clear();
        this.tag2objects.clear();
    }

    public void addTag(O object, String tag) {
        Set<O> objects = this.tag2objects.get(tag);
        if (objects == null) {
            objects = new HashSet<O>();
            this.tag2objects.put(tag, objects);
        }
        objects.add(object);
        Set<String> tags = this.object2tags.get(object);
        if (tags == null) {
            tags = new HashSet<String>();
            this.object2tags.put(object, tags);
        }
        tags.add(tag);
    }

    public void addTags(O object, Collection<String> tags) {
        for (String tag : tags) {
            this.addTag(object, tag);
        }
    }

    public void addTags(O object, String[] tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.addTag(object, tag);
            ++n2;
        }
    }

    public void addTag(String tag) {
        Set<O> objects = this.tag2objects.get(tag);
        if (objects == null) {
            objects = new HashSet<O>();
            this.tag2objects.put(tag, objects);
        }
    }

    public void addTags(Collection<String> tags) {
        for (String tag : tags) {
            this.addTag(tag);
        }
    }

    public void addTags(String[] tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.addTag(tag);
            ++n2;
        }
    }

    public void removeTag(O object, String tag) {
        Set<String> tags;
        Set<O> objects = this.tag2objects.get(tag);
        if (objects != null) {
            objects.remove(object);
        }
        if ((tags = this.object2tags.get(object)) != null) {
            tags.remove(tag);
        }
    }

    public void removeTags(O object, Collection<String> tags) {
        for (String tag : tags) {
            this.removeTag(object, tag);
        }
    }

    public void removeTags(O object, String[] tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.removeTag(object, tag);
            ++n2;
        }
    }

    public void removeTag(String tag) {
        for (O object : this.getObjects(tag)) {
            Set<String> tags = this.object2tags.get(object);
            if (tags == null) continue;
            tags.remove(tag);
        }
        this.tag2objects.remove(tag);
    }

    public void removeObject(O object) {
        for (String tag : this.getTags(object)) {
            Set<O> objects = this.tag2objects.get(tag);
            if (objects == null) continue;
            objects.remove(object);
        }
        this.object2tags.remove(object);
    }

    public Set<O> getObjects() {
        return this.object2tags.keySet();
    }

    public Set<O> getObjects(String tag) {
        Set<Object> objects = this.tag2objects.get(tag);
        if (objects == null) {
            objects = Collections.emptySet();
        }
        return objects;
    }

    public Set<O> getObjectsWithAnyTag(String[] tags) {
        HashSet<O> objects = new HashSet<O>();
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            objects.addAll(this.getObjects(tag));
            ++n2;
        }
        return objects;
    }

    public Set<O> getObjectsWithAnyTag(Collection<String> tags) {
        HashSet<O> objects = new HashSet<O>();
        for (String tag : tags) {
            objects.addAll(this.getObjects(tag));
        }
        return objects;
    }

    public Set<O> getObjectsWithAllTags(String[] tags) {
        HashSet<O> objects = new HashSet<O>(this.getObjects());
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                if (this.getTags(iterator.next()).contains(tag)) continue;
                iterator.remove();
            }
            ++n2;
        }
        return objects;
    }

    public Set<O> getObjectsWithAllTags(Collection<String> tags) {
        HashSet<O> objects = new HashSet<O>(this.getObjects());
        for (String tag : tags) {
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                if (this.getTags(iterator.next()).contains(tag)) continue;
                iterator.remove();
            }
        }
        return objects;
    }

    public Set<String> getTags() {
        return this.tag2objects.keySet();
    }

    public List<String> getSortedTags() {
        Vector<String> tags = new Vector<String>(this.tag2objects.keySet());
        Collections.sort(tags);
        return tags;
    }

    public Set<String> getTags(O object) {
        Set<String> tags = this.object2tags.get(object);
        if (tags == null) {
            tags = Collections.emptySet();
        }
        return tags;
    }

    public Set<String> getTags(O[] objects) {
        HashSet<String> tags = new HashSet<String>();
        O[] OArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            O object = OArray[n2];
            tags.addAll(this.getTags(object));
            ++n2;
        }
        return tags;
    }

    public Set<String> getTags(Collection<O> objects) {
        HashSet<String> tags = new HashSet<String>();
        for (O object : objects) {
            tags.addAll(this.getTags(object));
        }
        return tags;
    }
}

