/*
 * Decompiled with CFR 0.152.
 */
package e3d.utils;

import java.util.HashMap;
import java.util.Map;

public class Counter<X>
extends HashMap<X, Long> {
    private static final long serialVersionUID = 1L;

    public Counter() {
    }

    public Counter(int initialCapacity) {
        super(initialCapacity);
    }

    public Counter(Counter<X> counter) {
        super(counter);
    }

    public long count(X x) {
        Long n = (Long)this.get(x);
        return n == null ? 0L : n;
    }

    public void setCount(X x, long t) {
        this.put(x, t);
    }

    public void setMin(X x, long t) {
        Long count = (Long)this.get(x);
        if (count == null || t < count) {
            this.setCount(x, t);
        }
    }

    public void setMax(X x, long t) {
        Long count = (Long)this.get(x);
        if (count == null || t > count) {
            this.setCount(x, t);
        }
    }

    public long decrement(X x) {
        return this.increment(x, -1L);
    }

    public long increment(X x) {
        return this.increment(x, 1L);
    }

    public long decrement(X x, long t) {
        return this.increment(x, -t);
    }

    public long increment(X x, long t) {
        Long n = (Long)this.get(x);
        Long m = n == null ? t : n + t;
        this.put(x, m);
        return m;
    }

    public Long removeAll(X x) {
        return (Long)super.remove(x);
    }

    public void add(Counter<X> counter) {
        for (Map.Entry entry : counter.entrySet()) {
            this.increment(entry.getKey(), (Long)entry.getValue());
        }
    }

    public void add(Counter<X> counter, long t) {
        for (Map.Entry entry : counter.entrySet()) {
            this.increment(entry.getKey(), (Long)entry.getValue() * t);
        }
    }

    public void multiply(long t) {
        for (Map.Entry entry : this.entrySet()) {
            this.increment(entry.getKey(), (Long)entry.getValue() * t);
        }
    }

    @Override
    public String toString() {
        StringBuffer string = new StringBuffer("COUNTER:\n");
        for (Object key : this.keySet()) {
            string.append("  " + this.cut(key.toString()) + ": " + this.count(key) + "x\n");
        }
        return new String(string);
    }

    private String cut(String string) {
        if (string.length() <= 30) {
            return string;
        }
        return String.valueOf(string.substring(0, 27)) + "...";
    }
}

