/*
 * Decompiled with CFR 0.152.
 */
package e3d.utils;

import e3d.bezier.Needle;
import e3d.bezier.PointMesh;
import e3d.bezier.Position;
import e3d.euclidean.E3DTangent;
import e3d.euclidean.E3DVector;
import e3d.j3d.objects.J3DNeedle;
import e3d.j3d.objects.J3DPoint;
import e3d.visualization.mesh.E3DMeshPoint;
import java.lang.reflect.Array;

public abstract class ArrayFactory<Value> {
    public static final ArrayFactory<Integer> INTEGER = new ArrayFactory<Integer>(){

        public Integer[] create(int size) {
            return new Integer[size];
        }

        @Override
        public Integer copy(Integer element) {
            return element;
        }
    };
    public static final ArrayFactory<Long> LONG = new ArrayFactory<Long>(){

        public Long[] create(int size) {
            return new Long[size];
        }

        @Override
        public Long copy(Long element) {
            return element;
        }
    };
    public static final ArrayFactory<Float> FLOAT = new ArrayFactory<Float>(){

        public Float[] create(int size) {
            return new Float[size];
        }

        @Override
        public Float copy(Float element) {
            return element;
        }
    };
    public static final ArrayFactory<Double> DOUBLE = new ArrayFactory<Double>(){

        public Double[] create(int size) {
            return new Double[size];
        }

        @Override
        public Double copy(Double element) {
            return element;
        }
    };
    public static final ArrayFactory<Boolean> BOOLEAN = new ArrayFactory<Boolean>(){

        public Boolean[] create(int size) {
            return new Boolean[size];
        }

        @Override
        public Boolean copy(Boolean element) {
            return element;
        }
    };
    public static final ArrayFactory<String> STRING = new ArrayFactory<String>(){

        public String[] create(int size) {
            return new String[size];
        }

        @Override
        public String copy(String element) {
            return element;
        }
    };
    public static final ArrayFactory<E3DVector> VECTOR3D = new ArrayFactory<E3DVector>(){

        public E3DVector[] create(int size) {
            return new E3DVector[size];
        }

        @Override
        public E3DVector copy(E3DVector element) {
            return element.clone();
        }
    };
    public static final ArrayFactory<E3DTangent> TANGENT = new ArrayFactory<E3DTangent>(){

        public E3DTangent[] create(int size) {
            return new E3DTangent[size];
        }

        @Override
        public E3DTangent copy(E3DTangent element) {
            return element.clone();
        }
    };
    public static final ArrayFactory<E3DMeshPoint> MESHPOINT = new ArrayFactory<E3DMeshPoint>(){

        public E3DMeshPoint[] create(int size) {
            return new E3DMeshPoint[size];
        }

        @Override
        public E3DMeshPoint copy(E3DMeshPoint element) {
            return element.clone();
        }
    };
    public static final ArrayFactory<Position> POSITION = new ArrayFactory<Position>(){

        public Position[] create(int size) {
            return new Position[size];
        }

        @Override
        public Position copy(Position element) {
            return element.clone();
        }
    };
    public static final ArrayFactory<Needle> NEEDLE = new ArrayFactory<Needle>(){

        public Needle[] create(int size) {
            return new Needle[size];
        }

        @Override
        public Needle copy(Needle element) {
            return element.clone();
        }
    };
    public static final ArrayFactory<J3DPoint> J3DPOINT = new ArrayFactory<J3DPoint>(){

        public J3DPoint[] create(int size) {
            return new J3DPoint[size];
        }

        @Override
        public J3DPoint copy(J3DPoint element) {
            return element;
        }
    };
    public static final ArrayFactory<J3DNeedle> J3DNEEDLE = new ArrayFactory<J3DNeedle>(){

        public J3DNeedle[] create(int size) {
            return new J3DNeedle[size];
        }

        @Override
        public J3DNeedle copy(J3DNeedle element) {
            return element;
        }
    };
    public static final ArrayFactory<PointMesh> MESH = new ArrayFactory<PointMesh>(){

        public PointMesh[] create(int size) {
            return new PointMesh[size];
        }

        @Override
        public PointMesh copy(PointMesh element) {
            return element.clone();
        }
    };

    public static <T> T[] createArray(Class<T> type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    public static <T> T[][] createArray2D(Class<T> type, int size1, int size2) {
        return (Object[][])Array.newInstance(type, size1, size2);
    }

    public static <T> T[][][] createArray3D(Class<T> type, int size1, int size2, int size3) {
        return (Object[][][])Array.newInstance(type, size1, size2, size3);
    }

    public abstract Value[] create(int var1);

    public abstract Value copy(Value var1);
}

