/*
 * Decompiled with CFR 0.152.
 */
package e3d.typewriter;

import e3d.bezier.Surfaces;
import e3d.typewriter.E3DCharacter;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class E3DFont {
    protected String text = "";
    protected final Map<Character, E3DCharacter> characterSet = new HashMap<Character, E3DCharacter>();
    protected Color color = new Color(255, 255, 255);
    protected double boldness = 1.0;
    protected double horizontalSpacing = 0.0;
    protected int radialPoints = 5;
    protected double indent = 0.0;
    protected final List<E3DCharacter> characters = new Vector<E3DCharacter>();

    public void loadFontData(ZipFile fontZipArchive) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = fontZipArchive.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (entry.isDirectory() || !entry.getName().startsWith("char_") || !entry.getName().endsWith(".des")) continue;
            String s = entry.getName().substring(5, entry.getName().length() - 4);
            char c = (char)Integer.parseInt(s, 16);
            E3DCharacter character = new E3DCharacter(fontZipArchive, entry, c != ' ');
            this.characterSet.put(Character.valueOf(c), character);
        }
    }

    public void loadFontData(File fontDirectory) throws IOException {
        File[] fileArray = fontDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fontFile = fileArray[n2];
            if (fontFile.getName().startsWith("char_") && fontFile.getName().endsWith(".des")) {
                String s = fontFile.getName().substring(5, fontFile.getName().length() - 4);
                char c = (char)Integer.parseInt(s, 16);
                E3DCharacter character = new E3DCharacter(fontFile, c != ' ');
                this.characterSet.put(Character.valueOf(c), character);
            }
            ++n2;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) throws E3DFontException {
        this.text = text;
        this.characters.clear();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            E3DCharacter character = this.characterSet.get(Character.valueOf(c));
            if (character == null) {
                throw new E3DFontException("Character " + c + " missing in font");
            }
            this.characters.add(character);
            ++n2;
        }
    }

    public E3DCharacter getCharacter(char c) {
        return this.characterSet.get(Character.valueOf(c));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getBoldness() {
        return this.boldness;
    }

    public void setBoldness(double boldness) {
        this.boldness = boldness;
    }

    public double getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(double horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }

    public int getRadialPoints() {
        return this.radialPoints;
    }

    public void setRadialPoints(int radialPoints) {
        this.radialPoints = radialPoints;
    }

    public double getIndent() {
        return this.indent;
    }

    public void setIndent(double indent) {
        this.indent = indent;
    }

    public abstract int getLongitudinalSurfacesPerSegment();

    public abstract int getRadialSurfacesPerSegment();

    public abstract Surfaces asBezierMeshs();

    public static class E3DFontException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected E3DFontException(String message) {
            super(message);
        }
    }
}

