/*
 * Decompiled with CFR 0.152.
 */
package e3d.typewriter;

import e3d.euclidean.E3DVector;
import e3d.typewriter.E3DCharacterSegment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class E3DCharacter {
    protected final List<E3DCharacterSegment> segments = new Vector<E3DCharacterSegment>();
    protected final double minWidth;

    public E3DCharacter(File characterFile, boolean visible) throws IOException {
        this.minWidth = this.read(new BufferedReader(new FileReader(characterFile)), visible);
    }

    public E3DCharacter(ZipFile zipArchive, ZipEntry characterEntry, boolean visible) throws IOException {
        this.minWidth = this.read(new BufferedReader(new InputStreamReader(zipArchive.getInputStream(characterEntry))), visible);
    }

    public List<E3DCharacterSegment> getSegments() {
        return this.segments;
    }

    public double getMinWidth() {
        return this.minWidth;
    }

    protected double read(BufferedReader reader, boolean visible) throws NumberFormatException, IOException {
        String line;
        this.segments.clear();
        double xMax = Double.MIN_VALUE;
        double xMin = Double.MAX_VALUE;
        Vector<E3DVector> points = new Vector<E3DVector>();
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            if (tokenizer.countTokens() >= 3) {
                double x = Double.parseDouble(tokenizer.nextToken());
                double y = Double.parseDouble(tokenizer.nextToken());
                double z = Double.parseDouble(tokenizer.nextToken());
                E3DVector point = new E3DVector(x, y, z);
                points.add(point);
                xMin = Math.min(xMin, x);
                xMax = Math.max(xMax, x);
                continue;
            }
            if (points.size() <= 1 || !visible) continue;
            this.segments.add(new E3DCharacterSegment(points));
            points = new Vector();
        }
        if (points.size() > 1 && visible) {
            this.segments.add(new E3DCharacterSegment(points));
        }
        return xMax - xMin;
    }
}

