/*
 * Decompiled with CFR 0.152.
 */
package e3d.test;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4f;

public class Texture3DTest
extends Applet {
    private static final long serialVersionUID = 1L;
    private Canvas3D canvas = null;
    private SimpleUniverse universe = null;
    private BranchGroup scene = null;
    private TransformGroup btrans = null;
    private TransformGroup cytrans = null;
    private TransformGroup cntrans = null;
    private TransformGroup strans = null;
    private MouseRotate rotator = null;
    private MouseTranslate translator = null;
    private MouseZoom zoomer = null;
    private TextureAttributes txattr = null;
    private TexCoordGeneration texgen = null;
    private PolygonAttributes pattr = null;

    public Texture3DTest() {
        this.setLayout(new BorderLayout());
        Panel uppanel = new Panel();
        this.add((Component)uppanel, "North");
        uppanel.add(new Label("Mouse:"));
        Choice ochoice = new Choice();
        ochoice.add("BOX");
        ochoice.add("CYLINDER");
        ochoice.add("CONE");
        ochoice.add("SPHERE");
        ochoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String item = (String)e.getItem();
                if (item.equals("BOX")) {
                    Texture3DTest.this.rotator.setTransformGroup(Texture3DTest.this.btrans);
                    Texture3DTest.this.translator.setTransformGroup(Texture3DTest.this.btrans);
                    Texture3DTest.this.zoomer.setTransformGroup(Texture3DTest.this.btrans);
                } else if (item.equals("CYLINDER")) {
                    Texture3DTest.this.rotator.setTransformGroup(Texture3DTest.this.cytrans);
                    Texture3DTest.this.translator.setTransformGroup(Texture3DTest.this.cytrans);
                    Texture3DTest.this.zoomer.setTransformGroup(Texture3DTest.this.cytrans);
                } else if (item.equals("CONE")) {
                    Texture3DTest.this.rotator.setTransformGroup(Texture3DTest.this.cntrans);
                    Texture3DTest.this.translator.setTransformGroup(Texture3DTest.this.cntrans);
                    Texture3DTest.this.zoomer.setTransformGroup(Texture3DTest.this.cntrans);
                } else if (item.equals("SPHERE")) {
                    Texture3DTest.this.rotator.setTransformGroup(Texture3DTest.this.strans);
                    Texture3DTest.this.translator.setTransformGroup(Texture3DTest.this.strans);
                    Texture3DTest.this.zoomer.setTransformGroup(Texture3DTest.this.strans);
                }
            }
        });
        uppanel.add(ochoice);
        Choice genchoice = new Choice();
        genchoice.add("OBJECT_LIENEAR");
        genchoice.add("EYE_LIENEAR");
        genchoice.select(1);
        genchoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String item = (String)e.getItem();
                int mode = Texture3DTest.this.texgen.getGenMode();
                if (item.equals("OBJECT_LIENEAR")) {
                    mode = 0;
                } else if (item.equals("EYE_LIENEAR")) {
                    mode = 1;
                }
                Texture3DTest.this.universe.getLocale().removeBranchGraph(Texture3DTest.this.scene);
                Texture3DTest.this.texgen.setGenMode(mode);
                Texture3DTest.this.universe.addBranchGraph(Texture3DTest.this.scene);
            }
        });
        uppanel.add(genchoice);
        Choice pochoice = new Choice();
        pochoice.add("POLYGON_FILL");
        pochoice.add("POLYGON_LINE");
        pochoice.add("POLYGON_POINT");
        pochoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String item = (String)e.getItem();
                if (item.equals("POLYGON_FILL")) {
                    Texture3DTest.this.pattr.setPolygonMode(2);
                } else if (item.equals("POLYGON_LINE")) {
                    Texture3DTest.this.pattr.setPolygonMode(1);
                } else if (item.equals("POLYGON_POINT")) {
                    Texture3DTest.this.pattr.setPolygonMode(0);
                }
            }
        });
        uppanel.add(pochoice);
        Panel downpanel = new Panel();
        this.add((Component)downpanel, "South");
        downpanel.add(new Label("TexRot - X"));
        final TextField xfield = new TextField("1.0");
        downpanel.add(xfield);
        downpanel.add(new Label("Y"));
        final TextField yfield = new TextField("0.0");
        downpanel.add(yfield);
        downpanel.add(new Label("Z"));
        final TextField zfield = new TextField("0.0");
        downpanel.add(zfield);
        downpanel.add(new Label("A"));
        final TextField afield = new TextField("0.5");
        downpanel.add(new Label("* PI"));
        downpanel.add(afield);
        Button rbutton = new Button("RotTex");
        rbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    float x = Float.parseFloat(xfield.getText());
                    float y = Float.parseFloat(yfield.getText());
                    float z = Float.parseFloat(zfield.getText());
                    float a = Float.parseFloat(afield.getText());
                    AxisAngle4f ax = new AxisAngle4f(x, y, z, a * (float)Math.PI);
                    Transform3D t3d = new Transform3D();
                    t3d.setRotation(ax);
                    Texture3DTest.this.txattr.setTextureTransform(t3d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        downpanel.add(rbutton);
    }

    @Override
    public void init() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.canvas = new Canvas3D(config);
        this.add((Component)this.canvas, "Center");
        this.universe = new SimpleUniverse(this.canvas);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.scene = this.createSceneGraph();
        this.universe.addBranchGraph(this.scene);
    }

    private BranchGroup createSceneGraph() {
        BranchGroup root = new BranchGroup();
        root.setCapability(17);
        Background bg = new Background(new Color3f(0.5f, 0.5f, 0.5f));
        bg.setApplicationBounds((Bounds)new BoundingSphere(new Point3d(), 100.0));
        root.addChild((Node)bg);
        TransformGroup trans = new TransformGroup();
        double[] vertices = new double[]{-0.8, -0.8, 0.0, -0.8, 0.8, 0.0, -0.4, -0.8, 0.0, -0.4, 0.8, 0.0, 0.0, -0.8, 0.0, 0.0, 0.8, 0.0, 0.4, -0.8, 0.0, 0.4, 0.8, 0.0, 0.8, -0.8, 0.0, 0.8, 0.8, 0.0, -0.8, -0.8, 0.0, 0.8, -0.8, 0.0, -0.8, -0.4, 0.0, 0.8, -0.4, 0.0, -0.8, 0.0, 0.0, 0.8, 0.0, 0.0, -0.8, 0.4, 0.0, 0.8, 0.4, 0.0, -0.8, 0.8, 0.0, 0.8, 0.8, 0.0};
        LineArray geom = new LineArray(vertices.length, 1);
        geom.setCoordinates(0, vertices);
        Shape3D grid = new Shape3D((Geometry)geom);
        trans.addChild((Node)grid);
        Appearance ap = this.createAppearance();
        Transform3D bt3d = new Transform3D();
        bt3d.set(new Vector3d(-0.4, 0.4, 0.0));
        this.btrans = new TransformGroup(bt3d);
        this.btrans.setCapability(17);
        this.btrans.setCapability(18);
        this.btrans.addChild((Node)new Box(0.25f, 0.25f, 0.25f, 0, ap));
        trans.addChild((Node)this.btrans);
        Transform3D cyt3d = new Transform3D();
        cyt3d.set(new Vector3d(-0.4, -0.4, 0.0));
        this.cytrans = new TransformGroup(cyt3d);
        this.cytrans.setCapability(17);
        this.cytrans.setCapability(18);
        this.cytrans.addChild((Node)new Cylinder(0.3f, 0.6f, 0, ap));
        trans.addChild((Node)this.cytrans);
        Transform3D cnt3d = new Transform3D();
        cnt3d.set(new Vector3d(0.4, 0.4, 0.0));
        this.cntrans = new TransformGroup(cnt3d);
        this.cntrans.setCapability(17);
        this.cntrans.setCapability(18);
        this.cntrans.addChild((Node)new Cone(0.3f, 0.6f, 0, ap));
        trans.addChild((Node)this.cntrans);
        Transform3D st3d = new Transform3D();
        st3d.set(new Vector3d(0.4, -0.4, 0.0));
        this.strans = new TransformGroup(st3d);
        this.strans.setCapability(17);
        this.strans.setCapability(18);
        this.strans.addChild((Node)new Sphere(0.3f, 0, ap));
        trans.addChild((Node)this.strans);
        BoundingSphere bounds = new BoundingSphere(new Point3d(), 100.0);
        this.rotator = new MouseRotate(this.btrans);
        this.rotator.setSchedulingBounds((Bounds)bounds);
        root.addChild((Node)this.rotator);
        this.translator = new MouseTranslate(this.btrans);
        this.translator.setSchedulingBounds((Bounds)bounds);
        root.addChild((Node)this.translator);
        this.zoomer = new MouseZoom(this.btrans);
        this.zoomer.setSchedulingBounds((Bounds)bounds);
        root.addChild((Node)this.zoomer);
        root.addChild((Node)trans);
        return root;
    }

    private Appearance createAppearance() {
        Appearance app = new Appearance();
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.setTransparencyMode(2);
        ta.setTransparency(0.5f);
        app.setTransparencyAttributes(ta);
        BufferedImage[] bimages = new BufferedImage[64];
        float dh = 0.015625f;
        Color c0 = new Color(255, 0, 0, 0);
        int i = 0;
        while (i < 64) {
            bimages[i] = new BufferedImage(64, 64, 2);
            Graphics2D g = bimages[i].createGraphics();
            g.setColor(c0);
            g.fillRect(0, 0, 64, 64);
            float h = dh * (float)i;
            Color c = Color.getHSBColor(h, 1.0f, 1.0f);
            g.setColor(c);
            int j = 0;
            while (j < 8) {
                int x = j * 4;
                int w = 64 - x * 2;
                System.out.println("i=" + i + ", j=" + j + ", x=" + x + ", w=" + w + ", h" + h);
                g.drawOval(x, x, w, w);
                ++j;
            }
            ++i;
        }
        ImageComponent3D icompo3d = new ImageComponent3D(2, bimages);
        Texture3D texture3d = new Texture3D(1, 6, 64, 64, 64);
        texture3d.setImage(0, (ImageComponent)icompo3d);
        app.setTexture((Texture)texture3d);
        this.txattr = new TextureAttributes();
        this.txattr.setCapability(5);
        Transform3D t3d = new Transform3D();
        t3d.rotX(1.5707963267948966);
        this.txattr.setTextureTransform(t3d);
        app.setTextureAttributes(this.txattr);
        this.texgen = new TexCoordGeneration(1, 1);
        this.texgen.setCapability(3);
        this.texgen.setPlaneS(new Vector4f(1.0f, 0.0f, 0.0f, 0.0f));
        this.texgen.setPlaneT(new Vector4f(0.0f, 1.0f, 0.0f, 0.0f));
        this.texgen.setPlaneR(new Vector4f(0.0f, 0.0f, 1.0f, 0.0f));
        app.setTexCoordGeneration(this.texgen);
        this.pattr = new PolygonAttributes();
        this.pattr.setCapability(3);
        this.pattr.setCapability(1);
        app.setPolygonAttributes(this.pattr);
        return app;
    }

    public static void main(String[] args) {
        Texture3DTest applet = new Texture3DTest();
        new MainFrame((Applet)applet, 500, 500);
    }
}

