/*
 * Decompiled with CFR 0.152.
 */
package e3d.test;

import e3d.visualization.image.E3DImageAWT;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class Poster {
    public static void main(String[] args) {
        File dir = new File("/home/patter/tmp");
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith("face_err");
            }
        });
        E3DImageAWT poster = new E3DImageAWT(8000, 8000, new Color(0, 0, 0));
        Graphics2D graphics2D = poster.getBufferedImage().createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int cols = 8;
        int rows = 7;
        int x = 0;
        int y = 0;
        int i = 0;
        int row = 0;
        while (row < 7) {
            int h = 0;
            int col = 0;
            while (col < 8) {
                if (i < files.length) {
                    File file = files[i];
                    try {
                        System.out.println(file.getName());
                        E3DImageAWT img = new E3DImageAWT(file);
                        if ((double)img.getWidth() / (double)img.getHeight() < 0.5) {
                            graphics2D.drawImage(img.getBufferedImage(), x + img.getWidth(), y, -img.getWidth(), img.getHeight(), null);
                            graphics2D.drawImage((Image)img.getBufferedImage(), x + img.getWidth(), y, null);
                            x += 2 * img.getWidth();
                        } else {
                            graphics2D.drawImage((Image)img.getBufferedImage(), x, y, null);
                            x += img.getWidth();
                        }
                        h = Math.max(h, img.getHeight());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                ++col;
            }
            y += h;
            x = 0;
            ++row;
        }
        try {
            poster.save(new File("/home/patter/tmp/poster.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("READY");
    }
}

