/*
 * Decompiled with CFR 0.152.
 */
package e3d.numbers;

import e3d.euclidean.E3DVector;
import e3d.numbers.E3DNumber;

public class ComplexNumber
implements E3DNumber {
    public double r;
    public double i;

    public ComplexNumber() {
        this.set(0.0, 0.0);
    }

    public ComplexNumber(double real) {
        this.set(real);
    }

    public ComplexNumber(ComplexNumber number) {
        this.set(number);
    }

    public ComplexNumber(double real, double imaginary) {
        this.set(real, imaginary);
    }

    @Override
    public ComplexNumber clone() {
        return new ComplexNumber(this);
    }

    @Override
    public ComplexNumber origin() {
        return new ComplexNumber(0.0, 0.0);
    }

    @Override
    public boolean isValid() {
        return !Double.isNaN(this.r) && !Double.isNaN(this.i);
    }

    @Override
    public void set(double value) {
        this.r = value;
        this.i = 0.0;
    }

    @Override
    public void set(E3DNumber number) {
        ComplexNumber complex = (ComplexNumber)number;
        this.r = complex.r;
        this.i = complex.i;
    }

    public void set(double real, double imaginary) {
        this.r = real;
        this.i = imaginary;
    }

    @Override
    public void setAll(double value) {
        this.r = value;
        this.i = value;
    }

    @Override
    public void put(E3DVector vector) {
        vector.x = this.r;
        vector.y = this.i;
        vector.z = 0.0;
    }

    public boolean isReal() {
        return this.i == 0.0;
    }

    public double real() {
        return this.r;
    }

    public double imaginary() {
        return this.i;
    }

    @Override
    public double length() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    @Override
    public double dist(E3DNumber n) {
        ComplexNumber c = (ComplexNumber)n;
        return Math.sqrt((this.r - c.r) * (this.r - c.r) + (this.i - c.i) * (this.i - c.i));
    }

    @Override
    public double squaredLength() {
        return this.r * this.r + this.i * this.i;
    }

    @Override
    public double squaredDist(E3DNumber n) {
        ComplexNumber c = (ComplexNumber)n;
        return (this.r - c.r) * (this.r - c.r) + (this.i - c.i) * (this.i - c.i);
    }

    @Override
    public void mean(E3DNumber a, E3DNumber b) {
        ComplexNumber u = (ComplexNumber)a;
        ComplexNumber v = (ComplexNumber)b;
        this.set((u.r + v.r) / 2.0, (u.i + v.i) / 2.0);
    }

    @Override
    public E3DNumber[] neighbors(double offset) {
        return new E3DNumber[]{new ComplexNumber(this.r - offset, this.i), new ComplexNumber(this.r + offset, this.i), new ComplexNumber(this.r, this.i - offset), new ComplexNumber(this.r, this.i + offset)};
    }

    @Override
    public E3DNumber[] positiveNeighbors(double offset) {
        return new E3DNumber[]{new ComplexNumber(this.r + offset, this.i), new ComplexNumber(this.r, this.i + offset)};
    }

    @Override
    public E3DNumber[] negativeNeighbors(double offset) {
        return new E3DNumber[]{new ComplexNumber(this.r - offset, this.i), new ComplexNumber(this.r, this.i - offset)};
    }

    @Override
    public void mirror(E3DNumber number) {
        ComplexNumber complex = (ComplexNumber)number;
        double dot = complex.r * this.r + complex.i * this.i;
        if (dot != 0.0) {
            double u = -2.0 * dot / complex.squaredLength();
            this.r += u * complex.r;
            this.i += u * complex.i;
        }
    }

    @Override
    public double angle(E3DNumber number) {
        return Math.acos(this.cosinus(number));
    }

    @Override
    public double cosinus(E3DNumber number) {
        ComplexNumber complex = (ComplexNumber)number;
        double dot = complex.r * this.r + complex.i * this.i;
        return dot / (this.length() * complex.length());
    }

    @Override
    public void plus(E3DNumber number) {
        ComplexNumber complex = (ComplexNumber)number;
        this.set(this.r + complex.r, this.i + complex.i);
    }

    @Override
    public void plus(double number) {
        this.set(this.r + number, this.i);
    }

    @Override
    public void minus(E3DNumber number) {
        ComplexNumber complex = (ComplexNumber)number;
        this.set(this.r - complex.r, this.i - complex.i);
    }

    @Override
    public void minus(double number) {
        this.set(this.r - number, this.i);
    }

    @Override
    public void times(E3DNumber number) {
        ComplexNumber complex = (ComplexNumber)number;
        this.set(this.r * complex.r - this.i * complex.i, this.r * complex.i + this.i * complex.r);
    }

    @Override
    public void times(double number) {
        this.set(this.r * number, this.i * number);
    }

    @Override
    public void semit(E3DNumber number) {
        ComplexNumber complex = (ComplexNumber)number;
        this.set(complex.r * this.r - complex.i * this.i, complex.r * this.i + complex.i * this.r);
    }

    @Override
    public void divide(E3DNumber number) {
        ComplexNumber complex = (ComplexNumber)number;
        this.times(complex.reciprocal());
    }

    @Override
    public void divide(double number) {
        this.times(1.0 / number);
    }

    @Override
    public ComplexNumber sum(E3DNumber number) {
        ComplexNumber complex = new ComplexNumber(this);
        complex.plus(number);
        return complex;
    }

    @Override
    public ComplexNumber sum(double number) {
        ComplexNumber complex = new ComplexNumber(this);
        complex.plus(number);
        return complex;
    }

    @Override
    public ComplexNumber diff(E3DNumber number) {
        ComplexNumber complex = new ComplexNumber(this);
        complex.minus(number);
        return complex;
    }

    @Override
    public ComplexNumber diff(double number) {
        ComplexNumber complex = new ComplexNumber(this);
        complex.minus(number);
        return complex;
    }

    @Override
    public ComplexNumber product(E3DNumber number) {
        ComplexNumber complex = new ComplexNumber(this);
        complex.times(number);
        return complex;
    }

    @Override
    public ComplexNumber product(double number) {
        ComplexNumber complex = new ComplexNumber(this);
        complex.times(number);
        return complex;
    }

    @Override
    public ComplexNumber quotient(E3DNumber number) {
        ComplexNumber complex = new ComplexNumber(this);
        complex.divide(number);
        return complex;
    }

    @Override
    public ComplexNumber quotient(double number) {
        ComplexNumber complex = new ComplexNumber(this);
        complex.divide(number);
        return complex;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ComplexNumber)) {
            return false;
        }
        return this.real() == ((ComplexNumber)object).real() && this.imaginary() == ((ComplexNumber)object).imaginary();
    }

    public int hashCode() {
        return Double.valueOf(this.r).hashCode() + Double.valueOf(this.i).hashCode();
    }

    public double absolute() {
        return this.length();
    }

    public double argument() {
        return Math.atan(this.i / this.r);
    }

    public double phase() {
        return this.argument();
    }

    public ComplexNumber conjugate() {
        return new ComplexNumber(this.r, -this.i);
    }

    public ComplexNumber reciprocal() {
        double f = this.r * this.r + this.i * this.i;
        return new ComplexNumber(this.r / f, -(this.i / f));
    }

    @Override
    public ComplexNumber sinus() {
        return new ComplexNumber(Math.sin(this.r) * Math.cosh(this.i), Math.cos(this.r) * Math.sinh(this.i));
    }

    public ComplexNumber sinusHyperbolicus() {
        return new ComplexNumber(Math.sinh(this.r) * Math.cos(this.i), Math.cosh(this.r) * Math.sin(this.i));
    }

    @Override
    public ComplexNumber cosinus() {
        return new ComplexNumber(Math.cos(this.r) * Math.cosh(this.i), -(Math.sin(this.r) * Math.sinh(this.i)));
    }

    public ComplexNumber cosinusHyperbolicus() {
        return new ComplexNumber(Math.cosh(this.r) * Math.cos(this.i), Math.sinh(this.r) * Math.sin(this.i));
    }

    public ComplexNumber tangent() {
        double f = 2.0;
        double t = Math.cos(2.0 * this.r) + Math.cosh(2.0 * this.i);
        return new ComplexNumber(Math.sin(2.0 * this.r) / t, Math.sinh(2.0 * this.i) / t);
    }

    public ComplexNumber tangentHyperbolicus() {
        double f = 2.0;
        double t = Math.cosh(2.0 * this.r) + Math.cos(2.0 * this.i);
        return new ComplexNumber(Math.sinh(2.0 * this.r) / t, Math.sin(2.0 * this.i) / t);
    }

    public ComplexNumber cotangent() {
        double f = 2.0;
        double t = Math.cosh(2.0 * this.i) - Math.cos(2.0 * this.r);
        return new ComplexNumber(Math.sin(2.0 * this.r) / t, -(Math.sinh(2.0 * this.i) / t));
    }

    public ComplexNumber cotangentHyperbolicus() {
        double f = 2.0;
        double t = Math.cosh(2.0 * this.r) - Math.cos(2.0 * this.i);
        return new ComplexNumber(Math.sinh(2.0 * this.r) / t, Math.sin(2.0 * this.i) / t);
    }

    @Override
    public ComplexNumber exponent() {
        double t = Math.exp(this.r);
        return new ComplexNumber(Math.cos(this.i) * t, Math.sin(this.i) * t);
    }

    @Override
    public ComplexNumber logarithmNaturalis() {
        return new ComplexNumber(Math.log(this.absolute()), this.argument());
    }

    @Override
    public ComplexNumber power(E3DNumber number) {
        ComplexNumber complex = (ComplexNumber)number;
        return new ComplexNumber(complex.product(this.logarithmNaturalis()).exponent());
    }

    @Override
    public ComplexNumber power(double number) {
        return new ComplexNumber(this.logarithmNaturalis().product(number).exponent());
    }

    @Override
    public ComplexNumber squareRoot() {
        double a = this.argument() / 2.0;
        double b = Math.sqrt(this.absolute());
        return new ComplexNumber(Math.cos(a) * b, Math.sin(a) * b);
    }

    public String toString() {
        return String.format("(%g, %g i)", this.r, this.i);
    }
}

