/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.util;

import e3d.visualization.image.E3DImage;
import e3d.visualization.util.E3DColor;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture2D;
import javax.vecmath.TexCoord3f;

public class J3DTexturePainter {
    protected final int color;
    protected final double opacity;
    protected final E3DImage mask;
    BufferedImage image;
    final ImageComponent2D.Updater paintUpdater = new ImageComponent2D.Updater(){

        public void updateData(ImageComponent2D imageComponent, int x0, int y0, int w, int h) {
            BufferedImage image = imageComponent.getImage();
            int x1 = x0 + w;
            int y1 = y0 + h;
            int xm = x0 == 0 ? J3DTexturePainter.this.mask.getWidth() - w : 0;
            int ym = y0 == 0 ? J3DTexturePainter.this.mask.getHeight() - h : 0;
            int y = y0;
            while (y < y1) {
                int x = x0;
                while (x < x1) {
                    if (x >= 0 && x < image.getWidth() && y >= 0 && y < image.getHeight()) {
                        double factor = (double)E3DColor.alpha(J3DTexturePainter.this.mask.getRGB(x - x0 + xm, y - y0 + ym)) / 255.0;
                        int oldColor = image.getRGB(x, y);
                        int newColor = E3DColor.overlay(J3DTexturePainter.this.color, J3DTexturePainter.this.opacity * factor, oldColor);
                        image.setRGB(x, y, newColor);
                    }
                    ++x;
                }
                ++y;
            }
        }
    };
    final ImageComponent2D.Updater subImgUpdater = new ImageComponent2D.Updater(){

        public void updateData(ImageComponent2D imageComponent, int x0, int y0, int w, int h) {
            BufferedImage img = imageComponent.getImage();
            Graphics2D graphics2D = img.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(J3DTexturePainter.this.image, x0, y0, x0 + w, y0 + h, x0 * 2, y0 * 2, (x0 + w) * 2, (y0 + w) * 2, null);
            graphics2D.dispose();
        }
    };

    public J3DTexturePainter(Texture2D texture, TexCoord3f[] coords, int color, double opacity, E3DImage mask) {
        this.mask = mask;
        this.color = color;
        this.opacity = opacity;
        ImageComponent[] imageComponents = texture.getImages();
        ImageComponent2D imageComponent0 = (ImageComponent2D)imageComponents[0];
        BufferedImage image0 = imageComponent0.getImage();
        int i = 1;
        while (i < coords.length) {
            double x0 = coords[i - 1].x;
            double y0 = coords[i - 1].y;
            double x1 = coords[i].x;
            double y1 = coords[i].y;
            double dx = x1 - x0;
            double dy = y1 - y0;
            int steps = (int)Math.sqrt(Math.pow(dx * (double)image0.getWidth(), 2.0) + Math.pow(dy * (double)image0.getHeight(), 2.0)) + 1;
            int step = 1;
            while (step <= steps) {
                double t = (double)step / (double)steps;
                int w = mask.getWidth();
                int h = mask.getHeight();
                int x = (int)((x0 + dx * t) * (double)image0.getWidth() + 0.5) - w / 2;
                int y = (int)((y0 + dy * t) * (double)image0.getHeight() + 0.5) - h / 2;
                int w1 = Math.max(0, -x);
                int h1 = Math.max(0, -y);
                int w2 = Math.max(0, x + w - (image0.getWidth() - 1));
                int h2 = Math.max(0, y + h - (image0.getHeight() - 1));
                imageComponent0.updateData(this.paintUpdater, x + w1, y + h1, w - (w1 + w2), h - (h1 + h2));
                this.image = image0;
                int level = 1;
                while (level < imageComponents.length) {
                    w = (w + 1) / 2;
                    h = (h + 1) / 2;
                    ImageComponent2D imageComponent = (ImageComponent2D)imageComponents[level];
                    imageComponent.updateData(this.subImgUpdater, x /= 2, y /= 2, w, h);
                    this.image = imageComponent.getImage();
                    ++level;
                }
                ++step;
            }
            ++i;
        }
    }
}

