/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import com.sun.j3d.utils.image.TextureLoader;
import e3d.bezier.Needle;
import e3d.bezier.Position;
import e3d.euclidean.E3DVector;
import e3d.gui.icons.Icons;
import e3d.j3d.objects.J3DRectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;

public class J3DRuler
extends J3DRectangle {
    protected final J3DRectangle slider;
    protected final Timer timer = new Timer();
    protected TimerTask task = null;

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DRuler(Needle tangent, Parameters parameters) throws IOException {
        super(null, 0, parameters.rulerWidth, parameters.rulerHeight, parameters.rulerThickness, tangent, true, parameters);
        BufferedImage rulerImage = Icons.getAWTImage(parameters.rulerImage);
        TextureLoader rulerLoader = new TextureLoader(rulerImage);
        ImageComponent2D rulerImage2D = rulerLoader.getImage();
        Texture2D rulerTexture = new Texture2D(1, 6, rulerImage.getWidth(), rulerImage.getHeight());
        rulerTexture.setImage(0, (ImageComponent)rulerImage2D);
        rulerTexture.setEnable(true);
        rulerTexture.setMagFilter(0);
        this.setTexture1((Texture)rulerTexture);
        this.setTexture2((Texture)rulerTexture);
        Needle sliderTangent = new Needle(new Position(0.0, 0.0, 0.0), new E3DVector(0.0, 0.0, -1.0));
        this.slider = new J3DRectangle(null, 0, parameters.sliderWidth, parameters.sliderHeight, parameters.sliderThickness, sliderTangent, false, parameters);
        BufferedImage sliderImage = Icons.getAWTImage(parameters.sliderImage);
        TextureLoader sliderLoader = new TextureLoader(sliderImage);
        ImageComponent2D sliderImage2D = sliderLoader.getImage();
        Texture2D sliderTexture = new Texture2D(1, 6, sliderImage.getWidth(), sliderImage.getHeight());
        sliderTexture.setImage(0, (ImageComponent)sliderImage2D);
        sliderTexture.setEnable(true);
        sliderTexture.setMagFilter(0);
        this.slider.setTexture1((Texture)sliderTexture);
        this.slider.setTexture2((Texture)sliderTexture);
        this.slider.setTransparency(parameters.sliderTransparency);
        this.getAnchor().addChild((Node)this.slider);
    }

    @Override
    public Parameters getParameters() {
        return (Parameters)this.parameters;
    }

    public void setSliderPosition(double x) {
        if (this.task != null) {
            this.task.cancel();
        }
        double w = this.getParameters().rulerWidth - 2.0 * this.getParameters().rulerBorders;
        this.slider.getTangent().point.x = x = Math.max(0.0, Math.min(w, x));
        this.updateSliderPosition();
    }

    public void resetSliderPosition() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = new TimerTask(){

            @Override
            public void run() {
                J3DRuler.this.slider.getTangent().point.x *= J3DRuler.this.getParameters().sliderResetRate;
                J3DRuler.this.updateSliderPosition();
                if (J3DRuler.this.slider.getTangent().point.x < J3DRuler.this.getParameters().sliderThreshold) {
                    this.cancel();
                }
            }
        };
        this.timer.schedule(this.task, 0L, 16L);
    }

    private void updateSliderPosition() {
        double w = this.getParameters().rulerWidth;
        double x = this.getParameters().rulerBorders;
        E3DVector point = this.slider.getTangent().point;
        Transform3D transformation = new Transform3D();
        this.slider.getAnchor().getTransform(transformation);
        transformation.setTranslation(new Vector3d(point.x - w / 2.0 + x, 0.0, 0.0));
        this.slider.getAnchor().setTransform(transformation);
    }

    public static /* bridge */ /* synthetic */ J3DRectangle.Parameters getDefaultParameters() {
        return J3DRuler.getDefaultParameters();
    }

    public static class Parameters
    extends J3DRectangle.Parameters {
        public double rulerBorders = 0.05;
        public double rulerWidth = 2.1;
        public double rulerHeight = 0.25;
        public double rulerThickness = 0.01;
        public String rulerImage = "ruler.png";
        public double sliderWidth = 0.1;
        public double sliderHeight = 0.275;
        public double sliderThickness = 0.02;
        public String sliderImage = "rulerSlider.png";
        public float sliderTransparency = 0.25f;
        public double sliderResetRate = 0.25;
        public double sliderThreshold = this.rulerWidth / 1000.0;
    }
}

