/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import e3d.bezier.LayerMesh;
import e3d.bezier.Position;
import e3d.j3d.interfaces.J3DOrientedObject;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DSurface;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.util.J3DEventListener;
import e3d.texture.E3DTextureFile;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DMaterial;
import e3d.visualization.util.Matrix2D;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class J3DLayerMesh
extends J3DSurface
implements J3DOrientedObject {
    final LayerMeshAnchor anchor;
    protected J3DSurface.SurfaceShape shape;
    protected final Parameters parameters;
    protected final Transform3D transform;
    protected LayerMesh layerMesh;
    protected final Map<Integer, Texture2D> side2Texture;
    protected Matrix2D<Position> mesh;

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DLayerMesh(LayerMesh layerMesh, Parameters parameters) {
        super(new Color3f((float)layerMesh.color.getRed() / 255.0f, (float)layerMesh.color.getGreen() / 255.0f, (float)layerMesh.color.getBlue() / 255.0f));
        this.parameters = parameters;
        this.layerMesh = layerMesh;
        this.transform = new Transform3D(layerMesh.transform.getMatrix());
        this.transparency = (float)(255 - layerMesh.color.getAlpha()) / 255.0f;
        this.individualTexture = layerMesh.texture;
        this.side2Texture = new HashMap<Integer, Texture2D>();
        this.anchor = new LayerMeshAnchor(this.transform);
        this.anchor.setCapability(14);
        this.anchor.setCapability(13);
        this.anchor.setCapability(18);
        this.anchor.setCapability(17);
        this.setCapability(17);
        this.createSides();
        this.createShapes();
        this.addChild((Node)this.anchor);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void recreate() {
        this.createSides();
        this.createShapes();
    }

    protected BranchGroup createSides() {
        this.shape = new J3DSurface.SurfaceShape(this, this.color, this.parameters.polygonMode, this.parameters.shadeModel);
        this.shape.setCapability(13);
        this.setTransparency(this.transparency);
        if (this.parameters.polygonMode == 2) {
            for (Map.Entry<Integer, Texture2D> sideTexture : this.side2Texture.entrySet()) {
                int side = sideTexture.getKey();
                Texture2D texture = sideTexture.getValue();
                this.setTexture(texture, side);
            }
        }
        BranchGroup sides = new BranchGroup();
        sides.setCapability(17);
        sides.addChild((Node)this.shape);
        this.anchor.removeAllChildren();
        this.anchor.addChild((Node)sides);
        return sides;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public LayerMesh getMeshAttributes() {
        return this.layerMesh;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            this.shape.getAppearance().getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
        } else {
            this.shape.getAppearance().getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public void setTransparency(float transparency) {
        super.setTransparency(transparency);
        this.shape.setTransparency(transparency);
        this.layerMesh.color = new E3DColor(this.layerMesh.color.getRed(), this.layerMesh.color.getGreen(), this.layerMesh.color.getBlue(), (int)((1.0f - transparency) * 255.0f));
    }

    @Override
    public void setColor(Color3f color) {
        Color3f dimmed = new Color3f(color.x * 0.7f, color.y * 0.7f, color.z * 0.7f);
        this.shape.getAppearance().getMaterial().setAmbientColor(dimmed);
        this.shape.getAppearance().getMaterial().setDiffuseColor(dimmed);
        this.shape.getAppearance().getMaterial().setSpecularColor(dimmed);
        this.shape.getAppearance().getColoringAttributes().setColor(color);
        this.layerMesh.color = new E3DColor((int)(255.0f * color.x), (int)(255.0f * color.y), (int)(255.0f * color.z));
        this.color.set((Tuple3f)color);
    }

    @Override
    public void setMaterial(E3DMaterial material) {
        float shininess = material == null ? 64.0f : (float)(material.getGlossiness() * 127.0 + 1.0);
        this.shape.getAppearance().getMaterial().setShininess(shininess);
        this.material = this.layerMesh.material = material;
    }

    @Override
    public void setIndividualTexture(E3DTextureFile textureFile) {
        this.layerMesh.texture = this.individualTexture = textureFile;
    }

    @Override
    public void setTexture(Texture2D texture, int side) {
        if (side == 0) {
            if (texture == null) {
                this.side2Texture.remove(side);
            } else {
                this.side2Texture.put(side, texture);
            }
            if (this.parameters.polygonMode == 2) {
                if (texture == null) {
                    if (this.shape.getAppearance().getTextureUnitState(side) != null) {
                        this.shape.getAppearance().getTextureUnitState(side).setTexture(null);
                    }
                } else if (this.shape.getAppearance().getTextureUnitState(side) != null) {
                    this.shape.getAppearance().getTextureUnitState(side).setTexture((Texture)texture);
                }
            }
        }
    }

    @Override
    public Texture2D getTexture(int side) {
        return this.side2Texture.get(side);
    }

    @Override
    public void setGroup(J3DGroup group) {
        this.group = group;
        this.anchor.setTransform(this.createTransformation());
    }

    @Override
    protected J3DAnchor getAnchor() {
        return this.anchor;
    }

    @Override
    public void setRoundness(double roundness) {
        this.roundness = roundness;
    }

    public void setTransform(Transform3D transform) {
        this.transform.set(transform);
        this.anchor.setTransform(this.createTransformation());
    }

    public Transform3D getTransform() {
        return this.transform;
    }

    @Override
    public void orientate(J3DOrientedObject.Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL_MIRRORING: {
                this.mesh.mirrorHorizontal();
                break;
            }
            case VERTICAL_MIRRORING: {
                this.mesh.mirrorVertical();
                break;
            }
            case ROTATE_LEFT: {
                this.mesh.rotateLeft();
                break;
            }
            case ROTATE_RIGHT: {
                this.mesh.rotateRight();
            }
        }
        Geometry geometry = this.createGeometry(this.mesh, 0, 0, 1, 1, this.parameters.creaseAngle);
        if (geometry != null) {
            this.shape.setGeometry(geometry);
        }
    }

    @Override
    public void reshape() {
        this.anchor.setTransform(this.transform);
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    public void restore(LayerMesh layerMesh) throws Exception {
        this.layerMesh = layerMesh;
        this.color.set((float)layerMesh.color.getRed() / 255.0f, (float)layerMesh.color.getGreen() / 255.0f, (float)layerMesh.color.getBlue() / 255.0f);
        this.material = layerMesh.material;
        this.individualTexture = layerMesh.texture;
        this.transform.set(layerMesh.transform.getMatrix());
        this.anchor.setTransform(this.createTransformation());
        this.createShapes();
    }

    private void createShapes() {
        Geometry geometry = this.createGeometry();
        if (geometry != null) {
            this.shape.setGeometry(geometry);
        }
    }

    @Override
    public void updated() {
        this.update();
        for (J3DEventListener listener : this.listeners) {
            listener.updated(this);
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    @Override
    public void transformed(TransformGroup transformedAnchor, int type) {
        this.update();
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformed(this, transformedAnchor, type);
            }
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    private void update() {
        this.transform.setIdentity();
        this.transform(this.transform);
    }

    @Override
    public void transformationFinished(TransformGroup transformedAnchor, int type) {
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformationFinished(this, transformedAnchor, type);
            }
        }
    }

    protected Transform3D createTransformation() {
        Transform3D trans = new Transform3D(this.transform);
        if (this.group != null) {
            this.group.untransform(trans);
        }
        return trans;
    }

    protected Geometry createGeometry() {
        try {
            this.mesh = this.layerMesh.getMesh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.createGeometry(this.mesh, 0, 0, 1, 1, this.parameters.creaseAngle);
    }

    private J3DLayerMesh getThis() {
        return this;
    }

    protected class LayerMeshAnchor
    extends J3DAnchor {
        protected LayerMeshAnchor(Transform3D transformation) {
            super(transformation);
        }

        @Override
        public void transformed(int type) {
            J3DLayerMesh.this.getThis().transformed(this, type);
        }

        @Override
        public void transformationFinished(int type) {
            J3DLayerMesh.this.getThis().transformationFinished(this, type);
        }
    }

    public static class Parameters {
        public int polygonMode = 2;
        public int shadeModel = 0;
        public double creaseAngle = 1.0471975511965976;
    }
}

