/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.objects.J3DObject;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.util.J3DEventListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;

public class J3DGroup
extends J3DObject {
    protected final GroupAnchor anchor;
    protected final Transform3D transformation;
    protected final Transform3D invertedTransformation;
    protected final Parameters parameters;
    protected final Set<J3DInstance> objectSet = new HashSet<J3DInstance>();
    protected final List<J3DInstance> objectList = new LinkedList<J3DInstance>();

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DGroup(Parameters parameters) {
        this.parameters = parameters;
        this.transformation = new Transform3D();
        this.invertedTransformation = new Transform3D();
        this.anchor = new GroupAnchor(this.transformation);
        this.setPickable(true);
        this.setCapability(17);
        this.addChild((Node)this.anchor);
    }

    @Override
    public void recreate() {
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        int i = this.anchor.numChildren();
        while (i >= 0) {
            Node child = this.anchor.getChild(i);
            if (child instanceof J3DInstance) {
                ((J3DInstance)child).setSelected(selected);
            }
            --i;
        }
    }

    public Set<J3DInstance> getObjects() {
        return this.objectSet;
    }

    public List<J3DInstance> getObjectOrder() {
        return this.objectList;
    }

    @Override
    public J3DAnchor getAnchor() {
        return this.anchor;
    }

    public boolean contains(J3DInstance object) {
        return this.objectSet.contains(object);
    }

    @Override
    public void setGroup(J3DGroup group) {
        this.group = group;
        for (J3DInstance object : this.objectSet) {
            object.setGroup(this);
        }
    }

    public void addObject(J3DInstance object) {
        if (object.getGroup() != null) {
            object.getGroup().removeObject(object);
        }
        this.objectSet.add(object);
        this.objectList.add(object);
        this.anchor.addChild((Node)object);
        object.setGroup(this);
        for (J3DEventListener listener : this.listeners) {
            listener.assigned(this);
        }
    }

    public void removeObject(J3DInstance object) {
        if (this.contains(object)) {
            this.objectSet.remove(object);
            this.objectList.remove(object);
            object.setGroup(null);
            this.anchor.removeChild((Node)object);
            for (J3DEventListener listener : this.listeners) {
                listener.assigned(this);
            }
        }
    }

    public void removeAllObjects() {
        for (J3DInstance object : this.objectSet) {
            object.setGroup(null);
            this.anchor.removeChild((Node)object);
        }
        this.objectSet.clear();
        this.objectList.clear();
        for (J3DEventListener listener : this.listeners) {
            listener.assigned(this);
        }
    }

    @Override
    public void updated() {
        int i = this.anchor.numChildren() - 1;
        while (i >= 0) {
            Node child = this.anchor.getChild(i);
            if (child instanceof J3DInstance) {
                ((J3DInstance)child).updated();
            }
            --i;
        }
        for (J3DEventListener listener : this.listeners) {
            listener.updated(this);
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    @Override
    public void transformed(TransformGroup transformedAnchor, int type) {
        int i = this.anchor.numChildren() - 1;
        while (i >= 0) {
            Node child = this.anchor.getChild(i);
            if (child instanceof J3DInstance) {
                ((J3DInstance)child).transformed(transformedAnchor, type);
            }
            --i;
        }
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformed(this, transformedAnchor, type);
            }
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    @Override
    public void transformationFinished(TransformGroup transformedAnchor, int type) {
        int i = this.anchor.numChildren() - 1;
        while (i >= 0) {
            Node child = this.anchor.getChild(i);
            if (child instanceof J3DInstance) {
                ((J3DInstance)child).transformationFinished(transformedAnchor, type);
            }
            --i;
        }
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformationFinished(this, transformedAnchor, type);
            }
        }
    }

    @Override
    public void reshape() {
    }

    private J3DGroup getThis() {
        return this;
    }

    public class GroupAnchor
    extends J3DAnchor {
        protected GroupAnchor(Transform3D transformation) {
            super(transformation);
            this.setCapability(1);
            this.setCapability(18);
            this.setCapability(17);
            this.setCapability(14);
            this.setCapability(13);
            this.setCapability(12);
        }

        @Override
        public void transformed(int type) {
            J3DGroup.this.getThis().transformed(this, type);
        }

        @Override
        public void transformationFinished(int type) {
            J3DGroup.this.getThis().transformationFinished(this, type);
        }
    }

    public static class Parameters {
    }
}

