/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.PickIntersection;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DObject;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.objects.util.J3DAtomicPart;
import e3d.j3d.util.J3DEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class J3DDirectLight
extends J3DObject {
    protected Point3f position;
    protected final LightAnchor anchor;
    protected final Parameters parameters;
    protected final DirectionalLight light;

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DDirectLight(Color3f color, Point3f position, Parameters parameters) {
        this.position = position;
        this.parameters = parameters;
        this.createTransformation(position);
        this.anchor = new LightAnchor(this.transformation);
        this.anchor.setCapability(1);
        this.anchor.setCapability(18);
        this.anchor.setCapability(17);
        this.setPickable(true);
        LightSphere lightSphere = new LightSphere(color, parameters.lightSourceTransparency, parameters.lightSourceRadius);
        this.anchor.addChild((Node)lightSphere);
        this.light = new DirectionalLight(color, new Vector3f(-position.x, -position.y, -position.z));
        this.light.setInfluencingBounds(parameters.lightBounds);
        this.light.setCapability(19);
        this.setCapability(17);
        this.addChild((Node)this.anchor);
        this.addChild((Node)this.light);
    }

    @Override
    public void recreate() {
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public Vector3f getDirection() {
        return new Vector3f(-this.position.x, -this.position.y, -this.position.z);
    }

    public Point3f getPosition() {
        return this.position;
    }

    public void setPosition(Point3f position) {
        this.position = position;
        this.createTransformation(position);
        this.anchor.setTransform(this.transformation);
        this.light.setDirection(-position.x, -position.y, -position.z);
    }

    @Override
    public void setGroup(J3DGroup group) {
        this.group = group;
    }

    @Override
    protected J3DAnchor getAnchor() {
        return this.anchor;
    }

    protected void clicked(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.clicked(this, event, intersection);
        }
    }

    protected void movedOver(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.movedOver(this, event, intersection);
        }
    }

    protected void typed(KeyEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.typed(this, event, intersection);
        }
    }

    @Override
    public void updated() {
        this.update();
        for (J3DEventListener listener : this.listeners) {
            listener.updated(this);
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    @Override
    public void transformed(TransformGroup transformedAnchor, int type) {
        this.update();
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformed(this, transformedAnchor, type);
            }
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    private void update() {
        Point3f point = new Point3f(0.0f, 0.0f, 0.0f);
        if (this.group != null) {
            this.group.transform(point);
        }
        this.anchor.getTransform(this.transformation);
        this.transformation.transform(point);
        this.position = point;
        Vector3f direction = new Vector3f(-point.x, -point.y, -point.z);
        this.light.setDirection(direction);
    }

    @Override
    public void transformationFinished(TransformGroup transformedAnchor, int type) {
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformationFinished(this, transformedAnchor, type);
            }
        }
    }

    @Override
    public void reshape() {
    }

    protected void createTransformation(Point3f position) {
        this.transformation.setTranslation(new Vector3f(position.x, position.y, position.z));
    }

    private J3DDirectLight getThis() {
        return this;
    }

    protected class LightAnchor
    extends J3DAnchor {
        protected LightAnchor(Transform3D transformation) {
            super(transformation);
        }

        @Override
        public void transformed(int type) {
            J3DDirectLight.this.getThis().transformed(this, type);
        }

        @Override
        public void transformationFinished(int type) {
            J3DDirectLight.this.getThis().transformationFinished(this, type);
        }
    }

    protected class LightSphere
    extends Sphere
    implements J3DAtomicPart {
        protected LightSphere(Color3f color, float transparency, float radius) {
            super(radius);
            Material material = new Material();
            material.setAmbientColor(color);
            material.setDiffuseColor(color);
            material.setEmissiveColor(color);
            Appearance appearance = new Appearance();
            appearance.setPolygonAttributes(new PolygonAttributes(2, 1, 0.0f));
            appearance.setColoringAttributes(new ColoringAttributes(color, 0));
            appearance.setMaterial(material);
            appearance.setTransparencyAttributes(new TransparencyAttributes(0, transparency));
            appearance.setCapability(11);
            this.setAppearance(appearance);
        }

        @Override
        public void clicked(MouseEvent event, PickIntersection intersection) {
            J3DDirectLight.this.getThis().clicked(event, intersection);
        }

        @Override
        public void movedOver(MouseEvent event, PickIntersection intersection) {
            J3DDirectLight.this.getThis().movedOver(event, intersection);
        }

        @Override
        public void typed(KeyEvent event, PickIntersection intersection) {
            J3DDirectLight.this.getThis().typed(event, intersection);
        }

        @Override
        public void setTransparency(float transparency) {
            this.getAppearance().setTransparencyAttributes(new TransparencyAttributes(0, transparency));
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public J3DDirectLight getObject() {
            return J3DDirectLight.this.getThis();
        }
    }

    public static class Parameters {
        public float lightSourceRadius = 0.02f;
        public float lightSourceTransparency = 0.0f;
        public Bounds lightBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 50.0);
    }
}

