/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import e3d.euclidean.E3DVector;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.objects.J3DObject;
import e3d.j3d.objects.J3DSceneGroup;
import e3d.j3d.objects.util.J3DAtomicPart;
import java.util.HashSet;
import java.util.Set;
import javax.media.j3d.Node;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.vecmath.Point3d;

public abstract class J3DCenteredObject
extends J3DObject {
    public abstract E3DVector getCenter();

    public <T extends J3DCenteredObject> Set<T> getNeighbors(double radius, Class<T> type) {
        HashSet<J3DCenteredObject> neighbors = new HashSet<J3DCenteredObject>();
        J3DSceneGroup topmost = this.getSceneGroup();
        if (topmost != null) {
            E3DVector center = this.getCenter();
            Point3d start = new Point3d(center.x, center.y, center.z - radius);
            Point3d end = new Point3d(center.x, center.y, center.z + radius);
            topmost.transformScene(start);
            topmost.transformScene(end);
            PickCylinderSegment area = new PickCylinderSegment(start, end, radius);
            SceneGraphPath[] paths = topmost.pickAll((PickShape)area);
            if (paths != null) {
                SceneGraphPath[] sceneGraphPathArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    J3DCenteredObject neighbor;
                    J3DAtomicPart atom;
                    J3DInstance object;
                    SceneGraphPath path = sceneGraphPathArray[n2];
                    Node node = this.getAtomicPart(path.getObject());
                    if (node instanceof J3DAtomicPart && (object = (atom = (J3DAtomicPart)node).getObject()) != this && type.isInstance(object) && center.dist((neighbor = (J3DCenteredObject)type.cast(object)).getCenter()) <= radius) {
                        neighbors.add(neighbor);
                    }
                    ++n2;
                }
            }
        }
        return neighbors;
    }

    private Node getAtomicPart(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof J3DAtomicPart) {
            return node;
        }
        if (node.getParent() == null) {
            return null;
        }
        return this.getAtomicPart(node.getParent());
    }
}

