/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import com.sun.j3d.utils.picking.PickIntersection;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DObject;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.util.J3DEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;

public class J3DAmbientLight
extends J3DObject {
    protected final Parameters parameters;
    protected final AmbientLight light;

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DAmbientLight(Color3f color, Parameters parameters) {
        this.parameters = parameters;
        this.light = new AmbientLight(color);
        this.light.setInfluencingBounds(parameters.lightBounds);
        this.setCapability(17);
        this.addChild((Node)this.light);
    }

    @Override
    public void recreate() {
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setGroup(J3DGroup group) {
        this.group = group;
    }

    @Override
    protected J3DAnchor getAnchor() {
        return null;
    }

    protected void clicked(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.clicked(this, event, intersection);
        }
    }

    protected void typed(KeyEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.typed(this, event, intersection);
        }
    }

    @Override
    public void updated() {
    }

    @Override
    public void transformed(TransformGroup transformedAnchor, int type) {
    }

    @Override
    public void transformationFinished(TransformGroup transformedAnchor, int type) {
    }

    @Override
    public void reshape() {
    }

    public static class Parameters {
        public Bounds lightBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 50.0);
    }
}

