/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.history;

import e3d.bezier.Position;
import e3d.j3d.history.HistoryState;
import e3d.j3d.history.J3DHistory;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.interfaces.J3DSlaveObject;
import e3d.j3d.objects.J3DObject;
import e3d.j3d.objects.J3DPoint;
import java.util.Collection;
import java.util.Vector;

public class PointHistoryState
extends HistoryState {
    public static final int PRIORITY = 9;
    protected final J3DPoint point;
    protected Position position;
    protected boolean selected;
    protected Collection<J3DSlaveObject> slaves;
    protected Collection<String> tags;

    protected PointHistoryState(J3DPoint point, J3DHistory history) {
        super(history, 9);
        this.point = point;
        this.store(null, null);
    }

    private PointHistoryState(J3DPoint point, J3DHistory history, PointHistoryState predecessor, J3DHistory.Part part) {
        super(history, 9);
        this.point = point;
        this.store(predecessor, part);
    }

    private void store(PointHistoryState predecessor, J3DHistory.Part part) {
        this.selected = predecessor == null || part == J3DHistory.Part.SELECTION ? this.point.isSelected() : predecessor.selected;
        this.position = predecessor == null || part == J3DHistory.Part.SHAPE ? this.point.getPosition().clone() : predecessor.position;
        this.tags = predecessor == null || part == J3DHistory.Part.TAGS ? new Vector<String>(this.history.getTagger().getTags(this.point)) : predecessor.tags;
        this.slaves = predecessor == null || part == J3DHistory.Part.DEPENDECIES ? new Vector<J3DSlaveObject>(this.point.getDependencies().getSlaves()) : predecessor.slaves;
    }

    @Override
    public J3DObject getObject() {
        return this.point;
    }

    public Position getPosition() {
        return this.position;
    }

    @Override
    protected PointHistoryState changed(J3DHistory.Part part) {
        if (this.slice == this.history.currentSlice) {
            this.store(this, part);
            return this;
        }
        PointHistoryState historyState = new PointHistoryState(this.point, this.history, this, part);
        if (this.next != null) {
            this.next.previous = null;
        }
        this.next = historyState;
        historyState.previous = this;
        return historyState;
    }

    @Override
    protected void restore() {
        this.point.setPosition(this.position);
        this.point.setSelected(this.selected);
        this.point.getDependencies().removeAllSlaves();
        this.point.getDependencies().addSlaves(this.slaves);
        this.history.getTagger().removeObject(this.point);
        this.history.getTagger().addTags((J3DInstance)this.point, this.tags);
    }

    public String toString() {
        String[] pointNameParts = this.point.toString().split("[.@]");
        String[] stateNameParts = super.toString().split("[.@]");
        return "[" + this.slice + "]" + pointNameParts[pointNameParts.length - 2] + "@" + pointNameParts[pointNameParts.length - 1] + ":" + stateNameParts[stateNameParts.length - 1];
    }
}

