/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.history;

import e3d.j3d.history.HistoryState;
import e3d.j3d.history.J3DHistory;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.objects.J3DNeedle;
import e3d.j3d.objects.J3DNeedleMesh;
import e3d.j3d.objects.J3DObject;
import e3d.j3d.objects.J3DSurface;
import e3d.j3d.util.J3DTextureUtils;
import e3d.texture.E3DTextureFile;
import e3d.visualization.image.E3DImageAWT;
import e3d.visualization.util.E3DMaterial;
import e3d.visualization.util.Matrix2D;
import java.util.Collection;
import java.util.Vector;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture2D;
import javax.vecmath.Color3f;

public class NeedleMeshHistoryState
extends HistoryState {
    public static final int PRIORITY = 8;
    protected final J3DNeedleMesh meshShape;
    protected int width;
    protected int height;
    protected J3DNeedle[] needles;
    protected E3DMaterial material;
    protected double roundness;
    protected E3DTextureFile individualTextureFile;
    protected E3DImageAWT individualTexture;
    protected boolean useMipMapsForIndividualTexture;
    protected Color3f color;
    protected boolean selected;
    protected final Texture2D[] textures = new Texture2D[J3DSurface.BOX_SIDES.length];
    protected final boolean[] textured = new boolean[J3DSurface.BOX_SIDES.length];
    protected Collection<String> tags;

    protected NeedleMeshHistoryState(J3DNeedleMesh meshShape, J3DHistory history) {
        super(history, 8);
        this.meshShape = meshShape;
        this.store(null, null);
    }

    private NeedleMeshHistoryState(J3DNeedleMesh meshShape, J3DHistory history, NeedleMeshHistoryState predecessor, J3DHistory.Part part) {
        super(history, 8);
        this.meshShape = meshShape;
        this.store(predecessor, part);
    }

    private void store(NeedleMeshHistoryState predecessor, J3DHistory.Part part) {
        this.selected = predecessor == null || part == J3DHistory.Part.SELECTION ? this.meshShape.isSelected() : predecessor.selected;
        this.tags = predecessor == null || part == J3DHistory.Part.TAGS ? new Vector<String>(this.history.getTagger().getTags(this.meshShape)) : predecessor.tags;
        this.color = predecessor == null || part == J3DHistory.Part.COLOR ? new Color3f(this.meshShape.getColor()) : predecessor.color;
        int[] nArray = J3DSurface.BOX_SIDES;
        int n = J3DSurface.BOX_SIDES.length;
        int n2 = 0;
        while (n2 < n) {
            int side = nArray[n2];
            if (side >= 0) {
                this.textures[side] = this.meshShape.getTexture(side);
                this.textured[side] = this.meshShape.getTexture(side) != null;
            }
            ++n2;
        }
        if (predecessor == null || part == J3DHistory.Part.ORIENTATION) {
            Matrix2D<J3DNeedle> needles = this.meshShape.getMasters();
            this.width = needles.width();
            this.height = needles.height();
            this.needles = new J3DNeedle[this.width * this.height];
            int y = 0;
            int i = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    this.needles[i] = needles.get(x, y);
                    ++x;
                    ++i;
                }
                ++y;
            }
        } else {
            this.width = predecessor.width;
            this.height = predecessor.height;
            this.needles = predecessor.needles;
        }
        this.roundness = predecessor == null || part == J3DHistory.Part.ROUNDNESS ? this.meshShape.getRoundness() : predecessor.roundness;
        this.material = predecessor == null || part == J3DHistory.Part.MATERIAL ? (this.meshShape.getMaterial() == null ? null : this.meshShape.getMaterial().clone()) : predecessor.material;
        if (predecessor == null || part == J3DHistory.Part.TEXTURE) {
            this.individualTextureFile = this.meshShape.getIndividualTexture();
            Texture2D tex = this.meshShape.getTexture(0);
            if (tex != null) {
                ImageComponent2D imageComp = (ImageComponent2D)tex.getImage(0);
                this.individualTexture = new E3DImageAWT(imageComp.getImage()).clone();
                this.useMipMapsForIndividualTexture = tex.getMipMapMode() == 2;
            } else {
                this.individualTexture = null;
            }
        } else {
            this.individualTextureFile = predecessor.individualTextureFile;
            this.individualTexture = predecessor.individualTexture;
            this.useMipMapsForIndividualTexture = predecessor.useMipMapsForIndividualTexture;
        }
    }

    @Override
    public J3DObject getObject() {
        return this.meshShape;
    }

    @Override
    protected NeedleMeshHistoryState changed(J3DHistory.Part part) {
        if (this.slice == this.history.currentSlice) {
            this.store(this, part);
            return this;
        }
        NeedleMeshHistoryState historyState = new NeedleMeshHistoryState(this.meshShape, this.history, this, part);
        if (this.next != null) {
            this.next.previous = null;
        }
        this.next = historyState;
        historyState.previous = this;
        return historyState;
    }

    @Override
    protected void restore() {
        this.meshShape.restore(this.width, this.height, this.needles);
        if (this.individualTexture != null) {
            E3DImageAWT copy = this.individualTexture.clone();
            Texture2D tex = J3DTextureUtils.createTexture2D(copy.getBufferedImage(), true, false, false, this.useMipMapsForIndividualTexture);
            this.meshShape.setTexture(tex, 0);
        } else {
            this.meshShape.setTexture(null, 0);
        }
        int[] nArray = J3DSurface.BOX_SIDES;
        int n = J3DSurface.BOX_SIDES.length;
        int n2 = 0;
        while (n2 < n) {
            int side = nArray[n2];
            if (side >= 0) {
                this.meshShape.setTexture(this.textured[side] ? this.textures[side] : null, side);
            }
            ++n2;
        }
        this.meshShape.setSelected(this.selected);
        this.meshShape.setColor(this.color);
        this.meshShape.setRoundness(this.roundness);
        this.meshShape.setMaterial(this.material);
        this.meshShape.setIndividualTexture(this.individualTextureFile);
        this.history.getTagger().removeObject(this.meshShape);
        this.history.getTagger().addTags((J3DInstance)this.meshShape, this.tags);
    }

    public String toString() {
        String[] meshNameParts = this.meshShape.toString().split("[.@]");
        String[] stateNameParts = super.toString().split("[.@]");
        return "[" + this.slice + "]" + meshNameParts[meshNameParts.length - 2] + "@" + meshNameParts[meshNameParts.length - 1] + ":" + stateNameParts[stateNameParts.length - 1];
    }
}

