/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.history;

import e3d.bezier.Needle;
import e3d.j3d.history.HistoryState;
import e3d.j3d.history.J3DHistory;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.interfaces.J3DSlaveObject;
import e3d.j3d.objects.J3DNeedle;
import e3d.j3d.objects.J3DObject;
import java.util.Collection;
import java.util.Vector;

public class NeedleHistoryState
extends HistoryState {
    public static final int PRIORITY = 9;
    protected final J3DNeedle needle;
    protected Needle tangent;
    protected boolean selected;
    protected Collection<J3DSlaveObject> slaves;
    protected Collection<String> tags;

    protected NeedleHistoryState(J3DNeedle needle, J3DHistory history) {
        super(history, 9);
        this.needle = needle;
        this.store(null, null);
    }

    private NeedleHistoryState(J3DNeedle needle, J3DHistory history, NeedleHistoryState predecessor, J3DHistory.Part part) {
        super(history, 9);
        this.needle = needle;
        this.store(predecessor, part);
    }

    private void store(NeedleHistoryState predecessor, J3DHistory.Part part) {
        this.selected = predecessor == null || part == J3DHistory.Part.SELECTION ? this.needle.isSelected() : predecessor.selected;
        this.tangent = predecessor == null || part == J3DHistory.Part.SHAPE ? this.needle.getTangent().clone() : predecessor.tangent;
        this.tags = predecessor == null || part == J3DHistory.Part.TAGS ? new Vector<String>(this.history.getTagger().getTags(this.needle)) : predecessor.tags;
        this.slaves = predecessor == null || part == J3DHistory.Part.DEPENDECIES ? new Vector<J3DSlaveObject>(this.needle.getDependencies().getSlaves()) : predecessor.slaves;
    }

    @Override
    public J3DObject getObject() {
        return this.needle;
    }

    public Needle getTangent() {
        return this.tangent;
    }

    @Override
    protected NeedleHistoryState changed(J3DHistory.Part part) {
        if (this.slice == this.history.currentSlice) {
            this.store(this, part);
            return this;
        }
        NeedleHistoryState historyState = new NeedleHistoryState(this.needle, this.history, this, part);
        if (this.next != null) {
            this.next.previous = null;
        }
        this.next = historyState;
        historyState.previous = this;
        return historyState;
    }

    @Override
    protected void restore() {
        this.needle.setTangent(this.tangent);
        this.needle.setSelected(this.selected);
        this.needle.getDependencies().removeAllSlaves();
        this.needle.getDependencies().addSlaves(this.slaves);
        this.history.getTagger().removeObject(this.needle);
        this.history.getTagger().addTags((J3DInstance)this.needle, this.tags);
    }

    public String toString() {
        String[] needleNameParts = this.needle.toString().split("[.@]");
        String[] stateNameParts = super.toString().split("[.@]");
        return "[" + this.slice + "]" + needleNameParts[needleNameParts.length - 2] + "@" + needleNameParts[needleNameParts.length - 1] + ":" + stateNameParts[stateNameParts.length - 1];
    }
}

