/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.history;

import e3d.j3d.history.GroupHistoryState;
import e3d.j3d.history.HistoryState;
import e3d.j3d.history.LayerMeshHistoryState;
import e3d.j3d.history.NeedleHistoryState;
import e3d.j3d.history.NeedleMeshHistoryState;
import e3d.j3d.history.PointHistoryState;
import e3d.j3d.history.PointMeshHistoryState;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DLayerMesh;
import e3d.j3d.objects.J3DNeedle;
import e3d.j3d.objects.J3DNeedleMesh;
import e3d.j3d.objects.J3DPoint;
import e3d.j3d.objects.J3DPointMesh;
import e3d.j3d.objects.J3DSceneGroup;
import e3d.j3d.util.J3DEventAdapter;
import e3d.utils.Tagger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.media.j3d.TransformGroup;

public class J3DHistory {
    protected final Parameters parameters;
    protected final Map<J3DInstance, HistoryState> object2current = new HashMap<J3DInstance, HistoryState>();
    protected final Map<Integer, List<HistoryState>> slice2states = new HashMap<Integer, List<HistoryState>>();
    protected boolean move2nextSlice = false;
    protected int firstSlice = 0;
    protected int currentSlice = 0;
    protected int lastSlice = 0;
    protected final Tagger<J3DInstance> tagger;
    protected boolean ignore = false;

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DHistory(Parameters parameters, Tagger<J3DInstance> tagger) {
        this.parameters = parameters;
        this.tagger = tagger;
        this.slice2states.put(this.currentSlice, new Vector());
    }

    public Tagger<J3DInstance> getTagger() {
        return this.tagger;
    }

    public HistoryState getCurrent(J3DInstance object) {
        return this.object2current.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            this.move2nextSlice = false;
            this.firstSlice = 0;
            this.currentSlice = 0;
            this.lastSlice = 0;
            this.object2current.clear();
            this.slice2states.clear();
            this.slice2states.put(this.currentSlice, new Vector());
        }
    }

    public void next() {
        this.move2nextSlice = true;
        this.forget();
    }

    public boolean contains(J3DInstance object) {
        return this.object2current.containsKey(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forget() {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            int newFirstSlice = Math.max(this.firstSlice, this.currentSlice - this.parameters.historySize);
            int slice = this.firstSlice;
            while (slice < newFirstSlice) {
                for (HistoryState state : this.slice2states.get(slice)) {
                    if (state.next == null || state.next.slice > newFirstSlice) {
                        state.slice = newFirstSlice;
                        this.slice2states.get(newFirstSlice).add(state);
                        state.previous = null;
                        continue;
                    }
                    state.previous = null;
                    state.next.previous = null;
                    state.next = null;
                }
                this.slice2states.remove(slice);
                ++slice;
            }
            this.firstSlice = newFirstSlice;
        }
    }

    public boolean undoable() {
        return this.currentSlice > this.firstSlice;
    }

    public boolean redoable() {
        return this.currentSlice < this.lastSlice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            if (this.currentSlice > this.firstSlice) {
                this.ignore = true;
                List<HistoryState> historyStates = this.slice2states.get(this.currentSlice);
                Collections.sort(historyStates);
                for (HistoryState historyState : historyStates) {
                    if (historyState.previous == null) continue;
                    historyState.previous.restore();
                    this.object2current.put(historyState.getObject(), historyState.previous);
                }
                --this.currentSlice;
                this.move2nextSlice = true;
                this.ignore = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            if (this.currentSlice < this.lastSlice) {
                this.ignore = true;
                ++this.currentSlice;
                List<HistoryState> historyStates = this.slice2states.get(this.currentSlice);
                Collections.sort(historyStates);
                for (HistoryState historyState : historyStates) {
                    if (historyState == null) continue;
                    historyState.restore();
                    this.object2current.put(historyState.getObject(), historyState);
                }
                this.move2nextSlice = true;
                this.ignore = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final J3DGroup group) {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            GroupHistoryState historyState = new GroupHistoryState(group, this);
            this.slice2states.get(this.currentSlice).add(historyState);
            this.object2current.put(group, historyState);
            group.addEventListener(new J3DEventAdapter(){

                @Override
                public void assigned(J3DGroup group2) {
                    J3DHistory.this.changed(group2, Part.GROUP);
                }

                @Override
                public synchronized void transformed(J3DInstance object, TransformGroup anchor, int type) {
                    J3DHistory.this.changed(group, Part.TRANFORMATION);
                    if (!(object instanceof J3DSceneGroup)) {
                        for (J3DInstance child : group.getObjects()) {
                            J3DHistory.this.changed(child, Part.TRANFORMATION);
                        }
                    }
                }

                @Override
                public synchronized void transformationFinished(J3DInstance object, TransformGroup anchor, int type) {
                    J3DHistory.this.next();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final J3DNeedle needle) {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            NeedleHistoryState historyState = new NeedleHistoryState(needle, this);
            this.slice2states.get(this.currentSlice).add(historyState);
            this.object2current.put(needle, historyState);
            needle.addEventListener(new J3DEventAdapter(){

                @Override
                public synchronized void selected(J3DInstance object) {
                    J3DHistory.this.changed(needle, Part.SELECTION);
                }

                @Override
                public synchronized void colored(J3DInstance object) {
                    J3DHistory.this.changed(needle, Part.COLOR);
                }

                @Override
                public synchronized void reshaped(J3DInstance object) {
                    J3DHistory.this.changed(needle, Part.SHAPE);
                }

                @Override
                public synchronized void transformed(J3DInstance object, TransformGroup anchor, int type) {
                    J3DHistory.this.changed(needle, Part.TRANFORMATION);
                }

                @Override
                public synchronized void transformationFinished(J3DInstance object, TransformGroup anchor, int type) {
                    J3DHistory.this.next();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final J3DPoint point) {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            PointHistoryState historyState = new PointHistoryState(point, this);
            this.slice2states.get(this.currentSlice).add(historyState);
            this.object2current.put(point, historyState);
            point.addEventListener(new J3DEventAdapter(){

                @Override
                public synchronized void selected(J3DInstance object) {
                    J3DHistory.this.changed(point, Part.SELECTION);
                }

                @Override
                public synchronized void colored(J3DInstance object) {
                    J3DHistory.this.changed(point, Part.COLOR);
                }

                @Override
                public synchronized void reshaped(J3DInstance object) {
                    J3DHistory.this.changed(point, Part.SHAPE);
                }

                @Override
                public synchronized void transformed(J3DInstance object, TransformGroup anchor, int type) {
                    J3DHistory.this.changed(point, Part.TRANFORMATION);
                }

                @Override
                public synchronized void transformationFinished(J3DInstance object, TransformGroup anchor, int type) {
                    J3DHistory.this.next();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final J3DNeedleMesh mesh) {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            NeedleMeshHistoryState historyState = new NeedleMeshHistoryState(mesh, this);
            this.slice2states.get(this.currentSlice).add(historyState);
            this.object2current.put(mesh, historyState);
            mesh.addEventListener(new J3DEventAdapter(){

                @Override
                public synchronized void reshaped(J3DInstance object) {
                    J3DHistory.this.changed(mesh, Part.SHAPE);
                }

                @Override
                public synchronized void selected(J3DInstance object) {
                    J3DHistory.this.changed(mesh, Part.SELECTION);
                }

                @Override
                public synchronized void colored(J3DInstance object) {
                    J3DHistory.this.changed(mesh, Part.COLOR);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final J3DPointMesh mesh) {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            PointMeshHistoryState historyState = new PointMeshHistoryState(mesh, this);
            this.slice2states.get(this.currentSlice).add(historyState);
            this.object2current.put(mesh, historyState);
            mesh.addEventListener(new J3DEventAdapter(){

                @Override
                public synchronized void reshaped(J3DInstance object) {
                    J3DHistory.this.changed(mesh, Part.SHAPE);
                }

                @Override
                public synchronized void selected(J3DInstance object) {
                    J3DHistory.this.changed(mesh, Part.SELECTION);
                }

                @Override
                public synchronized void colored(J3DInstance object) {
                    J3DHistory.this.changed(mesh, Part.COLOR);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final J3DLayerMesh mesh) {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            LayerMeshHistoryState historyState = new LayerMeshHistoryState(mesh, this);
            this.slice2states.get(this.currentSlice).add(historyState);
            this.object2current.put(mesh, historyState);
            mesh.addEventListener(new J3DEventAdapter(){

                @Override
                public synchronized void reshaped(J3DInstance object) {
                    J3DHistory.this.changed(mesh, Part.SHAPE);
                }

                @Override
                public synchronized void selected(J3DInstance object) {
                    J3DHistory.this.changed(mesh, Part.SELECTION);
                }

                @Override
                public synchronized void colored(J3DInstance object) {
                    J3DHistory.this.changed(mesh, Part.COLOR);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(J3DInstance object, Part part) {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            HistoryState oldState;
            if (!this.ignore && (oldState = this.object2current.get(object)) != null) {
                HistoryState newState;
                if (this.move2nextSlice) {
                    ++this.currentSlice;
                    this.lastSlice = Math.max(this.lastSlice, this.currentSlice);
                    this.slice2states.put(this.currentSlice, new Vector());
                    this.move2nextSlice = false;
                }
                if ((newState = oldState.changed(part)) != oldState) {
                    this.slice2states.get(newState.slice).add(newState);
                    this.object2current.put(object, newState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<J3DInstance, HistoryState> map = this.object2current;
        synchronized (map) {
            StringBuffer string = new StringBuffer("HISTORY:\n  CURRENT SLICE = " + this.currentSlice + "\n");
            for (J3DInstance object : this.object2current.keySet()) {
                string.append("  #");
                HistoryState state = this.getFirst(this.object2current.get(object));
                while (state != null) {
                    if (this.object2current.get(object) == state) {
                        string.append(" *");
                    } else {
                        string.append("  ");
                    }
                    string.append("-> " + state.toString());
                    state = state.next;
                }
                string.append("\n");
            }
            for (Integer slice : this.slice2states.keySet()) {
                string.append("  [" + slice + "]");
                for (HistoryState state : this.slice2states.get(slice)) {
                    string.append(" " + state.toString());
                }
                string.append("\n");
            }
            return string.toString();
        }
    }

    private HistoryState getFirst(HistoryState state) {
        return state.previous == null ? state : this.getFirst(state.previous);
    }

    public static class Parameters {
        int historySize = 25;
    }

    public static enum Part {
        GROUP,
        SELECTION,
        COLOR,
        MATERIAL,
        TAGS,
        ROUNDNESS,
        SHAPE,
        TRANFORMATION,
        ORIENTATION,
        TEXTURE,
        DEPENDECIES;

    }
}

