/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.history;

import e3d.j3d.history.J3DHistory;
import e3d.j3d.interfaces.J3DInstance;

public abstract class HistoryState
implements Comparable<HistoryState> {
    protected final J3DHistory history;
    protected int slice = 0;
    protected final int priority;
    protected HistoryState previous = null;
    protected HistoryState next = null;

    protected HistoryState(J3DHistory history, int priority) {
        this.history = history;
        this.slice = history.currentSlice;
        this.priority = priority;
    }

    public abstract J3DInstance getObject();

    public HistoryState getPrevious() {
        return this.previous;
    }

    public HistoryState getNext() {
        return this.next;
    }

    protected abstract HistoryState changed(J3DHistory.Part var1);

    protected abstract void restore();

    @Override
    public int compareTo(HistoryState otherHistoryState) {
        if (this.priority < otherHistoryState.priority) {
            return 1;
        }
        if (this.priority > otherHistoryState.priority) {
            return -1;
        }
        return 0;
    }
}

