/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.history;

import e3d.j3d.history.HistoryState;
import e3d.j3d.history.J3DHistory;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.objects.J3DGroup;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.media.j3d.Transform3D;

public class GroupHistoryState
extends HistoryState {
    public static final int PRIORITY = 10;
    protected final J3DGroup group;
    protected Set<J3DInstance> objects;
    protected final Transform3D transformation = new Transform3D();

    protected GroupHistoryState(J3DGroup group, J3DHistory history) {
        super(history, 10);
        this.group = group;
        this.objects = new HashSet<J3DInstance>(group.getObjects());
        group.getAnchor().getTransform(this.transformation);
    }

    @Override
    public J3DInstance getObject() {
        return this.group;
    }

    public Transform3D getTransform() {
        return this.transformation;
    }

    @Override
    protected GroupHistoryState changed(J3DHistory.Part part) {
        if (this.slice == this.history.currentSlice) {
            this.objects = new HashSet<J3DInstance>(this.group.getObjects());
            this.group.getAnchor().getTransform(this.transformation);
            return this;
        }
        GroupHistoryState historyState = new GroupHistoryState(this.group, this.history);
        if (this.next != null) {
            this.next.previous = null;
        }
        this.next = historyState;
        historyState.previous = this;
        return historyState;
    }

    @Override
    protected void restore() {
        for (J3DInstance object : this.objects) {
            if (this.group.contains(object)) continue;
            this.group.addObject(object);
        }
        for (J3DInstance object : new Vector<J3DInstance>(this.group.getObjects())) {
            if (this.objects.contains(object) || !this.history.contains(object)) continue;
            this.group.removeObject(object);
        }
        this.group.getAnchor().setTransform(this.transformation);
    }

    public String toString() {
        String[] groupNameParts = this.group.toString().split("[.@]");
        String[] stateNameParts = super.toString().split("[.@]");
        return "[" + this.slice + "]" + groupNameParts[groupNameParts.length - 2] + "@" + groupNameParts[groupNameParts.length - 1] + ":" + stateNameParts[stateNameParts.length - 1];
    }
}

