/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.examples;

import e3d.j3d.examples.TornadoMouseBehavior;
import e3d.j3d.examples.TranslationChangeListener;
import java.awt.event.MouseEvent;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class TornadoMouseTranslate
extends TornadoMouseBehavior {
    private float m_Scale = 1.0f;
    protected Point3d m_MinTranslate = null;
    protected Point3d m_MaxTranslate = null;

    public TornadoMouseTranslate(float scale) {
        this.m_Scale = scale;
        this.m_MinTranslate = new Point3d(-10.0, -10.0, -10.0);
        this.m_MaxTranslate = new Point3d(10.0, 10.0, 10.0);
    }

    public void setMinTranslate(Point3d minTrans) {
        this.m_MinTranslate = minTrans;
    }

    public void setMaxTranslate(Point3d maxTrans) {
        this.m_MaxTranslate = maxTrans;
    }

    @Override
    protected boolean isStartBehaviorEvent(MouseEvent evt) {
        int nId = evt.getID();
        return nId == 506 && !evt.isAltDown() && evt.isMetaDown();
    }

    @Override
    protected void applyVectorToObject(Vector3f vector) {
        TransformGroup tg = this.getTransformGroup();
        if (tg != null) {
            vector.scale(this.m_Scale);
            Vector3d vTranslation = new Vector3d();
            tg.getTransform(this.m_Transform3D);
            this.m_Transform3D.get(vTranslation);
            vTranslation.x += (double)vector.x;
            vTranslation.y += (double)vector.y;
            vTranslation.z += (double)vector.z;
            if (vTranslation.x >= this.m_MinTranslate.x && vTranslation.y >= this.m_MinTranslate.y && vTranslation.z >= this.m_MinTranslate.z && vTranslation.x <= this.m_MaxTranslate.x && vTranslation.y <= this.m_MaxTranslate.y && vTranslation.z <= this.m_MaxTranslate.z) {
                this.m_Transform3D.setTranslation(vTranslation);
                this.applyTransform();
                if (this.m_Listener != null) {
                    ((TranslationChangeListener)this.m_Listener).onTranslate(this.m_Object, vTranslation);
                }
            }
        }
    }
}

