/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.examples;

import e3d.j3d.examples.ScaleChangeListener;
import e3d.j3d.examples.TornadoMouseBehavior;
import java.awt.event.MouseEvent;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class TornadoMouseScale
extends TornadoMouseBehavior {
    protected float m_Delta = 0.0f;
    protected float m_Threshold = 0.0f;
    protected Point3d m_MinScale;
    protected Point3d m_MaxScale;

    public TornadoMouseScale(float threshold, float delta) {
        this.m_Delta = delta;
        this.m_Threshold = threshold;
        this.m_MinScale = new Point3d(0.1, 0.1, 0.1);
        this.m_MaxScale = new Point3d(5.0, 5.0, 5.0);
    }

    public void setMinScale(Point3d minScale) {
        this.m_MinScale = minScale;
    }

    public void setMaxScale(Point3d maxScale) {
        this.m_MaxScale = maxScale;
    }

    @Override
    protected boolean isRelativeToObjectCoordinates() {
        return true;
    }

    @Override
    protected boolean isStartBehaviorEvent(MouseEvent evt) {
        int nId = evt.getID();
        return nId == 506 && evt.isAltDown() && !evt.isMetaDown();
    }

    @Override
    protected void applyVectorToObject(Vector3f vector) {
        TransformGroup tg = this.getTransformGroup();
        if (tg != null) {
            tg.getTransform(this.m_Transform3D);
            Vector3d vScale = new Vector3d();
            this.m_Transform3D.getScale(vScale);
            Vector3f delta = new Vector3f();
            if (vector.x > this.m_Threshold) {
                delta.x = this.m_Delta;
            } else if (vector.x < -this.m_Threshold) {
                delta.x = -this.m_Delta;
            }
            if (vector.y > this.m_Threshold) {
                delta.y = this.m_Delta;
            } else if (vector.y < -this.m_Threshold) {
                delta.y = -this.m_Delta;
            }
            if (vector.z > this.m_Threshold) {
                delta.z = this.m_Delta;
            } else if (vector.z < -this.m_Threshold) {
                delta.z = -this.m_Delta;
            }
            Vector3d objectScale = new Vector3d(vScale.x + (double)delta.x, vScale.y + (double)delta.y, vScale.z + (double)delta.z);
            if (objectScale.x >= this.m_MinScale.x && objectScale.y >= this.m_MinScale.y && objectScale.z >= this.m_MinScale.z && objectScale.x <= this.m_MaxScale.x && objectScale.y <= this.m_MaxScale.y && objectScale.z <= this.m_MaxScale.z) {
                this.m_Transform3D.setScale(objectScale);
                this.applyTransform();
                if (this.m_Listener != null) {
                    ((ScaleChangeListener)this.m_Listener).onScale(this.m_Object, objectScale);
                }
            }
        }
    }
}

