/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.examples;

import e3d.j3d.examples.Euler;
import e3d.j3d.examples.RotationChangeListener;
import e3d.j3d.examples.TornadoMouseBehavior;
import java.awt.event.MouseEvent;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class TornadoMouseRotate
extends TornadoMouseBehavior {
    protected double m_FactorX = 0.001;
    protected double m_FactorY = 0.001;
    protected Transform3D m_TransformX = null;
    protected Transform3D m_TransformY = null;
    protected boolean m_bInvert = false;

    public TornadoMouseRotate(double xf, double yf) {
        this.m_FactorX = xf;
        this.m_FactorY = yf;
        this.m_TransformX = new Transform3D();
        this.m_TransformY = new Transform3D();
        this.m_bInvert = false;
    }

    @Override
    protected boolean isStartBehaviorEvent(MouseEvent evt) {
        int nId = evt.getID();
        return nId == 506 && !evt.isAltDown() && !evt.isMetaDown();
    }

    public void setInvert(boolean bInvert) {
        this.m_bInvert = bInvert;
    }

    @Override
    protected boolean isRelativeToObjectCoordinates() {
        return false;
    }

    @Override
    protected void applyVectorToObject(Vector3f vector) {
        TransformGroup tg = this.getTransformGroup();
        if (tg != null) {
            tg.getTransform(this.m_Transform3D);
            double x_angle = (double)vector.y * this.m_FactorX;
            double y_angle = (double)vector.x * this.m_FactorY;
            this.m_TransformX.rotX(x_angle);
            this.m_TransformY.rotY(y_angle);
            Matrix4d mat = new Matrix4d();
            this.m_Transform3D.get(mat);
            this.m_Transform3D.setTranslation(new Vector3d(0.0, 0.0, 0.0));
            if (this.m_bInvert) {
                this.m_Transform3D.mul(this.m_Transform3D, this.m_TransformX);
                this.m_Transform3D.mul(this.m_Transform3D, this.m_TransformY);
            } else {
                this.m_Transform3D.mul(this.m_TransformX, this.m_Transform3D);
                this.m_Transform3D.mul(this.m_TransformY, this.m_Transform3D);
            }
            Vector3d translation = new Vector3d(mat.m03, mat.m13, mat.m23);
            this.m_Transform3D.setTranslation(translation);
            this.applyTransform();
            if (this.m_Listener != null) {
                Point3d rotate = Euler.getEulerRotation(this.m_Transform3D);
                ((RotationChangeListener)this.m_Listener).onRotate(this.m_Object, rotate);
            }
        }
    }
}

